/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeySizeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSetExtent;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMap;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMapMesher;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.geometry.data3d.impl.DigitalElevationMapSamplerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalElevationMapSamplerCustomImpl
extends DigitalElevationMapSamplerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(DigitalElevationMapSamplerImpl.class);
    private double[] queryBuffer1;
    private double[] queryBuffer2;

    public DigitalElevationMap doProcess(DigitalElevationMap input, IProgressMonitor monitor) throws Exception {
        DigitalElevationMapMesher mesher = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMapMesher();
        CartesianTriangularMesh mesh = (CartesianTriangularMesh)mesher.process(input);
        List<CartesianPositionCoordinates> gridPoints = this.createSamplingGrid((DigitalElevationMap)this.getInput(), this.getTargetResolution());
        return this.sample(mesh, gridPoints);
    }

    private List<CartesianPositionCoordinates> createSamplingGrid(DigitalElevationMap dem, double resolution) {
        ArrayList<CartesianPositionCoordinates> result = new ArrayList<CartesianPositionCoordinates>();
        int xDim = this.getTargetDEMXDimension();
        int yDim = this.getTargetDEMYDimension();
        double minX = this.getMinX();
        double minY = this.getMinY();
        double x = this.getMinX();
        double y = minY;
        int i = 0;
        while (i < xDim) {
            x = minX + (double)i * this.getTargetResolution();
            int j = 0;
            while (j < yDim) {
                y = minY + (double)j * this.getTargetResolution();
                result.add(ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, 0.0));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private DigitalElevationMap sample(CartesianTriangularMesh mesh, List<CartesianPositionCoordinates> samplingGrid) {
        DigitalElevationMap result = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMap();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)this.progressMonitor, (int)4);
        Point3d[][] pixelsLocation = this.getPixelsLocation(mesh, this.getTargetResolution(), (IProgressMonitor)subMonitor.newChild(1));
        KDTree kdTree = this.createTriangleKDTree(mesh, (IProgressMonitor)subMonitor.newChild(1));
        Point3d[][] pixelsIntersectionPoints = this.getPixelsIntersectionPoints(pixelsLocation, mesh, kdTree, this.getTargetResolution(), (IProgressMonitor)subMonitor.newChild(1));
        int numberPixelAlongX = pixelsLocation.length;
        int numberPixelAlongY = pixelsLocation[0].length;
        int i = 0;
        while (i < numberPixelAlongX) {
            int j = 0;
            while (j < numberPixelAlongY) {
                Point3d point = pixelsIntersectionPoints[i][j];
                if (point != null) {
                    CartesianPositionCoordinates p = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
                    result.getPoints().add((Object)p);
                }
                ++j;
            }
            ++i;
        }
        result.setXDimension(numberPixelAlongX);
        result.setYDimension(numberPixelAlongY);
        return result;
    }

    private double getMaxX() {
        double max = Double.NEGATIVE_INFINITY;
        for (CartesianPositionCoordinates p : ((DigitalElevationMap)this.getInput()).getPoints()) {
            if (!(p.getX() > max)) continue;
            max = p.getX();
        }
        return max;
    }

    private double getMaxY() {
        double max = Double.NEGATIVE_INFINITY;
        for (CartesianPositionCoordinates p : ((DigitalElevationMap)this.getInput()).getPoints()) {
            if (!(p.getY() > max)) continue;
            max = p.getY();
        }
        return max;
    }

    private double getMinX() {
        double min = Double.POSITIVE_INFINITY;
        for (CartesianPositionCoordinates p : ((DigitalElevationMap)this.getInput()).getPoints()) {
            if (!(p.getX() < min)) continue;
            min = p.getX();
        }
        return min;
    }

    private double getMinY() {
        double min = Double.POSITIVE_INFINITY;
        for (CartesianPositionCoordinates p : ((DigitalElevationMap)this.getInput()).getPoints()) {
            if (!(p.getY() < min)) continue;
            min = p.getY();
        }
        return min;
    }

    private int getTargetDEMXDimension() {
        double min = this.getMinX();
        double max = this.getMaxX();
        return (int)Math.floor((max - min) / this.getTargetResolution()) + 1;
    }

    private int getTargetDEMYDimension() {
        double min = this.getMinY();
        double max = this.getMaxY();
        return (int)Math.floor((max - min) / this.getTargetResolution()) + 1;
    }

    protected List<CartesianTriangle> findClosestTriangles(KDTree kdTree, Point3d centerPoint) {
        ArrayList<CartesianTriangle> closestTriangle = new ArrayList<CartesianTriangle>();
        double[] key = new double[]{centerPoint.getX(), centerPoint.getY()};
        try {
            Object[] range = kdTree.nearest(key, 6);
            int i = 0;
            while (i < range.length) {
                if (range[i] instanceof List) {
                    closestTriangle.addAll((List)range[i]);
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        catch (KeySizeException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return closestTriangle;
    }

    private double[] getQueryBuffer1() {
        if (this.queryBuffer1 == null) {
            this.queryBuffer1 = new double[2];
        }
        return this.queryBuffer1;
    }

    private double[] getQueryBuffer2() {
        if (this.queryBuffer2 == null) {
            this.queryBuffer2 = new double[2];
        }
        return this.queryBuffer2;
    }

    protected List<CartesianTriangle> findTrianglesWithinRadius(KDTree kdTree, double radius, Point3d centerPoint) {
        ArrayList<CartesianTriangle> trianglesWithinRadius = new ArrayList<CartesianTriangle>();
        this.getQueryBuffer1()[0] = centerPoint.getX() - Math.abs(radius);
        this.getQueryBuffer1()[1] = centerPoint.getY() - Math.abs(radius);
        this.getQueryBuffer2()[0] = centerPoint.getX() + Math.abs(radius);
        this.getQueryBuffer2()[1] = centerPoint.getY() + Math.abs(radius);
        try {
            Object[] range = kdTree.range(this.getQueryBuffer1(), this.getQueryBuffer2());
            int i = 0;
            while (i < range.length) {
                if (range[i] instanceof List) {
                    trianglesWithinRadius.addAll((List)range[i]);
                }
                ++i;
            }
        }
        catch (KeySizeException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return trianglesWithinRadius;
    }

    protected int getNumberOfProcessorToUse() {
        int cores = Runtime.getRuntime().availableProcessors();
        if (cores > 1) {
            --cores;
        }
        return cores;
    }

    protected KDTree createTriangleKDTree(CartesianTriangularMesh mesh, IProgressMonitor progressMonitor) {
        CreateKDTreeJob job = new CreateKDTreeJob("Create KD Tree", "KDTreeCreation", mesh);
        try {
            job.setProgressGroup(progressMonitor, job.getNumberOfTicks());
            job.schedule();
            job.join();
            return job.getOutput();
        }
        catch (InterruptedException e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected Point3d[][] getPixelsLocation(CartesianTriangularMesh mesh, double resolution, IProgressMonitor progressMonitor) {
        CreatePixelLocationJob job = new CreatePixelLocationJob("Get Pixel Locations", "GetPixelLocation", mesh, resolution);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)job.getNumberOfTicks());
        try {
            job.setProgressGroup((IProgressMonitor)subMonitor, job.getNumberOfTicks());
            job.schedule();
            job.join();
            return job.getOutput();
        }
        catch (InterruptedException e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected Point3d[][] getPixelsIntersectionPoints(Point3d[][] pixelsLocation, CartesianTriangularMesh mesh, KDTree kdTree, double averagingRadius, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding pixel intersection with mesh.");
        int numberPixelAlongX = pixelsLocation.length;
        int numberPixelAlongY = pixelsLocation[0].length;
        Point3d[][] intersectionPoints = new Point3d[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetPixelsIntersectionPoints";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "GetPixel Intersection (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetPixelsIntersectionPointsJob(jobName, "GetPixelsIntersectionPoints", xStartIndex, xEndIndex, mesh, pixelsLocation, intersectionPoints, kdTree, averagingRadius).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressMonitor.done();
        return intersectionPoints;
    }

    protected class CreateKDTreeJob
    extends CustomJob<KDTree> {
        protected CartesianTriangularMesh mesh;
        protected KDTree kdTree;

        public CreateKDTreeJob(String name, String family, CartesianTriangularMesh mesh) {
            super(name, family);
            this.mesh = null;
            this.mesh = mesh;
            this.numberOfTicks = mesh.getPolygons().size();
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Create KD Tree", this.numberOfTicks);
            Logger.info("KDTree building starts.");
            long startTime = System.currentTimeMillis();
            this.kdTree = new KDTree(2);
            long keyCount = 0L;
            for (CartesianTriangle triangle : this.mesh.getPolygons()) {
                for (CartesianPositionCoordinates vertex : triangle.getVertices()) {
                    EList triangles = this.mesh.getPolygonsSharingPoint(vertex);
                    triangles.add(triangle);
                    CartesianPositionCoordinates center = triangle.getCentroid();
                    double[] key = new double[]{center.getX(), center.getY()};
                    try {
                        this.kdTree.insert(key, (Object)triangles);
                        ++keyCount;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                monitor.worked(1);
            }
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) * 0.001;
            Logger.info("KDTree built completed. KDTree contains <" + keyCount + "> keys and was built in <" + duration + "> seconds.");
            return Status.OK_STATUS;
        }

        @Override
        public KDTree getOutput() {
            return this.kdTree;
        }
    }

    protected class CreatePixelLocationJob
    extends CustomJob<Point3d[][]> {
        protected CartesianTriangularMesh mesh;
        protected CartesianCoordinatesSetExtent extent;
        protected double resolution;
        protected Point3d[][] points;
        protected int numberPointsAlongX;
        protected int numberPointsAlongY;

        public CreatePixelLocationJob(String name, String family, CartesianTriangularMesh mesh, double resolution) {
            super(name, family);
            this.mesh = null;
            this.extent = null;
            this.resolution = 1.0;
            this.numberPointsAlongX = 0;
            this.numberPointsAlongY = 0;
            this.mesh = mesh;
            this.extent = mesh.getExtent();
            this.resolution = resolution;
            this.numberPointsAlongX = (int)Math.round(this.extent.getXDimension() / resolution);
            this.numberPointsAlongY = (int)Math.round(this.extent.getYDimension() / resolution);
            this.numberOfTicks = this.numberPointsAlongX * this.numberPointsAlongY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Create Pixel Location", this.numberOfTicks);
            this.points = new Point3d[this.numberPointsAlongX][this.numberPointsAlongY];
            double xIncrement = this.resolution;
            double yIncrement = this.resolution;
            double x = this.extent.getXMin() + xIncrement / 2.0;
            int i = 0;
            while (i < this.numberPointsAlongX) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                double y = this.extent.getYMin() + yIncrement / 2.0;
                int j = 0;
                while (j < this.numberPointsAlongY) {
                    Point3d point;
                    this.points[i][j] = point = new Point3d(x, y, 0.0);
                    y += yIncrement;
                    ++j;
                }
                monitor.worked(this.numberPointsAlongY);
                x += xIncrement;
                ++i;
            }
            return Status.OK_STATUS;
        }

        @Override
        public Point3d[][] getOutput() {
            return this.points;
        }
    }

    protected abstract class CustomJob<T>
    extends Job {
        protected String name;
        protected String family;
        protected int numberOfTicks;

        public CustomJob(String name, String family) {
            super(name);
            this.numberOfTicks = 0;
            this.name = name;
            this.family = family;
        }

        public boolean belongsTo(Object family) {
            return this.family.equals(family);
        }

        public int getNumberOfTicks() {
            return this.numberOfTicks;
        }

        public abstract T getOutput();
    }

    protected class GetPixelsIntersectionPointsJob
    extends ProcessArrayJob<Point3d[][]> {
        protected KDTree kdTree;
        protected Point3d[][] intersectionPoints;
        protected double averagingRadius;

        public GetPixelsIntersectionPointsJob(String name, String family, int xStartIndex, int xEndIndex, CartesianTriangularMesh mesh, Point3d[][] pixelsLocation, Point3d[][] intersectionPoints, KDTree kdTree, double averagingRadius) {
            super(name, family, xStartIndex, xEndIndex, mesh, pixelsLocation);
            this.averagingRadius = 0.0;
            this.kdTree = kdTree;
            this.intersectionPoints = intersectionPoints;
            this.averagingRadius = averagingRadius;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Pixel Intersections", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsLocation[0].length;
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Point3d point = this.pixelsLocation[i][j];
                    List<CartesianTriangle> triangles = DigitalElevationMapSamplerCustomImpl.this.findClosestTriangles(this.kdTree, point);
                    Iterator<CartesianTriangle> it = triangles.iterator();
                    CartesianPositionCoordinates projection = null;
                    while (it.hasNext() && projection == null) {
                        projection = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon(CartesianAxis.Z, point, (CartesianPolygon)it.next());
                        if (projection == null) continue;
                        this.intersectionPoints[i][j] = projection.asPoint3d();
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            return Status.OK_STATUS;
        }

        @Override
        public Point3d[][] getOutput() {
            return this.intersectionPoints;
        }

        protected Point3d getAveragedHeight(KDTree kdTree, CartesianPositionCoordinates projection, double averagingRadius) {
            if (averagingRadius > 0.0) {
                List<CartesianTriangle> triangles = DigitalElevationMapSamplerCustomImpl.this.findTrianglesWithinRadius(kdTree, averagingRadius, projection.asPoint3d());
                double averagedHeight = 0.0;
                double totalSurface = 0.0;
                for (CartesianTriangle triangle : triangles) {
                    averagedHeight += (totalSurface += triangle.getSurface()) * triangle.getCentroid().getZ();
                }
                return new Point3d(projection.getX(), projection.getY(), averagedHeight /= totalSurface);
            }
            return projection.asPoint3d();
        }
    }

    protected class GetPixelsIntersectionTrianglesJob
    extends ProcessArrayJob<CartesianTriangle[][]> {
        protected KDTree kdTree;
        protected CartesianTriangle[][] intersectionTriangles;
        protected double averagingRadius;

        public GetPixelsIntersectionTrianglesJob(String name, String family, int xStartIndex, int xEndIndex, CartesianTriangularMesh mesh, Point3d[][] pixelsLocation, CartesianTriangle[][] intersectionTriangles, KDTree kdTree, double averagingRadius) {
            super(name, family, xStartIndex, xEndIndex, mesh, pixelsLocation);
            this.averagingRadius = 0.0;
            this.kdTree = kdTree;
            this.averagingRadius = averagingRadius;
            this.intersectionTriangles = intersectionTriangles;
            this.numberOfTicks = xEndIndex - xStartIndex;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Pixel Intersections Triangles", this.numberOfTicks);
            int numberPixelAlongY = this.pixelsLocation[0].length;
            int i = this.xStartIndex;
            while (i <= this.xEndIndex) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int j = 0;
                while (j < numberPixelAlongY) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Point3d point = this.pixelsLocation[i][j];
                    List<CartesianTriangle> triangles = DigitalElevationMapSamplerCustomImpl.this.findClosestTriangles(this.kdTree, point);
                    Iterator<CartesianTriangle> it = triangles.iterator();
                    CartesianPositionCoordinates projection = null;
                    while (it.hasNext() && projection == null) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        CartesianTriangle triangle = it.next();
                        projection = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon(CartesianAxis.Z, point, (CartesianPolygon)triangle);
                        if (projection == null) continue;
                        this.intersectionTriangles[i][j] = triangle;
                    }
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            subMonitor.done();
            return Status.OK_STATUS;
        }

        @Override
        public CartesianTriangle[][] getOutput() {
            return this.intersectionTriangles;
        }
    }

    protected abstract class ProcessArrayJob<T>
    extends CustomJob<T> {
        protected int xStartIndex;
        protected int xEndIndex;
        protected Point3d[][] pixelsLocation;
        protected CartesianTriangularMesh mesh;

        public ProcessArrayJob(String name, String family, int xStartIndex, int xEndIndex, CartesianTriangularMesh mesh, Point3d[][] pixelsLocation) {
            super(name, family);
            this.xStartIndex = 0;
            this.xEndIndex = 0;
            this.xStartIndex = xStartIndex;
            this.xEndIndex = xEndIndex;
            this.mesh = mesh;
            this.pixelsLocation = pixelsLocation;
        }
    }
}

