/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui.composites;

import org.eclipse.apogy.common.images.ui.Activator;
import org.eclipse.apogy.common.images.ui.composites.AreaSelector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDisplayComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ImageDisplayComposite.class);
    private ImageData originalImageData = null;
    private ImageData displayedImageData = null;
    private double zoomFactor = 1.0;
    private boolean areaSelectionEnabled = false;
    private AreaSelector areaSelector = null;
    private String currentDir = System.getProperty("user.dir");
    private ScrolledComposite scrolledComposite = null;
    private Label imageLabel = null;
    private DefaultToolTip toolTip = null;

    public ImageDisplayComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.scrolledComposite = new ScrolledComposite((Composite)this, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.imageLabel = new Label((Composite)this.scrolledComposite, 0x1000000);
        this.imageLabel.setAlignment(0x1000000);
        this.scrolledComposite.setContent((Control)this.imageLabel);
        this.areaSelector = new AreaSelector(this, this.imageLabel);
        this.setAreaSelectionEnabled(false);
        this.toolTip = new DefaultToolTip((Control)this.imageLabel);
        this.toolTip.setHideOnMouseDown(false);
        this.toolTip.setRespectDisplayBounds(true);
        this.toolTip.setRespectMonitorBounds(true);
        this.toolTip.setPopupDelay(0);
        this.toolTip.setHideDelay(0);
        this.toolTip.setShift(new Point(10, 10));
    }

    public ImageData getImageData() {
        return this.originalImageData;
    }

    public void setImageData(ImageData imgData) {
        this.originalImageData = imgData;
        this.fitImage();
    }

    public boolean isAreaSelectionEnabled() {
        return this.areaSelectionEnabled;
    }

    public void setAreaSelectionEnabled(boolean areaSelectionEnabled) {
        this.areaSelectionEnabled = areaSelectionEnabled;
        if (this.areaSelector != null) {
            this.areaSelector.setEnabled(areaSelectionEnabled);
        }
    }

    public ImageData getDisplayedImageData() {
        return this.displayedImageData;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        if (this.isDisposed()) {
            return;
        }
        ImageData newImage = this.zoomImage(this.getImageData(), zoomFactor);
        if (newImage != null) {
            this.updateImageLabel(newImage);
        }
    }

    private void updateImageLabel(ImageData imageData) {
        if (this.isDisposed()) {
            return;
        }
        if (imageData != null) {
            this.displayedImageData = (ImageData)imageData.clone();
            Image image = new Image((Device)this.getDisplay(), this.getDisplayedImageData());
            if (this.imageLabel.getImage() != null) {
                this.imageLabel.getImage().dispose();
            }
            this.imageLabel.setImage(image);
            Point size = this.imageLabel.computeSize(-1, -1);
            this.scrolledComposite.setMinSize(size);
        }
    }

    public void fitImage() {
        if (this.isDisposed()) {
            return;
        }
        ImageData orig = this.getImageData();
        this.updateImageLabel(this.zoomImage(this.getImageData(), -1.0));
    }

    public void saveImageToFile() {
        if (this.isDisposed()) {
            return;
        }
        FileDialog fileChooser = new FileDialog(this.getShell(), 4096);
        fileChooser.setText("Open image file");
        fileChooser.setFilterPath(this.currentDir);
        fileChooser.setFilterExtensions(new String[]{"*.gif;*.jpg;*.png;*.bmp;*.ico;"});
        String filename = fileChooser.open();
        if (filename != null) {
            try {
                if (filename.endsWith(".gif")) {
                    this.saveImageInJob(filename, 2);
                } else if (filename.endsWith(".jpg")) {
                    this.saveImageInJob(filename, 4);
                } else if (filename.endsWith(".png")) {
                    this.saveImageInJob(filename, 5);
                } else if (filename.endsWith(".bmp")) {
                    this.saveImageInJob(filename, 0);
                } else if (filename.endsWith(".ico")) {
                    this.saveImageInJob(filename, 3);
                } else {
                    String fileExtension = "";
                    if (filename.lastIndexOf(".") > 0) {
                        fileExtension = filename.substring(filename.lastIndexOf("."));
                    }
                    String message = "Failed to save the image. The specified file extension <" + fileExtension + "> is not supported.";
                    Logger.error(message);
                    MessageBox messageBox = new MessageBox(this.getShell(), 33);
                    messageBox.setMessage(message);
                    messageBox.open();
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            this.currentDir = fileChooser.getFilterPath();
        }
    }

    private void saveImageInJob(final String fileName, final int fileType) {
        final ImageDisplayComposite composite = this;
        if (this.isDisposed()) {
            return;
        }
        UIJob job = new UIJob("Save Image to file <" + fileName + ">"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    ImageLoader imageLoader = new ImageLoader();
                    if (!composite.isDisposed()) {
                        imageLoader.data = new ImageData[]{ImageDisplayComposite.this.getImageData()};
                    }
                    if (!composite.isDisposed()) {
                        imageLoader.save(fileName, fileType);
                    }
                    Status status = new Status(0, "org.eclipse.apogy.common.images.ui", "Sucessfully saved image to file <" + fileName + ">.");
                    Activator.getDefault().getLog().log((IStatus)status);
                    return status;
                }
                catch (Exception e) {
                    String message = "Failed to save the image to file <" + fileName + ">. The following exception was thrown : \n\n " + e.getMessage();
                    Status status = new Status(4, "org.eclipse.apogy.common.images.ui", message, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    return status;
                }
            }
        };
        job.schedule();
    }

    public void zoomInRegion(Rectangle region) {
        int x = region.x;
        int y = region.y;
        int w = region.width;
        int h = region.height;
        if (w > 0 && h > 0) {
            Image image = this.imageLabel.getImage();
            Image cropImage = new Image((Device)this.getShell().getDisplay(), w, h);
            if (x + w > image.getBounds().width) {
                w = image.getBounds().width - x;
            }
            if (y + h > image.getBounds().height) {
                h = image.getBounds().height - y;
            }
            GC cropGC = new GC((Drawable)cropImage);
            cropGC.drawImage(image, x, y, w, h, 0, 0, w, h);
            cropGC.dispose();
            ImageData cropImageData = cropImage.getImageData();
            cropImage.dispose();
            this.updateImageLabel(cropImageData);
        }
    }

    private ImageData zoomImage(ImageData imageData, double zoomFactor) {
        if (this.isDisposed()) {
            return null;
        }
        if (imageData != null) {
            if (zoomFactor == -1.0) {
                int imageHeight;
                double heightFactor;
                int imageWidth;
                double widthFactor;
                int compositeWidth = this.getSize().x - this.imageLabel.getBorderWidth();
                int compositeHeight = this.getSize().y - this.imageLabel.getBorderWidth() - 10;
                if (compositeWidth < 0) {
                    compositeWidth = 0;
                }
                if (compositeHeight < 0) {
                    compositeHeight = 0;
                }
                this.zoomFactor = (widthFactor = (double)(imageWidth = this.getImageData().width) / (double)compositeWidth) > (heightFactor = (double)(imageHeight = this.getImageData().height) / (double)compositeHeight) ? 1.0 / widthFactor : 1.0 / heightFactor;
            } else {
                this.zoomFactor = zoomFactor;
            }
            int newWidth = (int)Math.floor((double)this.getImageData().width * this.zoomFactor);
            int newHeight = (int)Math.floor((double)this.getImageData().height * this.zoomFactor);
            if (newWidth <= 0) {
                newWidth = 1;
            }
            if (newHeight <= 0) {
                newHeight = 1;
            }
            return imageData.scaledTo(newWidth, newHeight);
        }
        return null;
    }

    public void addImageMouseListener(MouseListener mouseListener) {
        this.getImageLabel().addMouseListener(mouseListener);
    }

    public void removeImageMouseListener(MouseListener mouseListener) {
        this.getImageLabel().removeMouseListener(mouseListener);
    }

    public void addImageMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.getImageLabel().addMouseMoveListener(mouseMoveListener);
    }

    public void removeImageMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.getImageLabel().removeMouseMoveListener(mouseMoveListener);
    }

    public Point convertMouseEventPositionToImagePosition(MouseEvent e) {
        Rectangle rect = this.getImageLabel().getBounds();
        if (this.getImageLabel().getImage() != null && this.originalImageData != null) {
            ImageData imgData = this.getImageLabel().getImage().getImageData();
            int xOffset = (int)((double)(rect.width - imgData.width) * 0.5);
            int yOffset = (int)((double)(rect.height - imgData.height) * 0.5);
            int x = e.x - xOffset;
            int y = e.y - yOffset;
            if (x < 0) {
                x = 0;
            }
            if (x > imgData.width) {
                x = imgData.width;
            }
            if (y < 0) {
                y = 0;
            }
            if (y > imgData.height) {
                y = imgData.height;
            }
            double hRatio = (double)x / (double)imgData.width;
            double vRatio = (double)y / (double)imgData.height;
            int imageX = (int)Math.round(hRatio * (double)this.originalImageData.width);
            int imageY = (int)Math.round(vRatio * (double)this.originalImageData.height);
            return new Point(imageX, imageY);
        }
        return new Point(0, 0);
    }

    public Label getImageLabel() {
        return this.imageLabel;
    }

    public DefaultToolTip getToolTip() {
        return this.toolTip;
    }
}

