/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui.renderers;

import javax.inject.Inject;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.apogy.common.emf.ui.emfforms.renderers.AbstractCustomElementSWTRenderer;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.elements.AbstractEImageVElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AbstractEImageVElementSWTRenderer
extends AbstractCustomElementSWTRenderer {
    private ImageData imageData;
    private AbstractEImage abstractEImage;

    @Inject
    public AbstractEImageVElementSWTRenderer(VElement element, ViewModelContext viewModelContext, ReportService reportService) {
        super((VContainedElement)((AbstractEImageVElement)element), viewModelContext, reportService);
        EObject object = viewModelContext.getDomainModel();
        if (object instanceof AbstractEImage) {
            this.abstractEImage = (AbstractEImage)object;
            this.imageData = EImagesUtilities.INSTANCE.convertToImageData(this.abstractEImage.asBufferedImage());
        } else if (element instanceof AbstractEImageVElement) {
            AbstractEImageVElement abstractEImageVElement = (AbstractEImageVElement)element;
            this.abstractEImage = abstractEImageVElement.getAbstractEImage();
            this.imageData = EImagesUtilities.INSTANCE.convertToImageData(this.abstractEImage.asBufferedImage());
        }
    }

    protected Control createControl(Composite parent) {
        IFileExporter iFileExporter;
        final Composite top = new Composite(parent, 2048);
        top.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(top, 0);
        label.setBackground(Display.getCurrent().getSystemColor(37));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.imageData != null) {
            ImageData displayedImageData = (ImageData)this.imageData.clone();
            Image image = new Image((Device)Display.getCurrent(), displayedImageData);
            label.setImage(image);
        }
        if ((iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter((Object)this.abstractEImage)) != null) {
            Button exportButton = new Button(top, 8);
            exportButton.setText("Export Image To File...");
            exportButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExportToFileWizard wizard = new ExportToFileWizard(iFileExporter, (Object)AbstractEImageVElementSWTRenderer.this.abstractEImage);
                    WizardDialog dialog = new WizardDialog(top.getShell(), (IWizard)wizard);
                    dialog.open();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
        return top;
    }

    protected String getLabelText() {
        return "Image";
    }
}

