/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.io.jinput.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.eclipse.apogy.common.io.jinput.Activator;
import org.eclipse.apogy.common.io.jinput.ApogyCommonIOJInputFactory;
import org.eclipse.apogy.common.io.jinput.EComponent;
import org.eclipse.apogy.common.io.jinput.EComponentQualifier;
import org.eclipse.apogy.common.io.jinput.EController;
import org.eclipse.apogy.common.io.jinput.EControllerEnvironment;
import org.eclipse.apogy.common.io.jinput.impl.EControllerEnvironmentImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EControllerEnvironmentCustomImpl
extends EControllerEnvironmentImpl {
    public static final long MILLIS_BEFORE_NEXT_POLLING = 50L;
    private static final Logger Logger = LoggerFactory.getLogger(EControllerEnvironmentImpl.class);

    @Override
    public boolean isSupported() {
        return ControllerEnvironment.getDefaultEnvironment().isSupported();
    }

    @Override
    public EList<EController> getControllers() {
        EList<EController> returnList = super.getControllers();
        if (this.isRefreshRequested()) {
            Controller[] controllerList;
            returnList.clear();
            Controller[] controllerArray = controllerList = ControllerEnvironment.getDefaultEnvironment().getControllers();
            int n = controllerList.length;
            int n2 = 0;
            while (n2 < n) {
                Controller c = controllerArray[n2];
                if (c.poll()) {
                    EController ec = ApogyCommonIOJInputFactory.eINSTANCE.createEController();
                    ec.setPojoController(c);
                    returnList.add((Object)ec);
                }
                ++n2;
            }
            this.assignControllerCounts(returnList);
            this.setRefreshRequested(false);
        }
        return returnList;
    }

    private void assignControllerCounts(EList<EController> controllers) {
        HashMap<String, Integer> nameToCountMap = new HashMap<String, Integer>();
        for (EController controller : controllers) {
            String pojoName = controller.getPojoController().getName();
            if (nameToCountMap.get(pojoName) != null) {
                int controllerCount = (Integer)nameToCountMap.get(pojoName) + 1;
                controller.setControllerCount(controllerCount);
                nameToCountMap.put(pojoName, controllerCount);
                continue;
            }
            controller.setControllerCount(1);
            nameToCountMap.put(pojoName, 1);
        }
    }

    @Override
    public Job getPollingJob() {
        if (this.pollingJob == null) {
            this.pollingJob = new Job("Controllers polling job"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!monitor.isCanceled()) {
                        Date startExecDate = new Date();
                        EControllerEnvironmentCustomImpl.this.pollControllers();
                        EControllerEnvironmentCustomImpl.this.increasePollCounter();
                        Date finishExecDate = new Date();
                        long runningTime = finishExecDate.getTime() - startExecDate.getTime();
                        long waitTime = 50L - runningTime;
                        if (waitTime > 0L) {
                            try {
                                Thread.sleep(waitTime);
                            }
                            catch (InterruptedException e) {
                                Logger.error(e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.pollingJob;
    }

    private void pollControllers() {
        EControllerEnvironment ece = Activator.getEControllerEnvironment();
        EList<EController> list = ece.getControllers();
        for (EController ec : list) {
            if (!this.isPollingProblem()) {
                this.setPollingProblem(!ec.poll());
                continue;
            }
            ec.poll();
        }
    }

    private void increasePollCounter() {
        long actualPollingCount = this.getPollingCount();
        if (++actualPollingCount > 0x7FFFFFFFFFFFFFFDL) {
            actualPollingCount = 0L;
        }
        this.setPollingCount(actualPollingCount);
    }

    @Override
    public void refresh() {
        this.setRefreshRequested(true);
    }

    @Override
    public void startPolling() {
        this.getPollingJob().schedule();
    }

    @Override
    public void stopPolling() {
        this.getPollingJob().cancel();
    }

    @Override
    public EController resolveController(String controllerName) {
        EController controller = null;
        if (controllerName != null) {
            Iterator it = this.getControllers().iterator();
            while (controller == null && it.hasNext()) {
                EController c = (EController)it.next();
                if (c.getName() == null || c.getName().compareTo(controllerName) != 0) continue;
                controller = c;
            }
        }
        return controller;
    }

    @Override
    public EComponent resolveEComponent(String componentName, EController eController) {
        EComponent component = null;
        if (componentName != null) {
            Iterator it = eController.getEComponents().getComponents().iterator();
            while (component == null && it.hasNext()) {
                EComponent c = (EComponent)it.next();
                if (c.getName() == null || c.getName().compareTo(componentName) != 0) continue;
                component = c;
            }
        }
        return component;
    }

    @Override
    public EComponent resolveEComponent(EComponentQualifier eComponentQualifier) {
        EComponent eComponent = null;
        EController eController = null;
        if (eComponentQualifier != null) {
            eController = this.resolveController(eComponentQualifier.getEControllerName());
        }
        if (eController != null) {
            eComponent = this.resolveEComponent(eComponentQualifier.getEComponentName(), eController);
        }
        return eComponent;
    }
}

