/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.dynamics.ui.composites;

import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.common.topology.addons.dynamics.KinematicState;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class KinematicStateComposite
extends Composite {
    private final DataBindingContext m_bindingContext;
    private KinematicState ks;
    private Adapter kinematicStateAdapter;
    private final Tuple3dComposite tuple3dLinearVelocity;
    private final Tuple3dComposite tuple3dLinearAcceleration;
    private final Tuple3dComposite tuple3dOrientation;
    private final Tuple3dComposite tuple3dAngularVelocity;
    private final Tuple3dComposite tuple3dAngularAcceleration;
    private final Tuple3dComposite tuple3dPosition;

    public KinematicStateComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, true));
        Group grpPosition = new Group((Composite)this, 0);
        grpPosition.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpPosition.setText("Position");
        Group grpOrientation = new Group((Composite)this, 0);
        grpOrientation.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpOrientation.setText("Orientation");
        grpOrientation.setLayout((Layout)new FillLayout(256));
        this.tuple3dOrientation = new Tuple3dComposite((Composite)grpOrientation, 4);
        Group grpLinearVelocity = new Group((Composite)this, 0);
        grpLinearVelocity.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpLinearVelocity.setText("Linear Velocity");
        grpLinearVelocity.setLayout((Layout)new FillLayout(256));
        this.tuple3dLinearVelocity = new Tuple3dComposite((Composite)grpLinearVelocity, 4);
        Group grpAngularVelocity = new Group((Composite)this, 0);
        grpAngularVelocity.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpAngularVelocity.setText("Angular Velocity");
        grpAngularVelocity.setLayout((Layout)new FillLayout(256));
        this.tuple3dAngularVelocity = new Tuple3dComposite((Composite)grpAngularVelocity, 4);
        Group grpLinearAcceleration = new Group((Composite)this, 0);
        grpLinearAcceleration.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpLinearAcceleration.setText("Linear Acceleration");
        grpLinearAcceleration.setLayout((Layout)new FillLayout(256));
        this.tuple3dLinearAcceleration = new Tuple3dComposite((Composite)grpLinearAcceleration, 0);
        Group grpAngularAcceleration = new Group((Composite)this, 0);
        grpAngularAcceleration.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpAngularAcceleration.setText("Angular Acceleration");
        grpAngularAcceleration.setLayout((Layout)new FillLayout(256));
        this.tuple3dAngularAcceleration = new Tuple3dComposite((Composite)grpAngularAcceleration, 4);
        grpPosition.setLayout((Layout)new FillLayout(256));
        this.tuple3dPosition = new Tuple3dComposite((Composite)grpPosition, 0);
        this.m_bindingContext = this.initDataBindings();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (KinematicStateComposite.this.m_bindingContext != null) {
                    KinematicStateComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public KinematicState getKinematicState() {
        return this.ks;
    }

    public void setKinematicState(KinematicState ks) {
        if (this.ks != null) {
            this.ks.eAdapters().remove((Object)this.getKinematicStateAdapter());
        }
        this.ks = ks;
        if (this.ks != null) {
            this.tuple3dAngularAcceleration.setTuple3d(ks.getAngularAcceleration());
            this.tuple3dAngularVelocity.setTuple3d(ks.getAngularVelocity());
            this.tuple3dLinearAcceleration.setTuple3d(ks.getLinearAcceleration());
            this.tuple3dLinearVelocity.setTuple3d(ks.getLinearVelocity());
            this.tuple3dOrientation.setTuple3d(ks.getOrientation());
            this.tuple3dPosition.setTuple3d(ks.getPosition());
            this.ks.eAdapters().add((Object)this.getKinematicStateAdapter());
        }
    }

    protected void checkSubclass() {
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }

    private Adapter getKinematicStateAdapter() {
        if (this.kinematicStateAdapter == null) {
            this.kinematicStateAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(KinematicState.class);
                    Tuple3d newValue = null;
                    Tuple3dComposite compositeToUpdate = null;
                    switch (featureId) {
                        case 0: {
                            newValue = (Tuple3d)msg.getNewValue();
                            compositeToUpdate = KinematicStateComposite.this.tuple3dPosition;
                            break;
                        }
                        case 1: {
                            newValue = (Tuple3d)msg.getNewValue();
                            compositeToUpdate = KinematicStateComposite.this.tuple3dOrientation;
                            break;
                        }
                        case 5: {
                            newValue = (Tuple3d)msg.getNewValue();
                            compositeToUpdate = KinematicStateComposite.this.tuple3dAngularAcceleration;
                            break;
                        }
                        case 3: {
                            newValue = (Tuple3d)msg.getNewValue();
                            compositeToUpdate = KinematicStateComposite.this.tuple3dAngularVelocity;
                            break;
                        }
                        case 4: {
                            newValue = (Tuple3d)msg.getNewValue();
                            compositeToUpdate = KinematicStateComposite.this.tuple3dLinearAcceleration;
                            break;
                        }
                        case 2: {
                            newValue = (Tuple3d)msg.getNewValue();
                            compositeToUpdate = KinematicStateComposite.this.tuple3dLinearVelocity;
                        }
                    }
                    if (compositeToUpdate != null) {
                        final Tuple3dComposite fCompositeToUpdate = compositeToUpdate;
                        final Tuple3d fNewValue = newValue;
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                fCompositeToUpdate.setTuple3d(fNewValue);
                            }
                        };
                        Display.getDefault().asyncExec(run);
                    }
                }
            };
        }
        return this.kinematicStateAdapter;
    }
}

