/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.impl;

import org.eclipse.apogy.common.topology.addons.primitives.ui.Activator;
import org.eclipse.apogy.common.topology.addons.primitives.ui.SpotLightPresentation;
import org.eclipse.apogy.common.topology.addons.primitives.ui.impl.SpotLightPresentationImpl;
import org.eclipse.apogy.common.topology.addons.primitives.ui.scene_objects.SpotLightSceneObject;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SpotLightPresentationCustomImpl
extends SpotLightPresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;

    protected SpotLightPresentationCustomImpl() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    protected void initialSceneObject() {
        SpotLightSceneObject spotLightSceneObject = (SpotLightSceneObject)this.getSceneObject();
        spotLightSceneObject.setPresentationMode(this.getPresentationMode());
        spotLightSceneObject.setLightConeVisible(this.isLightConeVisible());
        spotLightSceneObject.setAxisVisible(this.axisVisible);
        spotLightSceneObject.setAxisLength(this.getAxisLength());
        super.initialSceneObject();
    }

    protected void updateSceneObject(Notification notification) {
        SpotLightSceneObject spotLightSceneObject = (SpotLightSceneObject)this.getSceneObject();
        if (notification.getNotifier() instanceof SpotLightPresentation) {
            int featureId = notification.getFeatureID(SpotLightPresentation.class);
            switch (featureId) {
                case 16: {
                    spotLightSceneObject.setPresentationMode(this.getPresentationMode());
                    break;
                }
                case 17: {
                    spotLightSceneObject.setLightConeVisible(this.isLightConeVisible());
                    break;
                }
                case 18: {
                    spotLightSceneObject.setAxisVisible(this.isAxisVisible());
                    break;
                }
                case 19: {
                    spotLightSceneObject.setAxisLength(this.getAxisLength());
                    break;
                }
            }
        }
        super.updateSceneObject(notification);
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    SpotLightPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }

    protected void finalize() throws Throwable {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPreferencesListener());
        super.finalize();
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setVisible(store.getBoolean("DEFAULT_SPOT_LIGHT_VISIBILITY_ID"));
        this.setLightConeVisible(store.getBoolean("DEFAULT_SPOT_LIGHT_LIGHT_CONE_VISIBILITY_ID"));
        this.setAxisVisible(store.getBoolean("DEFAULT_SPOT_LIGHT_AXIS_VISIBLE_ID"));
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_SPOT_LIGHT_LIGHT_CONE_COLOR_ID");
        if (rgb != null) {
            this.setColor(rgb);
        }
        this.setPresentationMode(MeshPresentationMode.get((int)store.getInt("DEFAULT_SPOT_LIGHT_LIGHT_CONE_PRESENTATION_MODE_ID")));
        super.applyPreferences();
    }
}

