/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.widgets.ui;

import java.net.URL;
import java.text.DecimalFormat;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBarComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ProgressBarComposite.class);
    private static final String IMAGES_FOLDER = "platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/";
    private static final int MAX_VALUE = 100;
    private static final int MIN_VALUE = 0;
    private Image background;
    private int actualValue;

    public ProgressBarComposite(Composite parent, int style, int initialValue) {
        super(parent, style | 0x20000000);
        this.setActualValue(initialValue);
        this.initImages();
        this.createPaintListener();
        this.createDisposeListener();
    }

    public synchronized int getActualValue() {
        return this.actualValue;
    }

    public synchronized void setActualValue(int actualValue) {
        this.actualValue = actualValue > 100 ? 100 : (actualValue < 0 ? 0 : actualValue);
        this.redraw();
    }

    public synchronized void increaseValue() {
        this.setActualValue(this.actualValue + 1);
    }

    public synchronized void decreaseValue() {
        this.setActualValue(this.actualValue - 1);
    }

    private void initImages() {
        try {
            Display device = Display.getCurrent();
            URL url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/gadgeCenter.png");
            this.background = new Image((Device)device, url.openStream());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void paintMeter(GC gc) {
        int centerXMeter = this.getBounds().width / 2;
        int centerYMeter = this.getBounds().height / 2;
        float XScaleFactor = 0.0f;
        float YScaleFactor = 0.0f;
        if (this.background != null) {
            XScaleFactor = (float)this.getBounds().width / (float)this.background.getBounds().width;
            YScaleFactor = (float)this.getBounds().height / (float)this.background.getBounds().height;
            gc.drawImage(this.background, 0, 0, this.background.getBounds().width, this.background.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        } else {
            Color color = new Color((Device)this.getDisplay(), 0, 0, 0);
            gc.setForeground(color);
            gc.setLineWidth(4);
            gc.drawRectangle(2, 2, this.getBounds().width - 4, this.getBounds().height - 4);
            color.dispose();
        }
        double gadgeWidth = this.getBounds().width - 2;
        int value = (int)Math.round(gadgeWidth * ((double)this.actualValue / 100.0));
        gc.setAlpha(100);
        Color c = new Color((Device)Display.getCurrent(), 0, 255, 0);
        gc.setBackground(c);
        gc.fillRectangle(1, 1, value, this.getBounds().height - 2);
        c.dispose();
        int size = 0;
        size = XScaleFactor > YScaleFactor ? Math.round(7.0f * YScaleFactor) : Math.round(7.0f * XScaleFactor);
        DecimalFormat df = new DecimalFormat("0");
        Font font = new Font((Device)this.getDisplay(), "Tahoma", size, 1);
        gc.setFont(font);
        gc.setAlpha(255);
        String numberPercent = String.valueOf(df.format(this.actualValue)) + "%";
        int widthOfNumber = 0;
        int i = 0;
        while (i < numberPercent.length()) {
            widthOfNumber += gc.getAdvanceWidth(numberPercent.charAt(i));
            ++i;
        }
        int heightOfNumber = gc.getFontMetrics().getHeight();
        c = new Color((Device)Display.getCurrent(), 0, 0, 0);
        gc.setForeground(c);
        gc.drawString(numberPercent, centerXMeter - widthOfNumber / 2 + 1, centerYMeter - heightOfNumber / 2 + 1, true);
        c.dispose();
        c = new Color((Device)Display.getCurrent(), 255, 255, 255);
        gc.setForeground(c);
        gc.drawString(numberPercent, centerXMeter - widthOfNumber / 2, centerYMeter - heightOfNumber / 2, true);
        c.dispose();
        font.dispose();
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProgressBarComposite.this.background != null) {
                    ProgressBarComposite.this.background.dispose();
                }
            }
        });
    }

    private void createPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ProgressBarComposite.this.paintMeter(e.gc);
            }
        });
    }
}

