/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.antenna.impl;

import javax.vecmath.GVector;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFacade;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.examples.antenna.impl.PTUDishAntennaSimulatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTUDishAntennaSimulatedCustomImpl
extends PTUDishAntennaSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PTUDishAntennaSimulatedImpl.class);
    protected static final double FOV_DEF_MINIMUM_RANGE = 0.0;
    protected static final double FOV_DEF_MAXIMUM_RANGE = 10.0;
    protected static final double FOV_DEF_ANGLE = Math.toRadians(10.0);
    protected static final double MOVE_TO_ANGULAR_SPEED = 40.0;
    protected static final int MOVE_TO_WAIT_PERIOD = 50;

    @Override
    public ConicalFieldOfView getFov() {
        ConicalFieldOfView tmp = super.getFov();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsFOVFacade.INSTANCE.createConicalFieldOfView(0.0, 10.0, FOV_DEF_ANGLE);
            this.setFov(tmp);
        }
        return tmp;
    }

    @Override
    public boolean init() {
        if (this.isInitialized()) {
            Logger.info("Ignored: the unit is already initialized.");
            return true;
        }
        Logger.info("The PTU dish antenna has been initialized.");
        this.setInitialized(true);
        return true;
    }

    @Override
    public void trackSun(boolean track) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".trackSun(" + track + "): ";
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the PTU dish antenna " + "is not initialized (with init()).";
            throw new RuntimeException(message);
        }
        if (track == this.isTrackingSun()) {
            String message = String.valueOf(LOG_PREFIX) + "Ignored; the given tracking status is " + "the same as the PTU antenna's current " + "tracking status.";
            throw new RuntimeException(message);
        }
        Logger.info("The PTU dish antenna is now " + (track ? "" : "no longer") + " tracking the sun.");
        this.setTrackingSun(track);
    }

    @Override
    public void moveTo(double panAngle, double tiltAngle) {
        String DEGREE_SYM = "\u00b0";
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveTo(" + Math.toDegrees(panAngle) + "\u00b0" + ", " + Math.toDegrees(tiltAngle) + "\u00b0" + "): ";
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the PTU antenna is " + "not initialized (with init()).";
            throw new RuntimeException(message);
        }
        if (this.isTrackingSun()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the PTU antenna is " + "currently tracking the sun and " + "as such, the joints cannot " + "currently be moved manually.";
            throw new RuntimeException(message);
        }
        if (this.getPanAngle() == panAngle && this.getTiltAngle() == tiltAngle) {
            String message = String.valueOf(LOG_PREFIX) + "Ignored; No move required as antenna's " + "current angles match those provided.";
            throw new RuntimeException(message);
        }
        Logger.info("PTU dish antenna move started.");
        GVector initialJointAngles = new GVector(new double[]{this.getPanAngle(), this.getTiltAngle()});
        GVector finalJointAngles = new GVector(new double[]{panAngle, tiltAngle});
        this.moveToConfiguration(initialJointAngles, finalJointAngles);
        Logger.info("PTU dish antenna move completed.");
    }

    private void moveToConfiguration(GVector initialJointAngles, GVector finalJointAngles) {
        GVector interpolatedJointsValues = new GVector(initialJointAngles);
        double deltaT = this.computeDeltaTime(initialJointAngles, finalJointAngles);
        double t = -deltaT;
        while (t <= 1.0) {
            interpolatedJointsValues.interpolate(initialJointAngles, finalJointAngles, t += deltaT);
            this.setPanAngle(interpolatedJointsValues.getElement(0));
            this.setTiltAngle(interpolatedJointsValues.getElement(1));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private double computeDeltaTime(GVector initialJointAngles, GVector finalJointAngles) {
        double largestMove = 0.0;
        int i = 0;
        while (i < initialJointAngles.getSize()) {
            double deltaAngle = Math.abs(finalJointAngles.getElement(i) - initialJointAngles.getElement(i));
            if (deltaAngle > largestMove) {
                largestMove = deltaAngle;
            }
            ++i;
        }
        double travelTime = largestMove / Math.toRadians(40.0);
        double deltaTime = 0.05 / travelTime;
        return deltaTime;
    }
}

