/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lander.impl;

import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehicleFactory;
import org.eclipse.apogy.addons.vehicle.Thruster;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.examples.lander.ApogyExamplesLanderFactory;
import org.eclipse.apogy.examples.lander.LanderLegExtension;
import org.eclipse.apogy.examples.lander.Position;
import org.eclipse.apogy.examples.lander.impl.LanderSimulatedFlyingJob;
import org.eclipse.apogy.examples.lander.impl.LanderSimulatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanderSimulatedCustomImpl
extends LanderSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(LanderSimulatedImpl.class);
    protected static final int LEG_EXTEND_WAIT_PERIOD = 50;
    protected static final double LEG_EXTEND_LINEAR_SPEED = 0.05;
    protected static final double LEG_EXTEND_SCALE_FACTOR = 0.001;
    protected static final int MOVE_TO_WAIT_PERIOD = 50;
    protected static final double MOVE_TO_LINEAR_SPEED = 5.0;
    protected static final int CHANGE_ATTITUDE_WAIT_PERIOD = 50;
    protected static final double CHANGE_ATTITUDE_ANGULAR_SPEED = 5.0;
    protected static final double LANDER__DRY_MASS = 572.0;
    protected static final double LANDER__FUEL_MASS_AT_LAUNCH = 85.0;
    protected static final double LANDER__FUEL_SPECIFIC_IMPULSE = 220.0;
    protected static final double LANDER_MAX_THRUST = 8000.0;
    protected static final double EARTH_GRAVITY = -9.81;
    protected LanderSimulatedFlyingJob flyingSim = new LanderSimulatedFlyingJob(this, "Flying Simulator");
    private boolean isLanding = false;

    protected LanderSimulatedCustomImpl() {
    }

    @Override
    public double getGravitationalPull() {
        return this.getMass() * -9.81;
    }

    @Override
    public double getMass() {
        return 572.0 + this.getFuelMass();
    }

    @Override
    public Position getPosition() {
        Position position = super.getPosition();
        if (position == null) {
            position = ApogyExamplesLanderFactory.eINSTANCE.createPosition();
            Matrix3d newAttitude = new Matrix3d();
            newAttitude.setIdentity();
            position.setAttitude(newAttitude);
            this.setPosition(position);
        }
        return position;
    }

    @Override
    public Thruster getThruster() {
        Thruster thruster = super.getThruster();
        if (thruster == null) {
            thruster = ApogyAddonsVehicleFactory.eINSTANCE.createThruster();
            thruster.setMinimumThrust(0.0);
            thruster.setCurrentThrust(0.0);
            thruster.setMaximumThrust(8000.0);
            this.setThruster(thruster);
        }
        return thruster;
    }

    @Override
    public boolean init() {
        if (this.isDisposed()) {
            Logger.error("Rejected: the lander has already been disposed.");
            return false;
        }
        if (this.isInitialized()) {
            Logger.warn("Ignored: init() has already been successfully called.");
            return true;
        }
        Logger.info("The lander has been initialized.");
        this.setInitialized(true);
        return true;
    }

    @Override
    public void dispose() {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".dispose(): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Ignored; dispose() has already been successfully called.";
            throw new RuntimeException(message);
        }
        if (this.isFlyingEnabled()) {
            this.stopFlying();
        }
        this.setDisposed(true);
        Logger.info("The lander has been disposed and can no longer be used.");
    }

    @Override
    public void commandThrust(double thrustLevel) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (!this.isFlyingEnabled()) {
            throw new RuntimeException("Rejected: the lander is currently not permitted to fly - need to call startFlying() first.");
        }
        if (thrustLevel == this.getThruster().getCurrentThrust()) {
            throw new RuntimeException("Ignored; the lander's current thrust level matches the requested thrust.");
        }
        if (thrustLevel < this.getThruster().getMinimumThrust()) {
            Logger.warn("The thrust level (in N) cannot be greater than the lander's minumum allowed thrust level (" + this.getThruster().getMinimumThrust() + ") - using the minimum thrust level instead.");
            thrustLevel = this.getThruster().getMinimumThrust();
        } else if (thrustLevel > this.getThruster().getMaximumThrust()) {
            Logger.warn("The thrust level (in N) cannot be greater than the lander's maximum allowed thrust level (" + this.getThruster().getMaximumThrust() + ") - using the maximum thrust level instead.");
            thrustLevel = this.getThruster().getMaximumThrust();
        }
        if (this.getFuelMass() > 0.0) {
            this.getThruster().setCurrentThrust(thrustLevel);
        } else {
            this.getThruster().setCurrentThrust(0.0);
        }
    }

    @Override
    public void changeThrustBy(double thrustOffset) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (!this.isFlyingEnabled()) {
            throw new RuntimeException("Rejected: the lander is currently not permitted to fly - need to call startFlying() first.");
        }
        if (thrustOffset == 0.0) {
            throw new RuntimeException("Ignored: The lander's thrust level will not changed by this offset.");
        }
        double newThrustLevel = this.getThruster().getCurrentThrust() + thrustOffset;
        if (newThrustLevel < this.getThruster().getMinimumThrust()) {
            Logger.warn("The given offset would cause the thrust to go below the minimum allowed thrust level (" + this.getThruster().getMinimumThrust() + ") - using the minimum thrust level instead.");
            newThrustLevel = this.getThruster().getMinimumThrust();
        } else if (newThrustLevel > this.getThruster().getMaximumThrust()) {
            Logger.warn("The given offset would cause the thrust to go above the maximum allowed thrust level (" + this.getThruster().getMaximumThrust() + ") - using the maximum thrust level instead.");
            newThrustLevel = this.getThruster().getMaximumThrust();
        }
        if (this.getFuelMass() > 0.0) {
            this.getThruster().setCurrentThrust(newThrustLevel);
        } else {
            this.getThruster().setCurrentThrust(0.0);
        }
    }

    @Override
    public void commandLegPosition(LanderLegExtension legAExtension, LanderLegExtension legBExtension, LanderLegExtension legCExtension) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (this.isChangingLegs()) {
            throw new RuntimeException("Rejected: The lander's legs are currently in the process of extending / retracting from a previous commandLegPosition() call.");
        }
        if (this.getLegAExtension() == legAExtension && this.getLegBExtension() == legBExtension && this.getLegCExtension() == legCExtension) {
            throw new RuntimeException("Ignored: The lander's legs are already at the given leg extension levels.");
        }
        GVector initialPosition = new GVector(new double[]{this.getLegAPosition(), this.getLegBPosition(), this.getLegCPosition()});
        GVector finalPosition = new GVector(new double[]{(double)legAExtension.getValue() * 0.001, (double)legBExtension.getValue() * 0.001, (double)legCExtension.getValue() * 0.001});
        this.setChangingLegs(true);
        Logger.info("Lander leg extension / retraction started.");
        this.extendLegs(initialPosition, finalPosition);
        this.setLegAPosition(finalPosition.getElement(0));
        this.setLegBPosition(finalPosition.getElement(1));
        this.setLegCPosition(finalPosition.getElement(2));
        this.setLegAExtension(legAExtension);
        this.setLegBExtension(legBExtension);
        this.setLegCExtension(legCExtension);
        Logger.info("Lander leg extension / retraction complete.");
        this.setChangingLegs(false);
    }

    @Override
    public void moveTo(double x, double y, double z) {
        GVector finalPosition;
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (this.isChangingLocation()) {
            throw new RuntimeException("Rejected: The lander is already moving.");
        }
        if (this.isLanding) {
            throw new RuntimeException("Rejected: The lander is currently landing.");
        }
        if (this.getPosition().getX() == x && this.getPosition().getY() == y && this.getPosition().getZ() == z) {
            throw new RuntimeException("Ignored: The lander is already at the target coordinates.");
        }
        GVector initialPosition = new GVector(new double[]{this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ()});
        if (this.isFlyingEnabled()) {
            finalPosition = new GVector(new double[]{x, y, z});
        } else {
            finalPosition = new GVector(new double[]{x, y, this.getPosition().getZ()});
            Logger.warn("Z coordinate ignored; the lander is not allowed to fly so cannot explicitly change Z coordinate.");
        }
        this.setChangingLocation(true);
        Logger.info("Lander move started.");
        this.move(initialPosition, finalPosition);
        Logger.info("Lander move completed.");
        this.setChangingLocation(false);
    }

    @Override
    public void changeAttitude(double xAngle, double yAngle, double zAngle) {
        this.attitude(xAngle, yAngle, zAngle);
    }

    @Override
    public void resetAttitude() {
        this.attitude(0.0, 0.0, 0.0);
    }

    @Override
    public void commandAngularVelocities(double xAngularVelocity, double yAngularVelocity) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (xAngularVelocity == this.getXAngularVelocity() && yAngularVelocity == this.getYAngularVelocity()) {
            throw new RuntimeException("Ignored; the lander's current angular velocities match the velocities given.");
        }
        this.setXAngularVelocity(xAngularVelocity);
        this.setYAngularVelocity(yAngularVelocity);
    }

    @Override
    public void startFlying(boolean logStateChanges) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (this.isLanding) {
            throw new RuntimeException("Rejected: The lander is currently landing.");
        }
        if (this.isFlyingEnabled()) {
            throw new RuntimeException("Ignored: The lander is already permitted to fly / flying.");
        }
        Logger.info("The lander is now allowed to fly and depending on the thrust, will do so.");
        this.setFuelMass(85.0);
        this.flyingSim.shouldLog(logStateChanges);
        this.flyingSim.schedule();
        this.setFlyingEnabled(true);
    }

    @Override
    public void stopFlying() {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (this.isLanding) {
            throw new RuntimeException("Rejected: The lander is currently landing.");
        }
        if (!this.isFlyingEnabled()) {
            throw new RuntimeException("Ignored: The lander is currently not flying.");
        }
        Logger.info("The lander is no longer permitted to fly and if it actually is flying, it will need to land.");
        this.isLanding = true;
        this.getThruster().setCurrentThrust(0.0);
        this.flyingSim.cancel();
        this.setFlyingEnabled(false);
        while (this.getPosition().getZ() > 0.0) {
            Logger.debug("getPosition().getZ() " + this.getPosition().getZ());
            while (this.isChangingLocation()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.isLanding = false;
        Logger.info("The lander has successfully landed.");
    }

    private void extendLegs(GVector initialPosition, GVector finalPosition) {
        GVector interpolatedLegPositions = new GVector(initialPosition);
        double deltaT = LanderSimulatedCustomImpl.computeDeltaTime(initialPosition, finalPosition, 0.05, 50);
        double t = -deltaT;
        while (t <= 1.0 && !this.isDisposed()) {
            interpolatedLegPositions.interpolate(initialPosition, finalPosition, t += deltaT);
            this.setLegAPosition(interpolatedLegPositions.getElement(0));
            this.setLegBPosition(interpolatedLegPositions.getElement(1));
            this.setLegCPosition(interpolatedLegPositions.getElement(2));
            Position newPosition = ApogyExamplesLanderFactory.eINSTANCE.createPosition();
            newPosition.setAttitude(this.getPosition().getAttitude());
            newPosition.setX(this.getPosition().getX());
            newPosition.setY(this.getPosition().getY());
            newPosition.setZ(this.getPosition().getZ());
            this.setPosition(newPosition);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void move(GVector initialPosition, GVector finalPosition) {
        GVector interpolatedPosition = new GVector(initialPosition);
        double deltaT = LanderSimulatedCustomImpl.computeMoveDeltaTime(initialPosition, finalPosition, 5.0, 50);
        double t = -deltaT;
        while (t <= 1.0 && !this.isDisposed()) {
            interpolatedPosition.interpolate(initialPosition, finalPosition, t += deltaT);
            Position newPosition = ApogyExamplesLanderFactory.eINSTANCE.createPosition();
            newPosition.setAttitude(this.getPosition().getAttitude());
            newPosition.setX(interpolatedPosition.getElement(0));
            newPosition.setY(interpolatedPosition.getElement(1));
            newPosition.setZ(interpolatedPosition.getElement(2));
            this.setPosition(newPosition);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void attitude(double finalXAngle, double finalYAngle, double finalZAngle) {
        if (this.isDisposed() || !this.isInitialized()) {
            throw new RuntimeException("Rejected: The lander is not properly initialized.");
        }
        if (this.isLanding) {
            throw new RuntimeException("Rejected: The lander is currently landing.");
        }
        if (this.isChangingAttitude()) {
            throw new RuntimeException("Rejected: The lander is currently in the process of moving from a previous changeAttitde() or resetAttitude() call.");
        }
        Matrix3d currAttitude = this.getPosition().getAttitude();
        Vector3d currAngles = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)currAttitude);
        GVector initialAttitude = new GVector(new double[]{currAngles.getX(), currAngles.getY(), currAngles.getZ()});
        GVector finalAttitude = new GVector(new double[]{finalXAngle, finalYAngle, finalZAngle});
        this.setChangingAttitude(true);
        Logger.info("Lander attitude change started.");
        this.alterAttitude(initialAttitude, finalAttitude);
        if (finalXAngle == 0.0 && finalYAngle == 0.0 && finalZAngle == 0.0) {
            this.getPosition().getAttitude().setIdentity();
        }
        Logger.info("Lander attitude change complete.");
        this.setChangingAttitude(false);
    }

    private void alterAttitude(GVector initialAttitude, GVector finalAttitude) {
        GVector interpolatedAttitude = new GVector(initialAttitude);
        double deltaT = LanderSimulatedCustomImpl.computeDeltaTime(initialAttitude, finalAttitude, 5.0, 50);
        double t = -deltaT;
        while (t <= 1.0 && !this.isDisposed()) {
            interpolatedAttitude.interpolate(initialAttitude, finalAttitude, t += deltaT);
            Matrix3d xRot = new Matrix3d();
            xRot.setIdentity();
            xRot.rotX(interpolatedAttitude.getElement(0));
            Matrix3d yRot = new Matrix3d();
            yRot.setIdentity();
            yRot.rotY(interpolatedAttitude.getElement(1));
            Matrix3d zRot = new Matrix3d();
            yRot.setIdentity();
            zRot.rotZ(interpolatedAttitude.getElement(2));
            Matrix3d newAttitude = new Matrix3d();
            newAttitude.setIdentity();
            newAttitude.mul(zRot);
            newAttitude.mul(yRot);
            newAttitude.mul(xRot);
            Position newPosition = ApogyExamplesLanderFactory.eINSTANCE.createPosition();
            newPosition.setAttitude(newAttitude);
            newPosition.setX(this.getPosition().getX());
            newPosition.setY(this.getPosition().getY());
            newPosition.setZ(this.getPosition().getZ());
            this.setPosition(newPosition);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static double computeDeltaTime(GVector initialPosition, GVector finalPosition, double moveSpeed, int delayPerStep) {
        double largestMove = 0.0;
        int i = 0;
        while (i < initialPosition.getSize()) {
            double move = Math.abs(finalPosition.getElement(i) - initialPosition.getElement(i));
            if (move > largestMove) {
                largestMove = move;
            }
            ++i;
        }
        double extensionTime = largestMove / moveSpeed;
        double deltaTime = (double)delayPerStep * 0.001 / extensionTime;
        return deltaTime;
    }

    private static double computeMoveDeltaTime(GVector initialPosition, GVector finalPosition, double moveSpeed, int delayPerStep) {
        double euclideanDist = 0.0;
        int i = 0;
        while (i < initialPosition.getSize()) {
            euclideanDist += Math.pow(finalPosition.getElement(i) - initialPosition.getElement(i), 2.0);
            ++i;
        }
        euclideanDist = Math.sqrt(euclideanDist);
        double extensionTime = euclideanDist / moveSpeed;
        double deltaTime = (double)delayPerStep * 0.001 / extensionTime;
        return deltaTime;
    }
}

