/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.mobile_platform.impl;

import org.eclipse.apogy.examples.mobile_platform.Position;
import org.eclipse.apogy.examples.mobile_platform.impl.MobilePlatformStubImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobilePlatformStubCustomImpl
extends MobilePlatformStubImpl {
    private static final Logger Logger = LoggerFactory.getLogger(MobilePlatformStubImpl.class);
    private static final String DEGREE_SYM = "\u00b0";

    @Override
    public boolean init() {
        Logger.info("Just a stub - The necessary initialization for the mobile platform would have taken place.");
        return true;
    }

    @Override
    public void dispose() {
        Logger.info("Just a stub - The necessary disposal operations for the mobile platform would have taken place.");
    }

    @Override
    public void resetPosition(Position position) {
        Logger.info("resetPosition(Position(X=" + position.getX() + ", Y=" + position.getY() + ", Theta=" + position.getTheta() + "): " + "Just a stub - The mobile platform's " + "location and pose would have been " + "changed to the given position.");
    }

    @Override
    public void clearPositionError() {
        Logger.info("Just a stub - The mobile platform's position error would have been cleared, indicating that all error should be relative to the current position.");
    }

    @Override
    public void stop() {
        Logger.info("Just a stub - The mobile platform would have stopped moving.");
    }

    @Override
    public void moveTo(double x, double y) {
        Logger.info("moveTo(" + x + ", " + y + "): " + "Just a stub - The mobile platform " + "should move to the given coordinates.");
    }

    @Override
    public void cmdLinearVelocity(double linearVelocity) {
        Logger.info("cmdLinearVelocity(" + linearVelocity + "): " + "Just a stub - The mobile platform's " + "linear velocity would have been changed.");
    }

    @Override
    public void cmdAngularVelocity(double angularVelocity) {
        Logger.info("cmdAngularVelocity(" + Math.toDegrees(angularVelocity) + DEGREE_SYM + "): " + "Just a stub - The mobile platform's " + "angular velocity would have been changed.");
    }

    @Override
    public void cmdVelocities(double linearVelocity, double angularVelocity) {
        Logger.info("cmdVelocities(" + linearVelocity + ", " + Math.toDegrees(angularVelocity) + DEGREE_SYM + "): Just a stub - The mobile platform's " + "linear and angular velocities would have " + "been changed.");
    }
}

