/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm.impl;

import javax.vecmath.GVector;
import org.eclipse.apogy.examples.robotic_arm.ApogyExamplesRoboticArmFacade;
import org.eclipse.apogy.examples.robotic_arm.MoveSpeedLevel;
import org.eclipse.apogy.examples.robotic_arm.impl.RoboticArmSimulatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoboticArmSimulatedCustomImpl
extends RoboticArmSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(RoboticArmSimulatedImpl.class);
    private static final double MOVE_TO_ANGULAR_SPEED = 10.0;
    private static final int MOVE_TO_WAIT_PERIOD = 1000;

    @Override
    public boolean init() {
        if (this.isInitialized()) {
            Logger.warn("Ignored: The arm has already been successfully called.");
            return true;
        }
        this.setInitialized(true);
        ApogyExamplesRoboticArmFacade.INSTANCE.setActiveRoboticArm(this);
        Logger.info("The robotic arm has been initialized.");
        return true;
    }

    @Override
    public void cmdMoveSpeedLevel(MoveSpeedLevel speedLevel) {
        if (!this.isInitialized()) {
            throw new RuntimeException("Rejected: The robotic arm has not been initialized.");
        }
        Logger.info("Updating the robotic arm's move speed level to <" + speedLevel.getLiteral() + ">.");
        this.setSpeed(speedLevel);
        if (this.isArmMoving()) {
            Logger.info("Note that the updated move speed level applies to all future move requests, NOT the current one.");
        }
    }

    @Override
    public void moveTo(double turretAngle, double shoulderAngle, double elbowAngle, double wristAngle) {
        turretAngle = Math.toDegrees(turretAngle);
        shoulderAngle = Math.toDegrees(shoulderAngle);
        elbowAngle = Math.toDegrees(elbowAngle);
        wristAngle = Math.toDegrees(wristAngle);
        if (!this.isInitialized()) {
            throw new RuntimeException("Rejected: The robotic arm has not been initialized.");
        }
        if (this.isArmMoving()) {
            throw new RuntimeException("Rejected: The robotic arm is currently in the midst of another move request.");
        }
        if (this.getTurretAngle() == turretAngle && this.getShoulderAngle() == shoulderAngle && this.getElbowAngle() == elbowAngle && this.getWristAngle() == wristAngle) {
            Logger.warn("Ignored; no move required as given angles match arm's current joint configuration.");
        } else {
            Logger.info("Robotic arm move started.");
            this.setArmMoving(true);
            GVector initialJointsValues = new GVector(new double[]{this.getTurretAngle(), this.getShoulderAngle(), this.getElbowAngle(), this.getWristAngle()});
            GVector finalJointsValues = new GVector(new double[]{turretAngle, shoulderAngle, elbowAngle, wristAngle});
            this.moveToConfiguration(initialJointsValues, finalJointsValues);
            this.setArmMoving(false);
            Logger.info("Robotic arm move completed.");
        }
    }

    @Override
    public void stow() {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".stow(): ";
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the robotic arm has not been initialized (with init()).";
            throw new RuntimeException(message);
        }
        if (this.isArmMoving()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the robotic arm is currently " + "in the midst of another move request.";
            throw new RuntimeException(message);
        }
        if (this.getTurretAngle() == 0.0 && this.getShoulderAngle() == 90.0 && this.getElbowAngle() == -180.0 && this.getWristAngle() == 0.0) {
            String message = String.valueOf(LOG_PREFIX) + "Ignored; no move required as arm is already " + "in the stow joint configuration.";
            throw new RuntimeException(message);
        }
        Logger.info("Robotic arm stow started.");
        this.setArmMoving(true);
        GVector initialJointsValues = new GVector(new double[]{this.getTurretAngle(), this.getShoulderAngle(), this.getElbowAngle(), this.getWristAngle()});
        GVector finalJointsValues = new GVector(new double[]{0.0, 90.0, -180.0, 0.0});
        this.moveToConfiguration(initialJointsValues, finalJointsValues);
        this.setArmMoving(false);
        Logger.info("Robotic arm stow completed.");
    }

    private void moveToConfiguration(GVector initialJointAngles, GVector finalJointAngles) {
        GVector interpolatedJointAngles = new GVector(initialJointAngles);
        double deltaT = this.computeDeltaTime(initialJointAngles, finalJointAngles);
        double t = -deltaT;
        while (t <= 1.0) {
            interpolatedJointAngles.interpolate(initialJointAngles, finalJointAngles, t += deltaT);
            this.setTurretAngle(interpolatedJointAngles.getElement(0));
            this.setShoulderAngle(interpolatedJointAngles.getElement(1));
            this.setElbowAngle(interpolatedJointAngles.getElement(2));
            this.setWristAngle(interpolatedJointAngles.getElement(3));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.setTurretAngle(finalJointAngles.getElement(0));
        this.setShoulderAngle(finalJointAngles.getElement(1));
        this.setElbowAngle(finalJointAngles.getElement(2));
        this.setWristAngle(finalJointAngles.getElement(3));
    }

    private double computeDeltaTime(GVector initialJointAngles, GVector finalJointAngles) {
        double largestMove = 0.0;
        int i = 0;
        while (i < initialJointAngles.getSize()) {
            double deltaAngle = Math.abs(finalJointAngles.getElement(i) - initialJointAngles.getElement(i));
            if (deltaAngle > largestMove) {
                largestMove = deltaAngle;
            }
            ++i;
        }
        double speed_deg_per_sec = 10.0;
        double travelTime = largestMove / (speed_deg_per_sec *= 0.5 + 0.5 * (double)this.speed.getValue());
        double deltaTime = 1.0 / travelTime;
        return deltaTime;
    }
}

