/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WayPointPathComboComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final Collection<WayPointPath> list = new ArrayList<WayPointPath>();
    private WayPointPath selectedWayPointPath;
    private final ComboViewer comboViewer;

    public WayPointPathComboComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.comboViewer = this.createCombo(this, 8);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    WayPointPathComboComposite.this.newSelection(null);
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof WayPointPath) {
                        WayPointPathComboComposite.this.newSelection((WayPointPath)iStructuredSelection.getFirstElement());
                    } else {
                        WayPointPathComboComposite.this.newSelection(null);
                    }
                }
            }
        });
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 4);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                WayPointPath wayPointPath1 = (WayPointPath)e1;
                WayPointPath wayPointPath2 = (WayPointPath)e2;
                if (wayPointPath1.getLength() > wayPointPath2.getLength()) {
                    return 1;
                }
                if (wayPointPath1.getLength() < wayPointPath2.getLength()) {
                    return -1;
                }
                return wayPointPath1.hashCode() - wayPointPath2.hashCode();
            }
        });
        comboViewer.setInput(this.list);
        return comboViewer;
    }

    public Collection<WayPointPath> getList() {
        return this.list;
    }

    public void setList(Collection<WayPointPath> list) {
        this.list.clear();
        if (list != null) {
            this.list.addAll(list);
        }
        if (this.comboViewer != null) {
            this.comboViewer.setInput(this.list);
            this.comboViewer.refresh();
        }
    }

    public WayPointPath getSelectedWayPointPath() {
        return this.selectedWayPointPath;
    }

    public void setSelectedWayPointPath(WayPointPath selectedWayPointPath) {
        this.selectedWayPointPath = selectedWayPointPath;
        if (selectedWayPointPath != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)selectedWayPointPath));
        } else {
            this.comboViewer.setSelection(null);
        }
    }

    protected void newSelection(WayPointPath selectedWayPointPath) {
    }
}

