/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.ui.preferences;

import org.eclipse.apogy.addons.geometry.paths.ui.Activator;
import org.eclipse.apogy.addons.geometry.paths.ui.PathPresentationMode;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MRTPathsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor wayPointPathVisibilityBooleanFieldEditor;
    private RadioGroupFieldEditor wayPointPathPresentationModeRadioGroupFieldEditor;
    private ColorFieldEditor wayPointPathColorFieldEditor;
    private IntegerFieldEditor wayPointPathPointSizeIntegerFieldEditor;
    private StringFieldEditor wayPointPathEndPointRadiusStringEditor;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Group grpWayPointPath = new Group(container, 0);
        grpWayPointPath.setLayout((Layout)new GridLayout(2, true));
        grpWayPointPath.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        grpWayPointPath.setText("WayPointPath");
        Label wayPointPathVisibilityLabel = new Label((Composite)grpWayPointPath, 0);
        wayPointPathVisibilityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        wayPointPathVisibilityLabel.setText("Visibility");
        this.wayPointPathVisibilityBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpWayPointPath, "DEFAULT_WAYPOINTPATH_VISIBILITY_ID", "");
        this.wayPointPathColorFieldEditor = this.createColorFieldEditor((Composite)grpWayPointPath, "DEFAULT_WAYPOINTPATH_COLOR_ID", "Default Color:");
        Label circularSectorFOVModeLabel = new Label((Composite)grpWayPointPath, 0);
        circularSectorFOVModeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        circularSectorFOVModeLabel.setText("Presentation Mode:");
        this.wayPointPathPresentationModeRadioGroupFieldEditor = this.createPathPresentationRadioGroupFieldEditor((Composite)grpWayPointPath, "DEFAULT_WAYPOINTPATH_PRESENTATION_MODE_ID", "");
        this.wayPointPathPointSizeIntegerFieldEditor = this.createIntegerFieldEditor((Composite)grpWayPointPath, "DEFAULT_WAYPOINTPATH_POINT_SIZE_ID", "Point Size:");
        this.wayPointPathEndPointRadiusStringEditor = this.createStringFieldEditor((Composite)grpWayPointPath, "DEFAULT_WAYPOINTPATH_END_POINT_RADIUS_ID", "End Points Radius (m):");
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        this.wayPointPathVisibilityBooleanFieldEditor.loadDefault();
        this.wayPointPathPresentationModeRadioGroupFieldEditor.loadDefault();
        this.wayPointPathColorFieldEditor.loadDefault();
        this.wayPointPathPointSizeIntegerFieldEditor.loadDefault();
        this.wayPointPathEndPointRadiusStringEditor.loadDefault();
        super.performDefaults();
    }

    private String[][] getModeLabelsAndValues() {
        String[][] labelAndValues = new String[PathPresentationMode.VALUES.size()][2];
        int i = 0;
        for (PathPresentationMode value : PathPresentationMode.VALUES) {
            labelAndValues[i][0] = value.getName();
            labelAndValues[i][1] = Integer.toString(value.getValue());
            ++i;
        }
        return labelAndValues;
    }

    private BooleanFieldEditor createBooleanFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        BooleanFieldEditor editor = new BooleanFieldEditor(preferenceID, preferenceLabel, container);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private RadioGroupFieldEditor createPathPresentationRadioGroupFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(preferenceID, preferenceLabel, 1, this.getModeLabelsAndValues(), editorContainer, false);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private ColorFieldEditor createColorFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        ColorFieldEditor colorEditor = new ColorFieldEditor(preferenceID, preferenceLabel, container);
        colorEditor.setPreferenceStore(this.getPreferenceStore());
        colorEditor.load();
        return colorEditor;
    }

    private IntegerFieldEditor createIntegerFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(preferenceID, preferenceLabel, container);
        integerFieldEditor.setPreferenceStore(this.getPreferenceStore());
        integerFieldEditor.load();
        return integerFieldEditor;
    }

    private StringFieldEditor createStringFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        StringFieldEditor editor = new StringFieldEditor(preferenceID, preferenceLabel, container);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private void storePreferences() {
        this.wayPointPathVisibilityBooleanFieldEditor.store();
        this.wayPointPathPresentationModeRadioGroupFieldEditor.store();
        this.wayPointPathColorFieldEditor.store();
        this.wayPointPathPointSizeIntegerFieldEditor.store();
        this.wayPointPathEndPointRadiusStringEditor.store();
    }
}

