/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.composites;

import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsPackage;
import org.eclipse.apogy.addons.telecoms.TelecomNode;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorTool;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorToolList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TelecomStatusMonitorToolComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final Adapter monitorContentChangeListener;
    private final Adapter listContentChangeListener;
    private final CheckboxTreeViewer treeViewer;
    private TelecomStatusMonitorTool telecomStatusMonitor;
    private TelecomStatusMonitorToolList telecomStatusMonitorList;
    private static final int COLUMN_ENABLED = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_ADDRESS = 2;
    private static final int COLUMN_STATUS = 3;
    private static final int COLUMN_LATENCY = 4;
    private static final int COLUMN_PACKET_LOSS = 5;
    private static final int COLUMN_NO_OF_PACKETS_TO_SEND = 6;
    private static final int COLUMN_TIMEOUT = 7;
    private static final int COLUMN_LATENCY_WARNING = 8;
    private static final int COLUMN_LATENCY_ALARM = 9;
    private static final int COLUMN_PACKET_LOSS_WARNING = 10;
    private static final int COLUMN_PACKET_LOSS_ALARM = 11;

    public TelecomStatusMonitorToolComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, true));
        this.monitorContentChangeListener = new TelecomStatusMonitorToolCompositeMonitorChangeListener();
        this.listContentChangeListener = new TelecomStatusMonitorToolCompositeListChangeListener();
        this.treeViewer = new CheckboxTreeViewer((Composite)this, 101120);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn enabledTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 0x1000000);
        TreeColumn enabledTColumn = enabledTVColumn.getColumn();
        enabledTColumn.setText("Enabled");
        enabledTColumn.setWidth(70);
        TreeViewerColumn nameTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        nameTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(nameTVColumn.getViewer(), 1));
        TreeColumn nameTColumn = nameTVColumn.getColumn();
        nameTColumn.setText("Name");
        nameTColumn.setWidth(175);
        TreeViewerColumn addressTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        addressTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(addressTVColumn.getViewer(), 2));
        TreeColumn addressTColumn = addressTVColumn.getColumn();
        addressTColumn.setText("Network Address");
        addressTColumn.setWidth(175);
        TreeViewerColumn statusTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        TreeColumn statusTColumn = statusTVColumn.getColumn();
        statusTColumn.setText("Status");
        statusTColumn.setWidth(150);
        TreeViewerColumn latencyTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        TreeColumn latencyTColumn = latencyTVColumn.getColumn();
        latencyTColumn.setText("Current Latency (ms)");
        latencyTColumn.setWidth(155);
        TreeViewerColumn packetLossTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        TreeColumn packetLossTColumn = packetLossTVColumn.getColumn();
        packetLossTColumn.setText("Current Packet Loss (%)");
        packetLossTColumn.setWidth(175);
        TreeViewerColumn packetsToSendTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        packetsToSendTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(packetsToSendTVColumn.getViewer(), 6));
        TreeColumn packetsToSendTColumn = packetsToSendTVColumn.getColumn();
        packetsToSendTColumn.setText("Packets To Send (#)");
        packetsToSendTColumn.setWidth(150);
        TreeViewerColumn timeoutTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        timeoutTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(timeoutTVColumn.getViewer(), 7));
        TreeColumn timeoutTColumn = timeoutTVColumn.getColumn();
        timeoutTColumn.setText("Timeout (ms)");
        timeoutTColumn.setWidth(105);
        TreeViewerColumn latencyWarningTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        latencyWarningTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(latencyWarningTVColumn.getViewer(), 8));
        TreeColumn latencyWarningTColumn = latencyWarningTVColumn.getColumn();
        latencyWarningTColumn.setText("Latency Warning (ms)");
        latencyWarningTColumn.setWidth(160);
        TreeViewerColumn latencyAlarmTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        latencyAlarmTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(latencyAlarmTVColumn.getViewer(), 9));
        TreeColumn latencyAlarmTColumn = latencyAlarmTVColumn.getColumn();
        latencyAlarmTColumn.setText("Latency Alarm (ms)");
        latencyAlarmTColumn.setWidth(150);
        TreeViewerColumn packetLossWarningTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        packetLossWarningTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(packetLossWarningTVColumn.getViewer(), 10));
        TreeColumn packetLossWarningTColumn = packetLossWarningTVColumn.getColumn();
        packetLossWarningTColumn.setText("Packet Loss Warning (%)");
        packetLossWarningTColumn.setWidth(180);
        TreeViewerColumn packetLossAlarmTVColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        packetLossAlarmTVColumn.setEditingSupport((EditingSupport)new TelecomStatusMonitorToolCompositeEditingSupport(packetLossAlarmTVColumn.getViewer(), 11));
        TreeColumn packetLossAlarmTColumn = packetLossAlarmTVColumn.getColumn();
        packetLossAlarmTColumn.setText("Packet Loss Alarm (%)");
        packetLossAlarmTColumn.setWidth(165);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                return TelecomStatusMonitorToolComposite.this.telecomStatusMonitor == null ? null : TelecomStatusMonitorToolComposite.this.telecomStatusMonitor.getTelecomNodes().toArray();
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TelecomStatusMonitorToolCompositeLabelProvider((AdapterFactory)this.adapterFactory));
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 2;
            }
        }, (int)0);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof TelecomNode) {
                    TelecomNode node = (TelecomNode)event.getElement();
                    node.setEnabled(event.getChecked());
                }
            }
        });
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof TelecomNode) {
                    return ((TelecomNode)element).isEnabled();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.treeViewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                try {
                    TelecomStatusMonitorToolComposite.this.treeViewer.getTree().setRedraw(false);
                    TelecomStatusMonitorToolComposite.this.treeViewer.getTree().deselectAll();
                }
                finally {
                    TelecomStatusMonitorToolComposite.this.treeViewer.getTree().setRedraw(true);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TelecomStatusMonitorToolComposite.this.telecomStatusMonitor != null) {
                    if (TelecomStatusMonitorToolComposite.this.telecomStatusMonitor.isRunning()) {
                        TelecomStatusMonitorToolComposite.this.telecomStatusMonitor.stop();
                    }
                    TelecomStatusMonitorToolComposite.this.telecomStatusMonitor.eAdapters().remove((Object)TelecomStatusMonitorToolComposite.this.monitorContentChangeListener);
                    TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList.eAdapters().remove((Object)TelecomStatusMonitorToolComposite.this.listContentChangeListener);
                    TelecomStatusMonitorToolComposite.this.telecomStatusMonitor = null;
                    TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList = null;
                }
            }
        });
    }

    public TelecomStatusMonitorTool getTelecomStatusMonitorTool() {
        return this.telecomStatusMonitor;
    }

    public void setTelecomStatusMonitorTool(TelecomStatusMonitorTool statusMonitor) {
        if (this.telecomStatusMonitor == statusMonitor) {
            return;
        }
        if (this.telecomStatusMonitor != null) {
            if (this.telecomStatusMonitor.isRunning()) {
                this.telecomStatusMonitor.stop();
            }
            this.telecomStatusMonitor.eAdapters().remove((Object)this.monitorContentChangeListener);
            this.telecomStatusMonitorList.eAdapters().remove((Object)this.listContentChangeListener);
        }
        this.telecomStatusMonitor = statusMonitor;
        this.telecomStatusMonitorList = this.telecomStatusMonitor != null ? statusMonitor.getStatusMonitorToolList() : null;
        if (!this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setInput((Object)statusMonitor);
            this.treeViewer.expandAll();
            if (statusMonitor != null) {
                statusMonitor.start();
                this.telecomStatusMonitor.eAdapters().add((Object)this.monitorContentChangeListener);
                this.telecomStatusMonitorList.eAdapters().add((Object)this.listContentChangeListener);
            }
        }
    }

    private class TelecomStatusMonitorToolCompositeEditingSupport
    extends EditingSupport {
        private final int column;

        public TelecomStatusMonitorToolCompositeEditingSupport(ColumnViewer viewer, int col) {
            super(viewer);
            this.column = col;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected boolean canEdit(Object element) {
            switch (this.column) {
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }

        protected Object getValue(Object element) {
            if (element instanceof TelecomNode) {
                TelecomNode node = (TelecomNode)element;
                switch (this.column) {
                    case 1: {
                        return node.getName();
                    }
                    case 2: {
                        return node.getAddress();
                    }
                    case 6: {
                        return Integer.toString(node.getPacketsToSend());
                    }
                    case 7: {
                        return Integer.toString(node.getConnectionTimeout());
                    }
                    case 8: {
                        return Double.toString(node.getLatencyWarning());
                    }
                    case 9: {
                        return Double.toString(node.getLatencyAlarm());
                    }
                    case 10: {
                        return Double.toString(node.getPacketLossWarning());
                    }
                    case 11: {
                        return Double.toString(node.getPacketLossAlarm());
                    }
                }
                return null;
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof TelecomNode && value instanceof String) {
                boolean invalidInput = false;
                String errorMsg = "The provided value was not valid; ";
                TelecomNode node = (TelecomNode)element;
                String strVal = (String)value;
                EAttribute feature = null;
                Object setVal = null;
                switch (this.column) {
                    case 1: {
                        feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__NAME;
                        setVal = strVal;
                        break;
                    }
                    case 2: {
                        feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__ADDRESS;
                        setVal = strVal;
                        break;
                    }
                    case 6: {
                        try {
                            int newNoOfPackets = Integer.parseInt(strVal);
                            if (newNoOfPackets <= 0) {
                                invalidInput = true;
                            } else {
                                feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKETS_TO_SEND;
                                setVal = new Integer(newNoOfPackets);
                            }
                        }
                        catch (NumberFormatException ex) {
                            invalidInput = true;
                        }
                        if (!invalidInput) break;
                        errorMsg = String.valueOf(errorMsg) + "The number of packets needs to be a positive whole number (i.e. an integer)";
                        break;
                    }
                    case 7: {
                        try {
                            int newTimeout = Integer.parseInt(strVal);
                            if (newTimeout < 0) {
                                invalidInput = true;
                            } else {
                                feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__CONNECTION_TIMEOUT;
                                setVal = new Integer(newTimeout);
                            }
                        }
                        catch (NumberFormatException ex) {
                            invalidInput = true;
                        }
                        if (!invalidInput) break;
                        errorMsg = String.valueOf(errorMsg) + "The timeout needs to be a non-negative whole number (i.e. an integer)";
                        break;
                    }
                    case 8: {
                        try {
                            double newLatencyWarning = Double.parseDouble(strVal);
                            if (newLatencyWarning < 0.0 || newLatencyWarning >= node.getLatencyAlarm()) {
                                invalidInput = true;
                            } else {
                                feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY_WARNING;
                                setVal = new Double(newLatencyWarning);
                            }
                        }
                        catch (NumberFormatException ex) {
                            invalidInput = true;
                        }
                        if (!invalidInput) break;
                        errorMsg = String.valueOf(errorMsg) + "The latency warning needs to be a non-negative floating point number, that is also less than the current latency alarm value";
                        break;
                    }
                    case 9: {
                        try {
                            double newLatencyAlarm = Double.parseDouble(strVal);
                            if (newLatencyAlarm < 0.0 || newLatencyAlarm <= node.getLatencyWarning()) {
                                invalidInput = true;
                            } else {
                                feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY_ALARM;
                                setVal = new Double(newLatencyAlarm);
                            }
                        }
                        catch (NumberFormatException ex) {
                            invalidInput = true;
                        }
                        if (!invalidInput) break;
                        errorMsg = String.valueOf(errorMsg) + "The latency alarm needs to be a non-negative floating point number, that is also greater than the current latency warning value";
                        break;
                    }
                    case 10: {
                        try {
                            double newPacketLossWarning = Double.parseDouble(strVal);
                            if (newPacketLossWarning < 0.0 || newPacketLossWarning >= 100.0 || newPacketLossWarning >= node.getPacketLossAlarm()) {
                                invalidInput = true;
                            } else {
                                feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS_WARNING;
                                setVal = new Double(newPacketLossWarning);
                            }
                        }
                        catch (NumberFormatException ex) {
                            invalidInput = true;
                        }
                        if (!invalidInput) break;
                        errorMsg = String.valueOf(errorMsg) + "The packet loss warning needs to be a floating point number in [0.0, 100.0), that is also less than the current packet loss alarm value";
                        break;
                    }
                    case 11: {
                        try {
                            double newPacketLossAlarm = Double.parseDouble(strVal);
                            if (newPacketLossAlarm < 0.0 || newPacketLossAlarm >= 100.0 || newPacketLossAlarm <= node.getPacketLossWarning()) {
                                invalidInput = true;
                            } else {
                                feature = ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS_ALARM;
                                setVal = new Double(newPacketLossAlarm);
                            }
                        }
                        catch (NumberFormatException ex) {
                            invalidInput = true;
                        }
                        if (!invalidInput) break;
                        errorMsg = String.valueOf(errorMsg) + "The packet loss alarm needs to be a floating point number in [0.0, 100.0), that is also greater than the current packet loss warning value";
                    }
                }
                if (invalidInput) {
                    MessageBox msgBox = new MessageBox(this.getViewer().getControl().getShell(), 33);
                    msgBox.setText("Invalid Input");
                    msgBox.setMessage(errorMsg);
                    msgBox.open();
                } else {
                    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)node);
                    SetCommand command = new SetCommand(editingDomain, (EObject)node, (EStructuralFeature)feature, setVal);
                    editingDomain.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    private class TelecomStatusMonitorToolCompositeLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        public TelecomStatusMonitorToolCompositeLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return Display.getCurrent().getSystemColor(2);
        }

        public Color getBackground(Object element, int columnIndex) {
            Color color = null;
            if (element instanceof TelecomNode) {
                TelecomNode node = (TelecomNode)element;
                switch (node.getStatus().getValue()) {
                    case 0: {
                        color = Display.getCurrent().getSystemColor(16);
                        break;
                    }
                    case 1: {
                        color = Display.getCurrent().getSystemColor(15);
                        break;
                    }
                    case 2: {
                        color = Display.getCurrent().getSystemColor(12);
                        break;
                    }
                    case 3: {
                        color = Display.getCurrent().getSystemColor(5);
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 8: {
                        color = Display.getCurrent().getSystemColor(7);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 9: {
                        color = Display.getCurrent().getSystemColor(3);
                    }
                }
            }
            return color;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "N/A";
            if (element instanceof TelecomNode) {
                TelecomNode node = (TelecomNode)element;
                switch (columnIndex) {
                    case 0: {
                        result = "";
                        break;
                    }
                    case 1: {
                        result = node.getName();
                        break;
                    }
                    case 2: {
                        result = node.getAddress();
                        break;
                    }
                    case 3: {
                        result = node.getStatus().getLiteral();
                        break;
                    }
                    case 4: {
                        result = Double.toString(node.getLatency());
                        break;
                    }
                    case 5: {
                        result = Double.toString(node.getPacketLoss());
                        break;
                    }
                    case 7: {
                        result = Integer.toString(node.getConnectionTimeout());
                        break;
                    }
                    case 6: {
                        result = Integer.toString(node.getPacketsToSend());
                        break;
                    }
                    case 8: {
                        result = Double.toString(node.getLatencyWarning());
                        break;
                    }
                    case 9: {
                        result = Double.toString(node.getLatencyAlarm());
                        break;
                    }
                    case 10: {
                        result = Double.toString(node.getPacketLossWarning());
                        break;
                    }
                    case 11: {
                        result = Double.toString(node.getPacketLossAlarm());
                    }
                }
            }
            return result;
        }
    }

    private class TelecomStatusMonitorToolCompositeListChangeListener
    extends AdapterImpl {
        private TelecomStatusMonitorToolCompositeListChangeListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof TelecomStatusMonitorToolList) {
                TelecomStatusMonitorToolList statusMonitorList = (TelecomStatusMonitorToolList)notification.getNotifier();
                if (notification.getFeatureID(TelecomStatusMonitorToolList.class) == 7) {
                    if (notification.getEventType() == 4 || notification.getEventType() == 6) {
                        if (!TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList.getTelecomStatusMonitors().contains((Object)TelecomStatusMonitorToolComposite.this.telecomStatusMonitor)) {
                            TelecomStatusMonitorToolComposite.this.setTelecomStatusMonitorTool(null);
                        }
                    } else if (notification.getEventType() == 7 && !TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList.getTelecomStatusMonitors().contains((Object)TelecomStatusMonitorToolComposite.this.telecomStatusMonitor)) {
                        TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList.eAdapters().remove((Object)this);
                        TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList = statusMonitorList;
                        TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList.eAdapters().add((Object)this);
                    }
                } else if (notification.getFeatureID(TelecomStatusMonitorToolList.class) == 3 && notification.getEventType() == 1 && TelecomStatusMonitorToolComposite.this.telecomStatusMonitorList.getToolList() == null) {
                    TelecomStatusMonitorToolComposite.this.setTelecomStatusMonitorTool(null);
                }
            }
        }
    }

    private class TelecomStatusMonitorToolCompositeMonitorChangeListener
    extends AdapterImpl {
        private TelecomStatusMonitorToolCompositeMonitorChangeListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof TelecomStatusMonitorTool) {
                TelecomStatusMonitorTool statusMonitor = (TelecomStatusMonitorTool)notification.getNotifier();
                if (!(notification.getFeatureID(TelecomStatusMonitorTool.class) != 0 || TelecomStatusMonitorToolComposite.this.isDisposed() || statusMonitor.isDisposed() || notification.getEventType() != 3 && notification.getEventType() != 5 && notification.getEventType() != 4 && notification.getEventType() != 6 && notification.getEventType() != 7)) {
                    TelecomStatusMonitorToolComposite.this.treeViewer.refresh();
                }
            }
        }
    }
}

