/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import java.awt.Color;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.telecoms.impl.AntennaRadiationPatternImageMapLayerImpl;

public class AntennaRadiationPatternImageMapLayerCustomImpl
extends AntennaRadiationPatternImageMapLayerImpl {
    protected int[][] getPixelsColor(short[][] lineOfSights) {
        int numberPixelAlongX = lineOfSights.length;
        int numberPixelAlongY = lineOfSights[0].length;
        int noLineOfSightRGB = this.convertColor(this.getLineOfSightNotAvailableColor());
        double minimumGain = 100.0;
        double maximumGain = -100.0;
        float[][] signalPowerDensity = new float[numberPixelAlongX][numberPixelAlongY];
        Matrix4d antennaTransform = this.getObserverPose().asMatrix4d();
        Matrix4d antennaTransformInverse = new Matrix4d(antennaTransform);
        antennaTransformInverse.invert();
        Vector3d antennaPosition = new Vector3d();
        antennaTransform.get(antennaPosition);
        int i = 0;
        while (i < numberPixelAlongX) {
            int j = 0;
            while (j < numberPixelAlongY) {
                short data = lineOfSights[i][j];
                switch (data) {
                    case 2: {
                        Vector3d heightDisplacement = null;
                        if (this.isUseHeightPerpendicularToGround()) {
                            heightDisplacement = new Vector3d(this.pixelNormals[i][j]);
                            heightDisplacement.scale(this.getTargetHeightAboveGround());
                        } else {
                            heightDisplacement = new Vector3d(0.0, 0.0, this.getTargetHeightAboveGround());
                        }
                        Point3d position = new Point3d(this.pixelsIntersectionPoints[i][j]);
                        position.add((Tuple3d)heightDisplacement);
                        Point3d positionInAntennaFrame = new Point3d(position);
                        antennaTransformInverse.transform(positionInAntennaFrame);
                        Vector3d direction = new Vector3d((Tuple3d)positionInAntennaFrame);
                        double distance = direction.length();
                        direction.normalize();
                        float theta = (float)Math.acos(direction.z);
                        float phi = (float)Math.atan2(direction.y, direction.x);
                        double antennaGaindB = this.getAntennaRadiationPattern().computeGain(theta, phi);
                        double antennaGain = Math.pow(10.0, antennaGaindB / 10.0);
                        double powerDensity = antennaGain / (Math.PI * 4 * distance * distance);
                        double powerGain = 10.0 * Math.log10(powerDensity);
                        signalPowerDensity[i][j] = (float)powerGain;
                        if (!(powerGain >= this.getSignalStrengthCutoff())) break;
                        if (powerGain < minimumGain) {
                            minimumGain = powerGain;
                        }
                        if (!(powerGain > maximumGain)) break;
                        maximumGain = powerGain;
                    }
                }
                ++j;
            }
            ++i;
        }
        int[][] pixelColors = new int[numberPixelAlongX][numberPixelAlongY];
        int i2 = 0;
        while (i2 < numberPixelAlongX) {
            int j = 0;
            while (j < numberPixelAlongY) {
                short data = lineOfSights[i2][j];
                switch (data) {
                    case 2: {
                        pixelColors[i2][j] = this.getColor(minimumGain, maximumGain, signalPowerDensity[i2][j]);
                        break;
                    }
                    case 1: {
                        pixelColors[i2][j] = noLineOfSightRGB;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return pixelColors;
    }

    protected int getColor(double minimumGain, double maximumGain, double gain) {
        if (gain > this.getSignalStrengthCutoff()) {
            double factor = 0.0;
            factor = (gain - minimumGain) / (maximumGain - minimumGain);
            if (factor < 0.0) {
                factor = 0.0;
            }
            if (factor > 1.0) {
                factor = 1.0;
            }
            float hue = (float)(0.666 - 0.333 * factor);
            Color color = Color.getHSBColor(hue, 0.9f, 0.9f);
            return color.getRGB();
        }
        return this.convertColor(this.getBellowCutoffColor());
    }
}

