/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import org.eclipse.apogy.addons.telecoms.impl.SimpleRectangularFrustumRadiationPatternImpl;

public class SimpleRectangularFrustumRadiationPatternCustomImpl
extends SimpleRectangularFrustumRadiationPatternImpl {
    protected double maxGain = Double.NaN;

    @Override
    public void setHorizontalFieldOfView(double newHorizontalFieldOfView) {
        super.setHorizontalFieldOfView(newHorizontalFieldOfView);
        this.maxGain = this.computeMaximumGain();
    }

    @Override
    public void setVerticalFieldOfView(double newVerticalFieldOfView) {
        super.setVerticalFieldOfView(newVerticalFieldOfView);
        this.maxGain = this.computeMaximumGain();
    }

    @Override
    public double computeGain(double theta, double phi) {
        double x = Math.sin(theta) * Math.cos(phi);
        double y = Math.sin(theta) * Math.sin(phi);
        double z = Math.cos(theta);
        double azimuth = Math.abs(Math.atan2(y, z));
        double elevation = Math.abs(Math.atan2(x, z));
        if (azimuth <= this.getHorizontalFieldOfView() / 2.0 && elevation <= this.getVerticalFieldOfView() / 2.0) {
            return this.getMaxGain();
        }
        return Double.NEGATIVE_INFINITY;
    }

    private double getMaxGain() {
        if (Double.isNaN(this.maxGain)) {
            this.maxGain = this.computeMaximumGain();
        }
        return this.maxGain;
    }

    private double computeMaximumGain() {
        double frustrumSolidAngle = 4.0 * Math.asin(Math.sin(this.getHorizontalFieldOfView() / 2.0) * Math.sin(this.getVerticalFieldOfView() / 2.0));
        double apertureRatio = Math.PI * 4 / frustrumSolidAngle;
        double gain = 10.0 * Math.log10(apertureRatio);
        return gain;
    }
}

