/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.ApogyAddonsFactory;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.Ruler3dToolNode;
import org.eclipse.apogy.addons.impl.Ruler3DToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodePath;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Ruler3DToolCustomImpl
extends Ruler3DToolImpl {
    public static int FROM_NODE_INDEX = 0;
    public static int TO_NODE_INDEX = 1;
    private int nextNode = FROM_NODE_INDEX;

    @Override
    public void initialise() {
        if (this.getRuler3dToolNode() == null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.RULER3_DTOOL__RULER3D_TOOL_NODE, (Object)this.createRuler3dToolNode());
        }
        super.initialise();
        this.updateRuler();
    }

    @Override
    public void setActive(boolean newActive) {
        super.setActive(newActive);
        if (newActive) {
            this.forceToAndFromReload();
            this.updateRuler();
        }
    }

    @Override
    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        if (this.getRuler3dToolNode() == null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.RULER3_DTOOL__RULER3D_TOOL_NODE, (Object)this.createRuler3dToolNode());
        }
        if (this.getRootNode() != null) {
            this.detachRuler3dToolNode();
        }
        if (newRootNode instanceof GroupNode) {
            ((GroupNode)newRootNode).getChildren().add((Object)this.getRuler3dToolNode());
            this.getRuler3dToolNode().setParent(newRootNode);
        }
        this.updateRuler();
    }

    @Override
    public void variablesInstantiated() {
        super.variablesInstantiated();
        this.forceToAndFromReload();
        this.updateRuler();
    }

    @Override
    public void selectionChanged(NodeSelection nodeSelection) {
        if (!this.isDisposed()) {
            Node node = nodeSelection.getSelectedNode();
            Tuple3d relativePosition = null;
            if (nodeSelection.getRelativeIntersectionPoint() != null) {
                relativePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
            }
            Tuple3d normal = null;
            if (nodeSelection.getAbsoluteIntersectionNormal() != null) {
                normal = ApogyCommonMathFacade.INSTANCE.createTuple3d((double)nodeSelection.getAbsoluteIntersectionNormal().x, (double)nodeSelection.getAbsoluteIntersectionNormal().y, (double)nodeSelection.getAbsoluteIntersectionNormal().z);
            }
            if (this.nextNode == TO_NODE_INDEX) {
                if (!this.isFromNodeLock()) {
                    this.updateFromNode(node, relativePosition, normal);
                } else if (!this.isToNodeLock()) {
                    this.updateToNode(node, relativePosition, normal);
                }
                this.nextNode = FROM_NODE_INDEX;
            } else if (this.nextNode == FROM_NODE_INDEX) {
                if (!this.isToNodeLock()) {
                    this.updateToNode(node, relativePosition, normal);
                } else if (!this.isFromNodeLock()) {
                    this.updateFromNode(node, relativePosition, normal);
                }
                this.nextNode = TO_NODE_INDEX;
            }
        }
    }

    @Override
    public void pointsRelativePoseChanged(Matrix4d newPose) {
        if (!this.isDisposed()) {
            this.updateRuler();
        }
    }

    @Override
    public void dispose() {
        if (this.getRuler3dToolNode() != null) {
            this.detachRuler3dToolNode();
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.RULER3_DTOOL__RULER3D_TOOL_NODE, null);
        super.dispose();
    }

    protected Ruler3dToolNode createRuler3dToolNode() {
        Ruler3dToolNode toolNode = ApogyAddonsFactory.eINSTANCE.createRuler3dToolNode();
        if (this.getName() != null) {
            toolNode.setDescription("Node associated with the Ruler3DTool named <" + this.getName() + ">");
            toolNode.setNodeId("RULER_TOOL_" + this.getName().replaceAll(" ", "_"));
        }
        return toolNode;
    }

    protected void updateFromNode(Node node, Tuple3d relativePosition, Tuple3d normal) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)node);
        if (relativePosition != null) {
            Tuple3d newRelativePosition = (Tuple3d)EcoreUtil.copy((EObject)relativePosition);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_RELATIVE_POSITION, (Object)newRelativePosition);
        }
        NodePath nodePath = null;
        if (node != null) {
            GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
            nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, node);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE_NODE_PATH, nodePath);
        this.updateRuler();
    }

    protected void updateToNode(Node node, Tuple3d relativePosition, Tuple3d normal) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)node);
        if (relativePosition != null) {
            Tuple3d newRelativePosition = (Tuple3d)EcoreUtil.copy((EObject)relativePosition);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_RELATIVE_POSITION, (Object)newRelativePosition);
        }
        NodePath nodePath = null;
        if (node != null) {
            GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
            nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, node);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE_NODE_PATH, nodePath);
        this.updateRuler();
    }

    protected void updateRuler() {
        if (this.getFromNode() != null && this.getToNode() != null) {
            if (this.getToAbsolutePosition() != null && this.getFromAbsolutePosition() != null) {
                Point3d from = new Point3d(this.getFromAbsolutePosition().asTuple3d());
                Point3d to = new Point3d(this.getToAbsolutePosition().asTuple3d());
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__DISTANCE, (Object)from.distance(to));
                return;
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__DISTANCE, (Object)0.0);
            return;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__DISTANCE, (Object)0.0);
    }

    protected void detachRuler3dToolNode() {
        if (this.getRuler3dToolNode() != null && this.getRuler3dToolNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getRuler3dToolNode().getParent();
            parent.getChildren().remove((Object)this.getRuler3dToolNode());
        }
    }
}

