/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.databinding;

import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.FeatureNodeAdapter;
import org.eclipse.apogy.common.emf.databinding.DefaultValueDiff;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureNodeObservableValue
extends AbstractObservableValue<Object> {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureNodeObservableValue.class);
    private Adapter adapter = null;
    private EObject eObject;
    private AbstractFeatureNode featureNode;
    private FeatureNodeAdapter featureNodeAdapter = null;
    private boolean resolved = false;

    public FeatureNodeObservableValue(EObject eObject, AbstractFeatureNode featureNode) {
        this.setEObject(eObject);
        this.setFeatureNode(featureNode);
        this.setResolved(this.getFeatureNodeAdapter().isResolved());
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
        this.getFeatureNodeAdapter().setSourceObject(eObject);
    }

    public void setFeatureNode(AbstractFeatureNode featureNode) {
        this.featureNode = featureNode;
        this.getFeatureNodeAdapter().setFeatureNode(featureNode);
    }

    public Object getValueType() {
        if (this.featureNode instanceof AbstractFeatureNode) {
            AbstractFeatureSpecifier featureSpecifier = (AbstractFeatureSpecifier)this.featureNode;
            if (featureSpecifier.getStructuralFeature().getEType() instanceof EEnum) {
                return featureSpecifier.getStructuralFeature().getEType();
            }
            if (featureSpecifier.getStructuralFeature().getEType() instanceof EClass) {
                return featureSpecifier.getStructuralFeature().getEType();
            }
            return featureSpecifier.getStructuralFeature().getEType().getInstanceClass();
        }
        return null;
    }

    public void resolved(boolean newValue) {
    }

    public boolean isResolved() {
        return this.resolved;
    }

    protected void setResolved(boolean newResolved) {
        this.resolved = newResolved;
        try {
            this.resolved(newResolved);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    protected Object doGetValue() {
        return this.getFeatureNodeAdapter().getCurrentValue();
    }

    public synchronized void removeValueChangeListener(IValueChangeListener<Object> listener) {
        super.removeValueChangeListener(listener);
        if (!this.hasListeners()) {
            this.dispose();
        }
    }

    protected FeatureNodeAdapter getFeatureNodeAdapter() {
        if (this.featureNodeAdapter == null) {
            this.featureNodeAdapter = ApogyCommonEMFFactory.eINSTANCE.createFeatureNodeAdapter();
            this.featureNodeAdapter.eAdapters().add((Object)this.getAdapter());
        }
        return this.featureNodeAdapter;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(FeatureNodeAdapter.class) == 2) {
                        final Object oldValue = notification.getOldValue();
                        final Object newValue = notification.getNewValue();
                        FeatureNodeObservableValue.this.getRealm().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DefaultValueDiff valueDiff = new DefaultValueDiff(oldValue, newValue);
                                FeatureNodeObservableValue.this.fireValueChange(valueDiff);
                            }
                        });
                    } else if (notification.getFeatureID(FeatureNodeAdapter.class) == 3 && notification.getOldBooleanValue() != notification.getNewBooleanValue()) {
                        FeatureNodeObservableValue.this.setResolved(notification.getNewBooleanValue());
                    }
                }
            };
        }
        return this.adapter;
    }

    public synchronized void dispose() {
        this.getFeatureNodeAdapter().eAdapters().remove((Object)this.getAdapter());
        this.setEObject(null);
        this.setFeatureNode(null);
        this.adapter = null;
        this.featureNodeAdapter = null;
        super.dispose();
    }
}

