/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.databinding.converters;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.swt.graphics.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueRangeToColorConverter
extends Converter {
    private static final Logger Logger = LoggerFactory.getLogger(ValueRangeToColorConverter.class);
    private EStructuralFeature eStructuralFeature = null;

    public ValueRangeToColorConverter(EStructuralFeature eStructuralFeature) {
        super(Object.class, Color.class);
        this.eStructuralFeature = eStructuralFeature;
    }

    public Object convert(Object fromObject) {
        Ranges range = this.getNewValueRange(fromObject);
        Color color = ApogyCommonEMFUIFacade.INSTANCE.getColorForRange(range);
        return color;
    }

    protected Ranges getNewValueRange(Object value) {
        try {
            return ApogyCommonEMFFacade.INSTANCE.getRange((ETypedElement)this.eStructuralFeature, value);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return Ranges.UNKNOWN;
        }
    }
}

