/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.EObjectCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractECollectionComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, ItemObject> {
    public static final String TREE_COLUMN_MIN_WIDTH = "TREE_COLUMN_MIN_WIDTH";
    private TreeViewer viewer;
    private Composite detailComposite;
    private Button btnOpen;
    private Button btnDelete;
    private Button btnCopy;
    private Button btnUp;
    private Button btnDown;
    private Button btnImport;
    private Button btnExport;
    private Button btnUnselect;
    private Button btnActivate;
    private Button btnStart;
    private Button btnStop;
    private ITableLabelProvider labelProvider;
    private AdapterFactoryContentProvider contentProvider;
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();

    public AbstractECollectionComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        this(parent, style, featurePath, eStructuralFeature, null);
    }

    public AbstractECollectionComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected ECollectionCompositeSettings getECollectionCompositeSettings() {
        return (ECollectionCompositeSettings)this.getCompositeSettings();
    }

    @Override
    protected void internalRootEObjectChanged(RootEObject rootObject, ResolvedEObject resolvedEObject) {
        if (this.getECollectionCompositeSettings().isCollectionSectionDisplayed()) {
            this.getViewer().setInput(resolvedEObject);
        }
        this.internalSelectionChanged(this.getCurrentSelection());
        this.selectionChanged(this.getCurrentSelection());
    }

    public IStructuredSelection getCurrentSelection() {
        return this.viewer == null ? new StructuredSelection() : this.viewer.getStructuredSelection();
    }

    @Override
    protected Composite createContentComposite(Composite parent, int style) {
        ScrolledForm wrapperForm = this.getFormToolkit().createScrolledForm(parent);
        this.getFormToolkit().paintBordersFor((Composite)wrapperForm);
        wrapperForm.getBody().setLayout((Layout)new FillLayout(256));
        Composite composite = this.getFormToolkit().createComposite(wrapperForm.getBody(), 0);
        this.getFormToolkit().paintBordersFor(composite);
        composite.setLayout((Layout)new FillLayout(256));
        if (this.getECollectionCompositeSettings().isCollectionSectionDisplayed()) {
            Section sctnCollection = this.getFormToolkit().createSection(composite, this.getECollectionCompositeSettings().getCollectionSectionTitle() == null || this.getECollectionCompositeSettings().getCollectionSectionTitle().isEmpty() ? 4096 : 256);
            this.getFormToolkit().paintBordersFor((Composite)sctnCollection);
            sctnCollection.setLayout((Layout)new FillLayout());
            if (this.getECollectionCompositeSettings().getCollectionSectionTitle() != null && !this.getECollectionCompositeSettings().getCollectionSectionTitle().isEmpty()) {
                sctnCollection.setText(this.getECollectionCompositeSettings().getCollectionSectionTitle());
            }
            Composite compositeCollectionSection = this.getFormToolkit().createComposite((Composite)sctnCollection, 2048);
            this.getFormToolkit().paintBordersFor(compositeCollectionSection);
            sctnCollection.setClient((Control)compositeCollectionSection);
            compositeCollectionSection.setLayout((Layout)new GridLayout(this.getECollectionCompositeSettings().isButtonsSectionDisplayed() ? 2 : 1, false));
            this.viewer = this.createViewer(compositeCollectionSection, 0);
            Tree tree = this.viewer.getTree();
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
            this.getFormToolkit().paintBordersFor((Composite)tree);
            this.createColumns(this.viewer);
            this.configure(this.viewer);
            if (this.getECollectionCompositeSettings().isButtonsSectionDisplayed()) {
                Composite buttonComposite = this.getFormToolkit().createComposite(compositeCollectionSection, 0);
                this.getFormToolkit().paintBordersFor(buttonComposite);
                GridData buttonCompositeGridData = new GridData(4, 128, false, false, 1, 1);
                buttonComposite.setLayoutData((Object)buttonCompositeGridData);
                GridLayout buttonGridLayout = new GridLayout(1, true);
                buttonGridLayout.marginHeight = 0;
                buttonGridLayout.marginWidth = 0;
                buttonComposite.setLayout((Layout)buttonGridLayout);
                this.createButtons(buttonComposite, style);
            }
            if (this.getECollectionCompositeSettings().isMultiSelection()) {
                Label lblSelectedItemsCount = new Label(compositeCollectionSection, 0);
                lblSelectedItemsCount.setLayoutData((Object)new GridData(4, 4, false, false));
                lblSelectedItemsCount.setText("");
                tree.addListener(13, e -> {
                    int count = this.viewer.getStructuredSelection().toList().size();
                    lblSelectedItemsCount.setText(count == 0 ? "" : String.valueOf(count) + " items selected");
                });
            }
        }
        if (this.getECollectionCompositeSettings().isDetailSectionDisplayed()) {
            Section sctnDetail = this.getFormToolkit().createSection(composite, this.getECollectionCompositeSettings().getDetailSectionTitle() == null || this.getECollectionCompositeSettings().getDetailSectionTitle().isEmpty() ? 4096 : 256);
            this.getFormToolkit().paintBordersFor((Composite)sctnDetail);
            if (this.getECollectionCompositeSettings().getDetailSectionTitle() != null && !this.getECollectionCompositeSettings().getDetailSectionTitle().isEmpty()) {
                sctnDetail.setText(this.getECollectionCompositeSettings().getDetailSectionTitle());
            }
            Composite compositeDetailSection = this.getFormToolkit().createComposite((Composite)sctnDetail, 2048);
            this.getFormToolkit().paintBordersFor(compositeDetailSection);
            sctnDetail.setClient((Control)compositeDetailSection);
            compositeDetailSection.setLayout((Layout)new GridLayout(1, false));
            compositeDetailSection.setLayoutData((Object)new GridData(4, 4, true, true));
            ScrolledComposite compositeDetailContainer = new ScrolledComposite(compositeDetailSection, 768);
            this.getFormToolkit().paintBordersFor((Composite)compositeDetailContainer);
            compositeDetailContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            compositeDetailContainer.setLayout((Layout)new FillLayout());
            compositeDetailContainer.setAlwaysShowScrollBars(true);
            compositeDetailContainer.setExpandVertical(true);
            compositeDetailContainer.setExpandHorizontal(true);
            this.detailComposite = this.createDetailComposite((Composite)compositeDetailContainer, 2048);
            this.getFormToolkit().paintBordersFor(this.detailComposite);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 5;
            fillLayout.marginHeight = 5;
            this.detailComposite.setLayout((Layout)fillLayout);
            if (this.detailComposite != null) {
                compositeDetailContainer.setContent((Control)this.detailComposite);
            }
        }
        return wrapperForm;
    }

    protected TreeViewer createViewer(Composite parent, int style) {
        TreeViewer treeViewer = new TreeViewer(parent, 0x10300 | (this.getECollectionCompositeSettings().isMultiSelection() ? 2 : 4));
        treeViewer.addSelectionChangedListener(e -> Job.create((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " is raising a new selection"), m -> Display.getDefault().asyncExec(() -> {
            this.internalSelectionChanged(this.getCurrentSelection());
            this.selectionChanged(this.getCurrentSelection());
        })).schedule());
        treeViewer.setUseHashlookup(true);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.labelProvider = this.createLabelProvider((AdapterFactory)adapterFactory);
        if (this.labelProvider != null) {
            treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.contentProvider = this.createContentProvider((AdapterFactory)adapterFactory);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        return treeViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout(1, false));
        return composite;
    }

    private void internalSelectionChanged(IStructuredSelection selection) {
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.getViewer(), (ISelection)selection));
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    public final Composite getDetailComposite() {
        return this.detailComposite;
    }

    protected void configure(TreeViewer viewer) {
        viewer.getTree().setLinesVisible(true);
        ApogyCommonEMFUIFacade.INSTANCE.addHideShowColumnMenu(viewer);
        if (viewer.getTree().getColumnCount() > 1) {
            viewer.getTree().setHeaderVisible(true);
            TreeColumn[] treeColumnArray = viewer.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                Integer minWidth = (Integer)column.getData(TREE_COLUMN_MIN_WIDTH);
                if (minWidth != null) {
                    column.setWidth(minWidth.intValue());
                }
                ++n2;
            }
        }
    }

    protected void createColumns(TreeViewer viewer) {
    }

    public ITableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected void createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Button createNewButton(Composite parent, int style) {
        Button btnNew = AbstractECollectionComposite.createButton(parent, 0, "New", e -> this.doNew());
        this.createNewButtonBindings(btnNew);
        return btnNew;
    }

    protected void createNewButtonBindings(Button button) {
    }

    protected void doNew() {
    }

    protected Button createOpenButton(Composite parent, int style) {
        this.btnOpen = AbstractECollectionComposite.createButton(parent, 0, "Open", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doOpen()));
        this.createOpenButtonBindings(this.btnOpen);
        return this.btnOpen;
    }

    protected void createOpenButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (this.viewer.getStructuredSelection().size() == 1) {
                return true;
            }
            return false;
        });
    }

    protected void doOpen() {
    }

    protected Button createDeleteButton(Composite parent, int style) {
        this.btnDelete = AbstractECollectionComposite.createButton(parent, 0, "Delete", e -> {
            int size = this.viewer.getStructuredSelection().toList().size();
            MessageDialog dialog = new MessageDialog(null, "Delete the selected elements", null, "Are you sure to delete " + (size > 1 ? "these " + size + " elements." : "this element?"), 3, new String[]{"Yes", "No"}, 1);
            if (dialog.open() == 0) {
                BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doDelete());
            }
        });
        this.createDeleteButtonBindings(this.btnDelete);
        return this.btnDelete;
    }

    protected void createDeleteButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (this.viewer.getStructuredSelection().size() > 0) {
                return true;
            }
            return false;
        });
    }

    private void doDelete() {
        this.doDelete((ItemObject)this.getCurrentSelection().toList());
    }

    private void doDelete(List<ItemObject> items) {
        for (ItemObject item : items) {
            this.doDelete(item);
        }
    }

    protected void doDelete(ItemObject object) {
        ApogyCommonTransactionFacade.INSTANCE.basicDelete(this.getResolvedEObject(), this.getEStructuralFeature(), object, true);
    }

    protected Button createCopyButton(Composite parent, int style) {
        this.btnCopy = AbstractECollectionComposite.createButton(parent, 0, "Duplicate", e -> {
            List elements = this.viewer.getStructuredSelection().toList();
            this.doCopy(elements.get(0));
        });
        this.createDeleteButtonBindings(this.btnCopy);
        return this.btnCopy;
    }

    protected void createCopyButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (this.viewer.getStructuredSelection().size() == 1) {
                return true;
            }
            return false;
        });
    }

    protected void doCopy(ItemObject object) {
    }

    protected Button createUpButton(Composite parent, int style) {
        this.btnUp = AbstractECollectionComposite.createButton(parent, 0, "Up", e -> this.doUp());
        this.createUpButtonBindings(this.btnUp);
        return this.btnUp;
    }

    protected void createUpButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null && this.viewer.getTree().getItem(0).getData() != o) {
                return true;
            }
            return false;
        });
    }

    protected void doUp() {
    }

    protected Button createDownButton(Composite parent, int style) {
        this.btnDown = AbstractECollectionComposite.createButton(parent, 0, "Down", e -> this.doDown());
        this.createDownButtonBindings(this.btnDown);
        return this.btnDown;
    }

    protected void createDownButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null && this.viewer.getTree().getItem(this.viewer.getTree().getItems().length - 1).getData() != o) {
                return true;
            }
            return false;
        });
    }

    protected void doDown() {
    }

    protected Button createActivateButton(Composite parent, int style) {
        this.btnActivate = AbstractECollectionComposite.createButton(parent, 0, "Activate", e -> this.doActivate(this.viewer.getStructuredSelection().toList()));
        this.createActivateButtonBindings(this.btnActivate);
        return this.btnActivate;
    }

    protected void createActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doActivate(List<ItemObject> list) {
    }

    protected Button createStartButton(Composite parent, int style) {
        this.btnStart = AbstractECollectionComposite.createButton(parent, 0, "Start", e -> this.doStart(this.viewer.getStructuredSelection().toList()));
        this.createStartButtonBindings(this.btnStart);
        return this.btnStart;
    }

    protected void createStartButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doStart(List<ItemObject> list) {
    }

    protected Button createStopButton(Composite parent, int style) {
        this.btnStop = AbstractECollectionComposite.createButton(parent, 0, "Stop", e -> this.doStop(this.viewer.getStructuredSelection().toList()));
        this.createStopButtonBindings(this.btnStop);
        return this.btnStop;
    }

    protected void createStopButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doStop(List<ItemObject> list) {
    }

    protected Button createImportButton(Composite parent, int style) {
        this.btnImport = AbstractECollectionComposite.createButton(parent, 0, "Import", e -> this.doImport());
        this.createImportButtonBindings(this.btnImport);
        return this.btnImport;
    }

    protected void createImportButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doImport() {
    }

    protected Button createExportButton(Composite parent, int style) {
        this.btnExport = AbstractECollectionComposite.createButton(parent, 0, "Export", e -> this.doExport());
        this.createExportButtonBindings(this.btnExport);
        return this.btnExport;
    }

    protected void createExportButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doExport() {
    }

    protected Button createUnselectButton(Composite parent, int style) {
        this.btnUnselect = AbstractECollectionComposite.createButton(parent, 0, "Unselect", e -> this.unselect());
        this.createUnselectButtonBindings(this.btnUnselect);
        return this.btnUnselect;
    }

    protected void createUnselectButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.viewer, (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    public void unselect() {
        if (this.getECollectionCompositeSettings().isCollectionSectionDisplayed()) {
            this.viewer.setSelection((ISelection)new StructuredSelection());
        }
        this.doUnselect();
    }

    protected void doUnselect() {
    }

    protected ITableLabelProvider createLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider(adapterFactory);
    }

    protected abstract AdapterFactoryContentProvider createContentProvider(AdapterFactory var1);

    protected static Button createButton(Composite parent, int style, String text, Listener listener) {
        Button button = new Button(parent, style);
        button.setText(text);
        if (parent.getLayout() instanceof GridLayout) {
            button.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if (listener != null) {
            button.addListener(13, listener);
        }
        return button;
    }

    protected List<ItemObject> getSelectedItemObjects() {
        ArrayList list = new ArrayList();
        if (this.getCurrentSelection() != null) {
            list.addAll(this.getCurrentSelection().toList());
        }
        return list;
    }

    @Override
    protected EObjectCompositeSettings createDefaultSettings() {
        return ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
    }
}

