/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeDirection implements Enumerator
{
    FORWARD(0, "FORWARD", "Forward"),
    REVERSE(1, "REVERSE", "Reverse");

    public static final int FORWARD_VALUE = 0;
    public static final int REVERSE_VALUE = 1;
    private static final TimeDirection[] VALUES_ARRAY;
    public static final List<TimeDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeDirection[]{FORWARD, REVERSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeDirection get(int value) {
        switch (value) {
            case 0: {
                return FORWARD;
            }
            case 1: {
                return REVERSE;
            }
        }
        return null;
    }

    private TimeDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

