/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.CollectionTimedTimeSource;
import org.eclipse.apogy.common.emf.TimeDirection;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.common.emf.impl.CollectionTimedTimeSourceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionTimedTimeSourceCustomImpl
extends CollectionTimedTimeSourceImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CollectionTimedTimeSourceImpl.class);
    private Adapter timedsListAdapter = null;
    protected static final Date EARLIEST_DATE_EDEFAULT = new Date();
    protected static final Date LATEST_DATE_EDEFAULT = new Date();

    protected CollectionTimedTimeSourceCustomImpl() {
        this.eAdapters().add((Object)this.getTimedsListAdapter());
    }

    @Override
    public void reset() {
        Logger.info("Reset to start.");
        if (!this.getTimedsList().isEmpty()) {
            SortedSet<Timed> sorted = this.getTimeSortedTimedElements();
            this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__CURRENT_TIMED_ELEMENT, sorted.first());
            this.updateTime(new Date(sorted.first().getTime().getTime()));
        }
    }

    @Override
    public void jumpToNext() {
        Logger.info("Jumping to Next.");
        Timed current = this.getCurrentTimedElement();
        if (current != null) {
            SortedSet<Timed> sorted = this.getTimeSortedTimedElements();
            SortedSet<Timed> tail = sorted.tailSet(current);
            if (tail.size() > 1) {
                Iterator it = tail.iterator();
                it.next();
                Timed next = (Timed)it.next();
                this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__CURRENT_TIMED_ELEMENT, next);
                this.updateTime(new Date(next.getTime().getTime()));
            } else if (this.isLoopEnable() && !sorted.isEmpty()) {
                Timed next = sorted.first();
                this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__CURRENT_TIMED_ELEMENT, next);
                this.updateTime(new Date(next.getTime().getTime()));
            }
        }
    }

    @Override
    public void jumpToPrevious() {
        Logger.info("Jumping to Previous.");
        Timed current = this.getCurrentTimedElement();
        if (current != null) {
            SortedSet<Timed> sorted = this.getTimeSortedTimedElements();
            SortedSet<Timed> head = sorted.headSet(current);
            if (!head.isEmpty()) {
                Timed previous = head.last();
                this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__CURRENT_TIMED_ELEMENT, previous);
                this.updateTime(new Date(previous.getTime().getTime()));
            } else if (this.isLoopEnable() && !sorted.isEmpty()) {
                Timed next = sorted.last();
                this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__CURRENT_TIMED_ELEMENT, next);
                this.updateTime(new Date(next.getTime().getTime()));
            }
        }
    }

    protected SortedSet<Timed> getTimeSortedTimedElements() {
        if (this.getTimedsList() != null) {
            return ApogyCommonEMFFacade.INSTANCE.sortTimed((Collection<Timed>)this.getTimedsList());
        }
        return new TreeSet<Timed>();
    }

    @Override
    protected Job getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = new Job("CollectionTimedTimeSource update"){
                private long lastTime;
                {
                    this.lastTime = -1L;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled() && !CollectionTimedTimeSourceCustomImpl.this.disposed) {
                        try {
                            if (CollectionTimedTimeSourceCustomImpl.this.getEarliestDate() != null && CollectionTimedTimeSourceCustomImpl.this.getLatestDate() != null) {
                                if (!CollectionTimedTimeSourceCustomImpl.this.paused) {
                                    Date now = new Date();
                                    if (this.lastTime != -1L) {
                                        long delta = Math.round((float)(now.getTime() - this.lastTime) * CollectionTimedTimeSourceCustomImpl.this.getTimeAcceration());
                                        Date newTime = null;
                                        newTime = CollectionTimedTimeSourceCustomImpl.this.getTimeDirection() == TimeDirection.FORWARD ? new Date(CollectionTimedTimeSourceCustomImpl.this.getTime().getTime() + delta) : new Date(CollectionTimedTimeSourceCustomImpl.this.getTime().getTime() - delta);
                                        if (CollectionTimedTimeSourceCustomImpl.this.getLatestDate() != null && CollectionTimedTimeSourceCustomImpl.this.getEarliestDate() != null) {
                                            if (newTime.getTime() > CollectionTimedTimeSourceCustomImpl.this.getLatestDate().getTime() && CollectionTimedTimeSourceCustomImpl.this.getTimeDirection() == TimeDirection.FORWARD) {
                                                newTime = CollectionTimedTimeSourceCustomImpl.this.isLoopEnable() && CollectionTimedTimeSourceCustomImpl.this.getEarliestDate() != null ? new Date(CollectionTimedTimeSourceCustomImpl.this.getEarliestDate().getTime()) : new Date(CollectionTimedTimeSourceCustomImpl.this.getLatestDate().getTime());
                                            } else if (newTime.getTime() < CollectionTimedTimeSourceCustomImpl.this.getEarliestDate().getTime() && CollectionTimedTimeSourceCustomImpl.this.getTimeDirection() == TimeDirection.REVERSE) {
                                                newTime = CollectionTimedTimeSourceCustomImpl.this.isLoopEnable() && CollectionTimedTimeSourceCustomImpl.this.getEarliestDate() != null ? new Date(CollectionTimedTimeSourceCustomImpl.this.getLatestDate().getTime()) : new Date(CollectionTimedTimeSourceCustomImpl.this.getEarliestDate().getTime());
                                            }
                                        }
                                        CollectionTimedTimeSourceCustomImpl.this.updateTime(newTime);
                                    } else {
                                        CollectionTimedTimeSourceCustomImpl.this.updateTime(now);
                                    }
                                    this.lastTime = now.getTime();
                                }
                                CollectionTimedTimeSourceCustomImpl.this.updateJob.schedule((long)CollectionTimedTimeSourceCustomImpl.this.getUpdatePeriod());
                            }
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.updateJob.schedule();
        }
        return this.updateJob;
    }

    private Adapter getTimedsListAdapter() {
        if (this.timedsListAdapter == null) {
            this.timedsListAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof CollectionTimedTimeSource) {
                        int featureId = msg.getFeatureID(CollectionTimedTimeSource.class);
                        switch (featureId) {
                            case 10: {
                                SortedSet<Timed> sorted = CollectionTimedTimeSourceCustomImpl.this.getTimeSortedTimedElements();
                                if (sorted.isEmpty()) break;
                                Timed element = sorted.first();
                                CollectionTimedTimeSourceCustomImpl.this.setCurrentTimedElement(element);
                                CollectionTimedTimeSourceCustomImpl.this.updateTime(new Date(element.getTime().getTime()));
                                CollectionTimedTimeSourceCustomImpl.this.setEarliestDate(new Date(sorted.first().getTime().getTime()));
                                CollectionTimedTimeSourceCustomImpl.this.setLatestDate(new Date(sorted.last().getTime().getTime()));
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.timedsListAdapter;
    }
}

