/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.las;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ScanDirection implements Enumerator
{
    NEGATIVE(0, "NEGATIVE", "NEGATIVE"),
    POSITIVE(1, "POSITIVE", "POSITIVE");

    public static final int NEGATIVE_VALUE = 0;
    public static final int POSITIVE_VALUE = 1;
    private static final ScanDirection[] VALUES_ARRAY;
    public static final List<ScanDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ScanDirection[]{NEGATIVE, POSITIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ScanDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScanDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScanDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScanDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScanDirection get(int value) {
        switch (value) {
            case 0: {
                return NEGATIVE;
            }
            case 1: {
                return POSITIVE;
            }
        }
        return null;
    }

    private ScanDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

