/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.las.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.geometry.data3d.las.ApogyCommonGeometryData3DLASFactory;
import org.eclipse.apogy.common.geometry.data3d.las.EdgeOfFlightLine;
import org.eclipse.apogy.common.geometry.data3d.las.LASPoint;
import org.eclipse.apogy.common.geometry.data3d.las.ScanDirection;
import org.eclipse.apogy.common.geometry.data3d.las.VariableLengthRecord;
import org.eclipse.apogy.common.geometry.data3d.las.impl.LASReaderImpl;
import org.eclipse.apogy.common.lang.java.io.LittleEndianDataInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class LASReaderCustomImpl
extends LASReaderImpl {
    private LittleEndianDataInputStream dataInputStream;

    @Override
    public EList<LASPoint> getPoints() {
        if (this.points == null) {
            this.points = new EObjectResolvingEList<LASPoint>(LASPoint.class, (InternalEObject)this, 5){
                private static final long serialVersionUID = 1L;

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.points;
    }

    @Override
    public void read() throws IOException {
        this.getLittleEndianInputStream().mark(0);
        this.readHeader();
        this.readVariableLengthRecords();
        this.readPoints();
    }

    private void readPoints() throws FileNotFoundException, IOException {
        this.getLittleEndianInputStream().reset();
        long offsetToPointData = this.header.getOffsetToPointData();
        this.getLittleEndianInputStream().skip(offsetToPointData);
        long nPts = this.header.getNumberOfPointRecords();
        long increment = (long)Math.ceil((double)this.header.getNumberOfPointRecords() / 100.0);
        System.out.println("LASReaderImpl.readPoints() number of points: " + nPts);
        int formatId = this.header.getPointDataFormatID();
        long i = 0L;
        while (i < nPts) {
            LASPoint point = this.createPoint(formatId);
            if (this.getProgressMonitor() != null && (i + 1L) % increment == 0L) {
                this.getProgressMonitor().worked(1);
            }
            this.getPoints().add((Object)point);
            ++i;
        }
    }

    private void readHeader() throws IOException {
        this.header = ApogyCommonGeometryData3DLASFactory.eINSTANCE.createLASHeader();
        byte[] fileSignatureData = new byte[4];
        this.getLittleEndianInputStream().read(fileSignatureData);
        this.header.setFileSignature(new String(fileSignatureData));
        int sourceId = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setFileSourceID(sourceId);
        int encoding = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setGlobalEncoding(encoding);
        int guidData1 = this.getLittleEndianInputStream().readInt();
        this.header.setProjectID_GUID_data_1(guidData1);
        int guidData2 = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setProjectID_GUID_data_2(guidData2);
        int guidData3 = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setProjectID_GUID_data_3(guidData3);
        byte[] guidData4 = new byte[8];
        this.getLittleEndianInputStream().read(guidData4);
        int major = this.getLittleEndianInputStream().read();
        this.header.setVersionMajor(major);
        int minor = this.getLittleEndianInputStream().read();
        this.header.setVersionMinor(minor);
        byte[] systemIdData = new byte[32];
        this.getLittleEndianInputStream().read(systemIdData);
        this.header.setSystemIdentifier(new String(systemIdData));
        byte[] generatingSoftwareData = new byte[32];
        this.getLittleEndianInputStream().read(generatingSoftwareData);
        this.header.setGeneratingSoftware(new String(generatingSoftwareData));
        int fileCreationDayOfYear = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setFileCreationDayOfYear(fileCreationDayOfYear);
        int fileCreationYear = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setFileCreationYear(fileCreationYear);
        int headerSize = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setHeaderSize(headerSize);
        long offsetToPointData = this.readUnsignedInt();
        this.header.setOffsetToPointData(offsetToPointData);
        long nVariableLengthRecords = this.readUnsignedInt();
        this.header.setNVariableLengthRecords(nVariableLengthRecords);
        int pointDataFormat = this.getLittleEndianInputStream().readUnsignedByte();
        if (pointDataFormat >= 4) {
            throw new IllegalArgumentException("Waveform data is not supported");
        }
        this.header.setPointDataFormatID(pointDataFormat);
        int pointDataRecordLength = this.getLittleEndianInputStream().readUnsignedShort();
        this.header.setPointDataRecordLength(pointDataRecordLength);
        long nPointRecords = this.readUnsignedInt();
        this.header.setNumberOfPointRecords(nPointRecords);
        long[] nPointsByReturn = new long[5];
        int i = 0;
        while (i < nPointsByReturn.length) {
            long value;
            nPointsByReturn[i] = value = this.readUnsignedInt();
            ++i;
        }
        this.header.setNumberOfPointsByReturn(nPointsByReturn);
        double xScaleFactor = this.getLittleEndianInputStream().readDouble();
        this.header.setXScaleFactor(xScaleFactor);
        double yScaleFactor = this.getLittleEndianInputStream().readDouble();
        this.header.setYScaleFactor(yScaleFactor);
        double zScaleFactor = this.getLittleEndianInputStream().readDouble();
        this.header.setZScaleFactor(zScaleFactor);
        double xOffset = this.getLittleEndianInputStream().readDouble();
        this.header.setXOffset(xOffset);
        double yOffset = this.getLittleEndianInputStream().readDouble();
        this.header.setYOffset(yOffset);
        double zOffset = this.getLittleEndianInputStream().readDouble();
        this.header.setZOffset(zOffset);
        double maxX = this.getLittleEndianInputStream().readDouble();
        this.header.setMaxX(maxX);
        double minX = this.getLittleEndianInputStream().readDouble();
        this.header.setMinX(minX);
        double maxY = this.getLittleEndianInputStream().readDouble();
        this.header.setMaxY(maxY);
        double minY = this.getLittleEndianInputStream().readDouble();
        this.header.setMinY(minY);
        double maxZ = this.getLittleEndianInputStream().readDouble();
        this.header.setMaxZ(maxZ);
        double minZ = this.getLittleEndianInputStream().readDouble();
        this.header.setMinZ(minZ);
        if (major == 1 && minor == 3) {
            long startOfWaveformDataPacketRecord = this.getLittleEndianInputStream().readLong();
            this.header.setStartOfWaveformDataPacketRecord(startOfWaveformDataPacketRecord);
        }
    }

    private long readUnsignedInt() throws IOException {
        byte[] buf = new byte[4];
        this.getLittleEndianInputStream().readFully(buf, 0, 4);
        return buf[3] << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    private LittleEndianDataInputStream getLittleEndianInputStream() throws FileNotFoundException {
        if (this.dataInputStream == null) {
            InputStream markInputStream = null;
            if (this.getFile() == null && this.getInputStream() == null) {
                throw new IllegalArgumentException();
            }
            markInputStream = this.getFile() != null ? new BufferedInputStream(new FileInputStream(this.getFile())) : (!this.getInputStream().markSupported() ? new BufferedInputStream(this.getInputStream()) : this.getInputStream());
            this.dataInputStream = new LittleEndianDataInputStream(markInputStream);
        }
        return this.dataInputStream;
    }

    private List<VariableLengthRecord> readVariableLengthRecords() throws IOException {
        ArrayList<VariableLengthRecord> list = new ArrayList<VariableLengthRecord>();
        int i = 0;
        while ((long)i < this.header.getNVariableLengthRecords()) {
            VariableLengthRecord vlr = this.readNextVLR();
            list.add(vlr);
            ++i;
        }
        return list;
    }

    private VariableLengthRecord readNextVLR() throws IOException {
        int recordSig = this.getLittleEndianInputStream().readUnsignedShort();
        byte[] userIdData = new byte[16];
        this.getLittleEndianInputStream().read(userIdData);
        String userID = new String(userIdData);
        int recordID = this.getLittleEndianInputStream().readUnsignedShort();
        int rlah = this.getLittleEndianInputStream().readUnsignedShort();
        String description = null;
        byte[] descriptionData = new byte[32];
        this.getLittleEndianInputStream().read(descriptionData);
        description = new String(descriptionData);
        byte[] data = new byte[rlah];
        this.getLittleEndianInputStream().read(data);
        VariableLengthRecord vlr = ApogyCommonGeometryData3DLASFactory.eINSTANCE.createVariableLengthRecord();
        vlr.setReserved(recordSig);
        vlr.setDescription(description);
        vlr.setUserID(userID);
        vlr.setRecordID(recordID);
        vlr.setRecordLengthAfterHeader(rlah);
        return vlr;
    }

    public LASPoint createPoint(int formatID) throws IOException {
        if (formatID >= 4) {
            throw new IllegalArgumentException("Invalid point format");
        }
        LASPoint point = ApogyCommonGeometryData3DLASFactory.eINSTANCE.createLASPoint();
        int x = this.getLittleEndianInputStream().readInt();
        point.setX(x);
        int y = this.getLittleEndianInputStream().readInt();
        point.setY(y);
        int z = this.getLittleEndianInputStream().readInt();
        point.setZ(z);
        int intensity = this.getLittleEndianInputStream().readUnsignedShort();
        point.setIntensity(intensity);
        byte b = this.getLittleEndianInputStream().readByte();
        int returnNumberMask = -32;
        byte returnNumber = (byte)((b & returnNumberMask) >> 5);
        int nReturnsMask = 28;
        byte nReturns = (byte)((b & nReturnsMask) >> 2);
        int scanDirFlag = 2;
        int scanDir = (b & scanDirFlag) >> 1;
        byte eflMask = 1;
        int efl = b & eflMask;
        point.setReturnNumber(returnNumber);
        point.setNumberOfReturns(nReturns);
        point.setScanDirection(ScanDirection.get(scanDir));
        point.setEdgeOfFlightLine(EdgeOfFlightLine.get(efl));
        int classification = this.getLittleEndianInputStream().readUnsignedByte();
        point.setClassification((short)classification);
        byte scanAngle = this.getLittleEndianInputStream().readByte();
        point.setScanAngleRank(scanAngle);
        int userData = this.getLittleEndianInputStream().readUnsignedByte();
        point.setUserData((short)userData);
        int pointSourceId = this.getLittleEndianInputStream().readUnsignedShort();
        point.setPointSourceId(pointSourceId);
        if (formatID == 1 || formatID == 3) {
            double gpsTime = this.getLittleEndianInputStream().readDouble();
            point.setGpsTime(gpsTime);
        }
        if (formatID == 2) {
            int red = this.getLittleEndianInputStream().readUnsignedShort();
            point.setRed(red);
            int green = this.getLittleEndianInputStream().readUnsignedShort();
            point.setGreen(green);
            int blue = this.getLittleEndianInputStream().readUnsignedShort();
            point.setBlue(blue);
        }
        return point;
    }
}

