/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.las.impl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.geometry.data3d.las.ApogyCommonGeometryData3DLASFactory;
import org.eclipse.apogy.common.geometry.data3d.las.LASPoint;
import org.eclipse.apogy.common.geometry.data3d.las.impl.LASWriterImpl;
import org.eclipse.apogy.common.lang.java.io.LittleEndianDataOutputStream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class LASWriterCustomImpl
extends LASWriterImpl {
    public static final int HEADER_SIZE = 235;
    public static final int POINT_RECORD_LENGTH = 34;
    private static final int WRITE_BUFFER_SIZE = 32768;
    private Tuple3d min;
    private Tuple3d max;
    private LittleEndianDataOutputStream output;

    @Override
    public EList<LASPoint> getPoints() {
        if (this.points == null) {
            this.points = new BasicEList();
        }
        return this.points;
    }

    @Override
    public void write() throws IOException {
        this.buildHeader();
        this.openDataStream();
        this.writeHeader();
        for (LASPoint point : this.getPoints()) {
            this.writePoint(point);
        }
        this.output.flush();
        this.output.close();
    }

    private void writePoint(LASPoint point) throws IOException {
        this.output.writeInt((int)point.getX());
        this.output.writeInt((int)point.getY());
        this.output.writeInt((int)point.getZ());
        this.output.writeShort(point.getIntensity());
        byte returnNumber = point.getReturnNumber();
        byte nReturns = point.getNumberOfReturns();
        byte scanDir = (byte)point.getScanDirection().getValue();
        byte edgeOfFlightLine = (byte)point.getEdgeOfFlightLine().getValue();
        byte value = (byte)(returnNumber | nReturns << 3 | scanDir << 6 | edgeOfFlightLine << 7);
        this.output.writeByte((int)value);
        this.output.writeByte((int)point.getClassification());
        this.output.writeByte((int)point.getScanAngleRank());
        this.output.writeByte((int)point.getUserData());
        this.output.writeShort(point.getPointSourceId());
        this.output.writeDouble(point.getGpsTime());
        this.output.writeShort(point.getRed());
        this.output.writeShort(point.getGreen());
        this.output.writeShort(point.getBlue());
    }

    private void openDataStream() throws IOException {
        if (this.getFileName() == null && this.getOutputStream() == null) {
            throw new IllegalArgumentException();
        }
        BufferedOutputStream bos = null;
        if (this.getFileName() != null) {
            FileOutputStream fos = new FileOutputStream(this.getFileName());
            bos = new BufferedOutputStream(fos, 32768);
        } else {
            bos = new BufferedOutputStream(this.getOutputStream(), 32768);
        }
        this.output = new LittleEndianDataOutputStream((OutputStream)bos);
    }

    private void writeHeader() throws IOException {
        this.output.write(this.header.getFileSignature().getBytes());
        this.output.writeShort(this.header.getFileSourceID());
        this.output.writeShort(this.header.getGlobalEncoding());
        this.output.writeInt((int)this.header.getProjectID_GUID_data_1());
        this.output.writeShort(this.header.getProjectID_GUID_data_2());
        this.output.writeShort(this.header.getProjectID_GUID_data_3());
        this.output.write(this.header.getProjectID_GUID_data_4());
        this.output.writeByte(this.header.getVersionMajor());
        this.output.writeByte(this.header.getVersionMinor());
        byte[] systemIdBytes = new byte[32];
        byte[] systemId = this.header.getSystemIdentifier().getBytes();
        int i = 0;
        while (i < systemId.length) {
            if (i < systemIdBytes.length) {
                systemIdBytes[i] = systemId[i];
            }
            ++i;
        }
        this.output.write(systemIdBytes);
        byte[] genSoftwareBytes = new byte[32];
        byte[] genSoftware = this.header.getGeneratingSoftware().getBytes();
        int i2 = 0;
        while (i2 < genSoftware.length) {
            if (i2 < genSoftwareBytes.length) {
                genSoftwareBytes[i2] = genSoftware[i2];
            }
            ++i2;
        }
        this.output.write(genSoftwareBytes);
        this.output.writeShort(this.header.getFileCreationDayOfYear());
        this.output.writeShort(this.header.getFileCreationYear());
        this.output.writeShort(this.header.getHeaderSize());
        this.output.writeInt((int)this.header.getOffsetToPointData());
        this.output.writeInt((int)this.header.getNVariableLengthRecords());
        this.output.writeByte(this.header.getPointDataFormatID());
        this.output.writeShort(this.header.getPointDataRecordLength());
        this.output.writeInt((int)this.header.getNumberOfPointRecords());
        long[] nOfPointsByReturn = this.header.getNumberOfPointsByReturn();
        int i3 = 0;
        while (i3 < nOfPointsByReturn.length) {
            this.output.writeInt((int)nOfPointsByReturn[i3]);
            ++i3;
        }
        this.output.writeDouble(this.header.getXScaleFactor());
        this.output.writeDouble(this.header.getYScaleFactor());
        this.output.writeDouble(this.header.getZScaleFactor());
        this.output.writeDouble(this.header.getXOffset());
        this.output.writeDouble(this.header.getYOffset());
        this.output.writeDouble(this.header.getZOffset());
        this.output.writeDouble(this.header.getMaxX());
        this.output.writeDouble(this.header.getMinX());
        this.output.writeDouble(this.header.getMaxY());
        this.output.writeDouble(this.header.getMinY());
        this.output.writeDouble(this.header.getMaxZ());
        this.output.writeDouble(this.header.getMinZ());
        this.output.writeLong(this.header.getStartOfWaveformDataPacketRecord());
    }

    private void buildHeader() {
        if (!(this.getScaleX() > 0.0)) {
            throw new IllegalArgumentException();
        }
        if (!(this.getScaleY() > 0.0)) {
            throw new IllegalArgumentException();
        }
        if (!(this.getScaleZ() > 0.0)) {
            throw new IllegalArgumentException();
        }
        this.header = ApogyCommonGeometryData3DLASFactory.eINSTANCE.createLASHeader();
        this.header.setFileSignature("LASF");
        this.header.setFileSourceID(0);
        this.header.setGlobalEncoding(0);
        this.header.setProjectID_GUID_data_4(new byte[8]);
        this.header.setVersionMajor(1);
        this.header.setVersionMinor(3);
        this.header.setSystemIdentifier("ASC-CSA");
        this.header.setGeneratingSoftware("ASC-CSA");
        int dayOfYear = Calendar.getInstance().get(6);
        this.header.setFileCreationDayOfYear(dayOfYear);
        int year = Calendar.getInstance().get(1);
        this.header.setFileCreationYear(year);
        this.header.setHeaderSize(235);
        this.header.setOffsetToPointData(235L);
        this.header.setNumberOfPointRecords(0L);
        this.header.setPointDataFormatID(3);
        this.header.setPointDataRecordLength(34);
        this.header.setNumberOfPointRecords(this.getPoints().size());
        this.header.setNumberOfPointsByReturn(new long[5]);
        this.header.setXScaleFactor(this.getScaleX());
        this.header.setYScaleFactor(this.getScaleY());
        this.header.setZScaleFactor(this.getScaleZ());
        this.header.setXOffset(this.getXOffset());
        this.header.setYOffset(this.getYOffset());
        this.header.setZOffset(this.getZOffset());
        this.findExtrema();
        this.header.setMaxX(this.max.x);
        this.header.setMinX(this.min.x);
        this.header.setMaxY(this.max.y);
        this.header.setMinY(this.min.y);
        this.header.setMaxZ(this.max.z);
        this.header.setMinZ(this.min.z);
        this.header.setStartOfWaveformDataPacketRecord(0L);
    }

    private void findExtrema() {
        this.min = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.max = new Point3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (LASPoint point : this.getPoints()) {
            double x = (double)point.getX() * this.getScaleX() + this.getXOffset();
            double y = (double)point.getY() * this.getScaleY() + this.getYOffset();
            double z = (double)point.getZ() * this.getScaleZ() + this.getZOffset();
            if (x > this.max.x) {
                this.max.x = x;
            }
            if (x < this.min.x) {
                this.min.x = x;
            }
            if (y > this.max.y) {
                this.max.y = y;
            }
            if (y < this.min.y) {
                this.min.y = y;
            }
            if (z > this.max.z) {
                this.max.z = z;
            }
            if (!(z < this.min.z)) continue;
            this.min.z = z;
        }
    }
}

