/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui.composites;

import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class AreaSelector
implements MouseListener,
MouseMoveListener {
    public static int SELECTION_BOX_DEFAULT_LINE_WIDTH = 1;
    public static Color SELECTION_BOX_DEFAULT_COLOR = new Color((Device)Display.getDefault(), 0, 0, 0);
    private Color selectionBoxLineColor = SELECTION_BOX_DEFAULT_COLOR;
    private int selectionBoxLineWidth = SELECTION_BOX_DEFAULT_LINE_WIDTH;
    private ImageDisplayComposite imageDisplayComposite = null;
    private final Label imageLabel;
    private Cursor cursor = null;
    private boolean enabled = true;
    private Point corner1 = null;
    private Point corner2 = null;
    private Rectangle selectedArea = null;
    private boolean zoomOnMouseUp = true;

    public AreaSelector(ImageDisplayComposite imageDisplayComposite, Label imageLabel) {
        this.imageDisplayComposite = imageDisplayComposite;
        this.imageLabel = imageLabel;
        this.imageLabel.addMouseListener((MouseListener)this);
        this.imageLabel.addMouseMoveListener((MouseMoveListener)this);
        this.cursor = new Cursor((Device)this.imageLabel.getDisplay(), 2);
        this.imageLabel.setCursor(this.cursor);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enableCursor(enabled);
    }

    public boolean isZoomOnMouseUp() {
        return this.zoomOnMouseUp;
    }

    public void setZoomOnMouseUp(boolean zoomOnMouseUp) {
        this.zoomOnMouseUp = zoomOnMouseUp;
    }

    public Color getSelectionBoxLineColor() {
        return this.selectionBoxLineColor;
    }

    public void setSelectionBoxLineColor(Color lineColor) {
        this.selectionBoxLineColor = lineColor;
    }

    public int getSelectionBoxLineWidth() {
        return this.selectionBoxLineWidth;
    }

    public void setSelectionBoxLineWidth(int selectionBoxLineWidth) {
        this.selectionBoxLineWidth = selectionBoxLineWidth;
    }

    private void enableCursor(boolean enable) {
        if (enable) {
            this.cursor = new Cursor((Device)this.imageLabel.getDisplay(), 2);
            this.imageLabel.setCursor(this.cursor);
        } else {
            this.imageLabel.setCursor(null);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.isEnabled()) {
            this.corner2 = new Point(e.x, e.y);
            Point c2 = this.convertToImageCoordinates(this.corner2);
            if (this.coordinatesFallsOnImage(c2)) {
                this.enableCursor(true);
            } else {
                this.enableCursor(false);
            }
            if (this.corner1 != null) {
                Point c1 = this.convertToImageCoordinates(this.corner1);
                Image image = new Image((Device)this.imageLabel.getDisplay(), this.imageDisplayComposite.getDisplayedImageData());
                GC gc = new GC((Drawable)image);
                gc.setForeground(this.selectionBoxLineColor);
                gc.setLineWidth(this.selectionBoxLineWidth);
                gc.setLineStyle(3);
                gc.drawLine(c1.x, c1.y, c2.x, c1.y);
                gc.drawLine(c2.x, c1.y, c2.x, c2.y);
                gc.drawLine(c2.x, c2.y, c1.x, c2.y);
                gc.drawLine(c1.x, c2.y, c1.x, c1.y);
                this.imageLabel.setImage(image);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.isEnabled()) {
            this.corner1 = new Point(e.x, e.y);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.isEnabled() && this.corner1 != null) {
            this.corner2 = new Point(e.x, e.y);
            Point c1 = this.convertToImageCoordinates(this.corner1);
            Point c2 = this.convertToImageCoordinates(this.corner2);
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (c1.x < c2.x) {
                x = c1.x;
                width = c2.x - c1.x;
                if (c1.y < c2.y) {
                    y = c1.y;
                    height = c2.y - c1.y;
                } else {
                    y = c2.y;
                    height = c1.y - c2.y;
                }
            } else {
                x = c2.x;
                width = c1.x - c2.x;
                if (c1.y < c2.y) {
                    y = c1.y;
                    height = c2.y - c1.y;
                } else {
                    y = c2.y;
                    height = c2.y - c1.y;
                }
            }
            int borderWidth = this.selectionBoxLineWidth;
            this.selectedArea = new Rectangle(x + borderWidth, y + borderWidth, width - 2 * borderWidth, height - 2 * borderWidth);
            if (this.zoomOnMouseUp) {
                this.imageDisplayComposite.zoomInRegion(this.selectedArea);
            }
            this.newSelection(this.convertToOriginalImageCoordinates(this.selectedArea));
            this.corner1 = null;
            this.corner2 = null;
        }
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public void newSelection(Rectangle rectangle) {
    }

    public void setSelectedArea(Rectangle rectangle) {
        this.selectedArea = rectangle;
        this.drawSelectedArea(rectangle);
    }

    private void drawSelectedArea(Rectangle rectangle) {
        Point c1 = this.convertToLabelCoordinates(new Point(rectangle.x, rectangle.y));
        Point c2 = this.convertToLabelCoordinates(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        Image image = new Image((Device)this.imageLabel.getDisplay(), this.imageDisplayComposite.getDisplayedImageData());
        GC gc = new GC((Drawable)image);
        gc.setForeground(this.selectionBoxLineColor);
        gc.setLineWidth(this.selectionBoxLineWidth);
        gc.setLineStyle(3);
        gc.drawLine(c1.x, c1.y, c2.x, c1.y);
        gc.drawLine(c2.x, c1.y, c2.x, c2.y);
        gc.drawLine(c2.x, c2.y, c1.x, c2.y);
        gc.drawLine(c1.x, c2.y, c1.x, c1.y);
        this.imageLabel.setImage(image);
        this.imageLabel.redraw();
    }

    private Point convertToImageCoordinates(Point point) {
        int x0 = (int)Math.floor((double)(this.imageLabel.getSize().x - this.imageDisplayComposite.getDisplayedImageData().width) / 2.0);
        int y0 = (int)Math.floor((double)(this.imageLabel.getSize().y - this.imageDisplayComposite.getDisplayedImageData().height) / 2.0);
        int x = point.x - x0;
        int y = point.y - y0;
        return new Point(x, y);
    }

    private Rectangle convertToOriginalImageCoordinates(Rectangle rectangle) {
        float ratio = this.imageDisplayComposite.getImageData().width / this.imageLabel.getImage().getBounds().width;
        int x = Math.round(ratio * (float)rectangle.x);
        int y = Math.round(ratio * (float)rectangle.y);
        int width = Math.round(ratio * (float)rectangle.width);
        int height = Math.round(ratio * (float)rectangle.height);
        return new Rectangle(x, y, width, height);
    }

    private Point convertToLabelCoordinates(Point point) {
        float xRatio = (float)point.x / (float)this.imageDisplayComposite.getImageData().width;
        int x = Math.round(xRatio * (float)this.imageLabel.getImage().getBounds().width);
        float yRatio = (float)point.y / (float)this.imageDisplayComposite.getImageData().height;
        int y = Math.round(yRatio * (float)this.imageLabel.getImage().getBounds().height);
        return new Point(x, y);
    }

    private boolean coordinatesFallsOnImage(Point point) {
        return point.x >= 0 && point.y >= 0 && point.x <= this.imageDisplayComposite.getDisplayedImageData().width && point.y <= this.imageDisplayComposite.getDisplayedImageData().height;
    }
}

