/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.converters;

import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.ImageData;

public class IFileToImageData
implements IConverter {
    public static final String[] supportedFileExtensions = new String[]{"gif", "jpg", "jpeg", "png", "tiff", "tif", "bmp"};

    public Class<?> getOutputType() {
        return ImageData.class;
    }

    public Class<?> getInputType() {
        return IFile.class;
    }

    public boolean canConvert(Object input) {
        if (input != null) {
            IFile file = (IFile)input;
            String fileExtension = this.getFileExtension(file.getName());
            int i = 0;
            while (i < supportedFileExtensions.length) {
                String supportedExtension = supportedFileExtensions[i];
                if (fileExtension.endsWith(supportedExtension)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object convert(Object input) throws Exception {
        IFile file = (IFile)input;
        ImageData imageData = new ImageData(file.getLocation().toOSString());
        return imageData;
    }

    protected String getFileExtension(String url) {
        String fileExtension = new String();
        String fileName = url;
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            fileExtension = fileName.substring(index);
            fileExtension = fileExtension.toLowerCase();
        }
        return fileExtension;
    }
}

