/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.dynamics.ui.views;

import java.util.List;
import org.eclipse.apogy.common.converters.ui.ApogyCommonConvertersUIFacade;
import org.eclipse.apogy.common.topology.addons.dynamics.ui.actions.PinViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractPinableView<T>
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.apogy.common.topology.addons.dynamics.ui.views.AbstractPinableView";
    private T subject;
    private boolean pinView = false;
    private ISelection currentSelection = null;

    public void setPinView(boolean pinView) {
        this.pinView = pinView;
    }

    public boolean isPinView() {
        return this.pinView;
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void setObject(T object) {
        this.subject = object;
    }

    public T getObject() {
        return this.subject;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.pinView && selection != this.currentSelection) {
            this.currentSelection = selection;
            List list = ApogyCommonConvertersUIFacade.INSTANCE.convert(selection, this.getObjectClass());
            if (list.size() > 0) {
                this.setObject(list.get(0));
            }
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public abstract Class<T> getObjectClass();

    protected void createActions() {
        PinViewAction pinViewAction = new PinViewAction(this);
        pinViewAction.setChecked(this.pinView);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)pinViewAction);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)pinViewAction);
    }
}

