/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lander.apogy.impl;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehicleFactory;
import org.eclipse.apogy.addons.vehicle.ApogySystemVehiclePoseCorrector;
import org.eclipse.apogy.addons.vehicle.ContactProvider;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.AbstractApogySystemPoseCorrector;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.examples.lander.Lander;
import org.eclipse.apogy.examples.lander.apogy.ApogyExamplesLanderApogyFactory;
import org.eclipse.apogy.examples.lander.apogy.LanderData;
import org.eclipse.apogy.examples.lander.apogy.impl.LanderApogySystemApiAdapterImpl;
import org.eclipse.apogy.examples.lander.apogy.impl.PositionAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;

public class LanderApogySystemApiAdapterCustomImpl
extends LanderApogySystemApiAdapterImpl {
    private Adapter positionAdapter = null;

    protected Lander getLander() {
        return (Lander)this.getInstance();
    }

    public void init(Environment environment, Type elementType, EObject instance) {
        super.init(environment, elementType, instance);
        this.positionAdapter = new PositionAdapter(this);
        this.getLander().eAdapters().add((Object)this.positionAdapter);
        ApogySystemVehiclePoseCorrector corrector = ApogyAddonsVehicleFactory.eINSTANCE.createApogySystemVehiclePoseCorrector();
        corrector.setContactProvider((ContactProvider)ApogyAddonsVehicleFactory.eINSTANCE.createLanderSphericalFootContactProvider());
        this.setPoseCorrector((AbstractApogySystemPoseCorrector)corrector);
    }

    public void dispose() {
        if (this.getLander() != null) {
            this.getLander().eAdapters().remove((Object)this.positionAdapter);
            if (this.getLander().getPosition() != null) {
                this.getLander().getPosition().eAdapters().remove((Object)this.positionAdapter);
            }
            this.getLander().dispose();
        }
        this.setPoseCorrector(null);
        super.dispose();
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesLanderApogyFactory.eINSTANCE.createLanderData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (initializationData instanceof LanderData) {
            LanderData landerData = (LanderData)initializationData;
            if (!landerData.isInitialized() && this.getLander().isInitialized() || !landerData.isDisposed() && this.getLander().isDisposed()) {
                String message = "The given initialization data cannot be applied to this lander; the given init data says that the lander should not be initialized or disposed, when it already is in that state.";
                throw new RuntimeException(message);
            }
            if (landerData.isInitialized()) {
                if (!this.getLander().isInitialized()) {
                    this.getLander().init();
                }
                this.getLander().commandLegPosition(landerData.getLegAExtension(), landerData.getLegBExtension(), landerData.getLegCExtension());
                Vector3d coordinates = new Vector3d();
                Matrix3d rotationMatrix = new Matrix3d();
                landerData.getInitialPoseTransform().asMatrix4d().get(coordinates);
                this.getLander().moveTo(coordinates.getX(), coordinates.getY(), coordinates.getZ());
                landerData.getInitialPoseTransform().asMatrix4d().getRotationScale(rotationMatrix);
                Vector3d currAngles = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rotationMatrix);
                this.getLander().changeAttitude(currAngles.getX(), currAngles.getY(), currAngles.getZ());
                this.getLander().getThruster().setMinimumThrust(landerData.getMinThrustLevel());
                this.getLander().getThruster().setMaximumThrust(landerData.getMaxThrustLevel());
                this.getLander().commandThrust(landerData.getCurrThrustLevel());
                this.getLander().commandAngularVelocities(landerData.getXAngularVelocity(), landerData.getYAngularVelocity());
                if (landerData.isFlyingEnabled() && !this.getLander().isFlyingEnabled()) {
                    this.getLander().startFlying(false);
                } else if (!landerData.isFlyingEnabled() && this.getLander().isFlyingEnabled()) {
                    this.getLander().stopFlying();
                }
            }
            if (landerData.isDisposed() && !this.getLander().isDisposed()) {
                this.getLander().dispose();
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (initializationData instanceof LanderData) {
            LanderData landerData = (LanderData)initializationData;
            Matrix4x4 currPose = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(this.getPoseTransform().asMatrix4d());
            landerData.setInitialPoseTransform(currPose);
            landerData.setInitialized(this.getLander().isInitialized());
            landerData.setDisposed(this.getLander().isDisposed());
            landerData.setFlyingEnabled(this.getLander().isFlyingEnabled());
            landerData.setLegAExtension(this.getLander().getLegAExtension());
            landerData.setLegBExtension(this.getLander().getLegBExtension());
            landerData.setLegCExtension(this.getLander().getLegCExtension());
            landerData.setMinThrustLevel(this.getLander().getThruster().getMinimumThrust());
            landerData.setMaxThrustLevel(this.getLander().getThruster().getMaximumThrust());
            landerData.setCurrThrustLevel(this.getLander().getThruster().getCurrentThrust());
            landerData.setXAngularVelocity(this.getLander().getXAngularVelocity());
            landerData.setYAngularVelocity(this.getLander().getYAngularVelocity());
        }
    }
}

