/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.composites;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.ENamedElementReferencesListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.apogy.workspace.ApogyWorkspacePackage;
import org.eclipse.apogy.workspace.PlatformApogyProject;
import org.eclipse.apogy.workspace.PlatformApogyProjectsList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformProjectsListComposite
extends ENamedElementReferencesListComposite<ApogyWorkspaceFacade, PlatformApogyProjectsList, PlatformApogyProject> {
    private static final Logger Logger = LoggerFactory.getLogger(PlatformProjectsListComposite.class);

    public PlatformProjectsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createOpenButton(parent, style);
        this.createSeparator(parent, style);
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createImportButton(parent, style);
        this.createExportButton(parent, style);
    }

    protected void doOpen() {
        try {
            ApogyWorkspaceFacade.INSTANCE.openProject((PlatformApogyProject)this.getSelectedItemObjects().get(0));
        }
        catch (Exception e) {
            String message = "Unable to open project <" + ((PlatformApogyProject)this.getSelectedItemObjects().get(0)).getName() + ">";
            Logger.error(message, (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
        }
    }

    protected void doNew() {
        EObjectWizard<ApogyWorkspaceFacade, PlatformApogyProjectsList, PlatformApogyProject> wizard = new EObjectWizard<ApogyWorkspaceFacade, PlatformApogyProjectsList, PlatformApogyProject>((ApogyWorkspaceFacade)this.getRootEObject(), this.getFeaturePath(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.ENAMED_ELEMENT_REFERENCES_LIST__ENAMED_ELEMENTS, ApogyWorkspacePackage.Literals.PLATFORM_APOGY_PROJECT, null){

            public boolean performFinish() {
                boolean isOk = super.performFinish();
                final PlatformApogyProject platformApogyProject = (PlatformApogyProject)this.getCreatedEObject();
                final String message = "Problems occured while creating project <" + platformApogyProject.getName() + ">.";
                if (isOk) {
                    WorkspaceModifyOperation apogyPojectOperation = new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            try {
                                try {
                                    IProject project = ApogyWorkspaceFacade.INSTANCE.createProject(platformApogyProject.getName(), "");
                                    platformApogyProject.setWorkspaceProject(project);
                                }
                                catch (Exception e) {
                                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
                                    Logger.error(message, (Throwable)e);
                                    monitor.done();
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    try {
                        this.getContainer().run(false, false, (IRunnableWithProgress)apogyPojectOperation);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
                        Logger.error(message, (Throwable)e);
                    }
                }
                return isOk;
            }
        };
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        wizard.setWindowTitle("Create a new Apogy project");
        dialog.open();
    }

    protected void doDelete(PlatformApogyProject project) {
        try {
            super.doDelete((Object)project);
            ApogyWorkspaceFacade.INSTANCE.deleteProject(project);
        }
        catch (Exception e) {
            String message = "Unable to delete the project <" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName() + ">";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            Logger.error(message, (Throwable)e);
        }
    }

    protected void doImport() {
        System.err.println("PlatformProjectsListComposite.doImport()");
    }

    protected void doExport() {
        System.out.println("PlatformProjectsListComposite.doExport()");
    }

    protected PlatformApogyProjectsList processResolvedEObject(ApogyWorkspaceFacade rootEObject, FeaturePath featurePath) {
        return ApogyWorkspaceFacade.INSTANCE.getPlatformProjectsList();
    }
}

