/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileSelectionWizardPage
extends WizardPage {
    private String[] fileExtensions = null;
    private final String currentDir = System.getProperty("user.dir");
    private String selectedFileName = null;

    public FileSelectionWizardPage(String pageName) {
        super(pageName);
    }

    public FileSelectionWizardPage(String pageName, String[] fileExtensions) {
        super(pageName);
        this.fileExtensions = fileExtensions;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        System.out.println(parent.getLayout());
        Label label = new Label(composite, 0);
        label.setText("File Path :");
        final Text text = new Text(composite, 2056);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button(composite, 8);
        button.setText("Select File ...");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileChooser = new FileDialog(FileSelectionWizardPage.this.getShell(), 4096);
                fileChooser.setText("Select a file:");
                fileChooser.setFilterPath(FileSelectionWizardPage.this.currentDir);
                String[] extensions = FileSelectionWizardPage.this.fileExtensions;
                if (extensions == null || extensions.length == 0) {
                    extensions = new String[]{"*.*"};
                }
                fileChooser.setFilterExtensions(FileSelectionWizardPage.this.fileExtensions);
                String filename = fileChooser.open();
                if (filename != null) {
                    FileSelectionWizardPage.this.selectedFileName = filename;
                    text.setText(FileSelectionWizardPage.this.selectedFileName);
                    text.setToolTipText(FileSelectionWizardPage.this.selectedFileName);
                    FileSelectionWizardPage.this.fileSelected(FileSelectionWizardPage.this.selectedFileName);
                    FileSelectionWizardPage.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)composite);
    }

    public String getSelectedFileName() {
        return this.selectedFileName;
    }

    protected void fileSelected(String selectedFilePath) {
    }

    public boolean isPageComplete() {
        return this.selectedFileName != null;
    }
}

