/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.definition;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.message.field.PrimitiveFieldType;

public class MessageDefinitionParser {
    private final MessageDefinitionVisitor visitor;

    public MessageDefinitionParser(MessageDefinitionVisitor visitor) {
        this.visitor = visitor;
    }

    public void parse(String messageType, String messageDefinition) {
        Preconditions.checkNotNull((Object)messageType);
        Preconditions.checkNotNull((Object)messageDefinition);
        BufferedReader reader = new BufferedReader(new StringReader(messageDefinition));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                this.parseField(messageType, line);
            }
        }
        catch (IOException e) {
            throw new RosRuntimeException(e);
        }
    }

    private void parseField(String messageType, String fieldDefinition) {
        String[] typeAndName = fieldDefinition.split("\\s+", 2);
        Preconditions.checkState((typeAndName.length == 2 ? 1 : 0) != 0, (Object)String.format("Invalid field definition: \"%s\"", fieldDefinition));
        String type = typeAndName[0];
        String name = typeAndName[1];
        String value = null;
        if (name.contains("=") && (!name.contains("#") || name.indexOf(35) > name.indexOf(61))) {
            String[] nameAndValue = name.split("=", 2);
            name = nameAndValue[0].trim();
            value = nameAndValue[1].trim();
        } else if (name.contains("#")) {
            Preconditions.checkState((!name.startsWith("#") ? 1 : 0) != 0, (Object)String.format("Fields must define a name. Field definition in %s was: \"%s\"", messageType, fieldDefinition));
            name = name.substring(0, name.indexOf(35));
            name = name.trim();
        }
        boolean array = false;
        int size = -1;
        if (type.endsWith("]")) {
            int leftBracketIndex = type.lastIndexOf(91);
            int rightBracketIndex = type.lastIndexOf(93);
            array = true;
            if (rightBracketIndex - leftBracketIndex > 1) {
                size = Integer.parseInt(type.substring(leftBracketIndex + 1, rightBracketIndex));
            }
            type = type.substring(0, leftBracketIndex);
        }
        if (type.equals("Header")) {
            Preconditions.checkState((boolean)name.equals("header"), (Object)"Header field must be named \"header.\"");
            type = "std_msgs/Header";
        } else if (!PrimitiveFieldType.existsFor(type) && !type.contains("/")) {
            type = String.valueOf(messageType.substring(0, messageType.lastIndexOf(47) + 1)) + type;
        }
        if (value != null) {
            if (array) {
                throw new UnsupportedOperationException("Array constants are not supported.");
            }
            if (!type.equals(PrimitiveFieldType.STRING.getName()) && value.contains("#")) {
                Preconditions.checkState((!value.startsWith("#") ? 1 : 0) != 0, (Object)"Constants must define a value.");
                value = value.substring(0, value.indexOf(35));
                value = value.trim();
            }
            this.visitor.constantValue(type, name, value);
        } else if (array) {
            this.visitor.variableList(type, size, name);
        } else {
            this.visitor.variableValue(type, name);
        }
    }

    public static interface MessageDefinitionVisitor {
        public void constantValue(String var1, String var2, String var3);

        public void variableValue(String var1, String var2);

        public void variableList(String var1, int var2, String var3);
    }
}

