/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.1", "output_model_version=0.7.2"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.1 to 0.7.2 : Executing SW converter for model file : {}", (Object)targetFile.getName());
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateBuffering(rootElement);
        this.updateSamplingType(rootElement);
        this.updateInstructionsConstant(rootElement);
        this.updateInstructionsDeviation(rootElement);
        this.updateProbabilityGroup(rootElement);
        this.updateGroup(rootElement);
        this.updatePreemption(rootElement);
    }

    private void updateBuffering(Element rootElement) {
        StringBuilder labelXpathBuffer = new StringBuilder();
        labelXpathBuffer.append("./swModel/labels");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)labelXpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element labelElement : elements) {
            Attribute bufferedAttribute = labelElement.getAttribute("buffered");
            if (bufferedAttribute == null) continue;
            bufferedAttribute.setName("dataStability");
            String bufferedValue = bufferedAttribute.getValue();
            if (bufferedValue.equals("buffered")) {
                bufferedAttribute.setValue("customProtection");
                continue;
            }
            if (!bufferedValue.equals("notBuffered")) continue;
            bufferedAttribute.setValue("noProtection");
        }
        StringBuilder labelAccessXpathBuffer = new StringBuilder();
        labelAccessXpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:LabelAccess\"]");
        labelAccessXpathBuffer.append("|");
        labelAccessXpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:LabelAccess\"]");
        List labelAccesselements = HelperUtil.getXpathResult((Element)rootElement, (String)labelAccessXpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element labelAccessElement : labelAccesselements) {
            Attribute bufferedAttribute = labelAccessElement.getAttribute("buffered");
            if (bufferedAttribute == null) continue;
            bufferedAttribute.setName("dataStability");
            String bufferedValue = bufferedAttribute.getValue();
            if (bufferedValue.equals("inherited")) {
                bufferedAttribute.setValue("inherited");
                continue;
            }
            if (bufferedValue.equals("buffered")) {
                bufferedAttribute.setValue("customProtection");
                continue;
            }
            if (!bufferedValue.equals("notBuffered")) continue;
            bufferedAttribute.setValue("noProtection");
        }
    }

    private void updateSamplingType(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./stimuliModel/stimuli/stimulusDeviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel/accessPaths/latencies[@xsi:type=\"am:LatencyDeviation\"]/deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/schedulingUnit/instructions/deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/schedulingUnit/instructions/deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads//deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//deviation");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element deviation : elements) {
            String distributionType;
            Attribute samplingTypeAttribute = deviation.getAttribute("samplingType");
            if (samplingTypeAttribute == null) continue;
            String value = samplingTypeAttribute.getValue();
            Element distribution = deviation.getChild("distribution");
            if (distribution != null && (distributionType = distribution.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) != null && distributionType.equals("am:Boundaries")) {
                distribution.setAttribute("samplingType", value);
            }
            deviation.removeAttribute(samplingTypeAttribute);
        }
    }

    private void updateInstructionsConstant(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:InstructionsConstant\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:InstructionsConstant\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element instructionsConstantElement : elements) {
            Attribute typeAttribute = instructionsConstantElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            typeAttribute.setValue("am:RunnableInstructions");
            Attribute valueAttribute = instructionsConstantElement.getAttribute("value");
            Element subInstructionsConstantElement = new Element("default");
            subInstructionsConstantElement.setAttribute("type", "am:InstructionsConstant", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (valueAttribute != null) {
                subInstructionsConstantElement.setAttribute("value", valueAttribute.getValue());
                instructionsConstantElement.removeAttribute(valueAttribute);
            }
            instructionsConstantElement.addContent((Content)subInstructionsConstantElement);
        }
    }

    private void updateInstructionsDeviation(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:InstructionsDeviation\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:InstructionsDeviation\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element instructionsDeviationElement : elements) {
            Attribute typeAttribute = instructionsDeviationElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            typeAttribute.setValue("am:RunnableInstructions");
            Element subInstructionsDeviationElement = new Element("default");
            subInstructionsDeviationElement.setAttribute("type", "am:InstructionsDeviation", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            List instructionsDeviationChildElements = instructionsDeviationElement.getChildren();
            Iterator instructionsDeviationChildElements_iterator = instructionsDeviationChildElements.iterator();
            while (instructionsDeviationChildElements_iterator.hasNext()) {
                Element nextChildElement = (Element)instructionsDeviationChildElements_iterator.next();
                instructionsDeviationChildElements_iterator.remove();
                subInstructionsDeviationElement.addContent((Content)nextChildElement);
            }
            instructionsDeviationElement.addContent((Content)subInstructionsDeviationElement);
        }
    }

    private void updatePreemption(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/processPrototypes[@preemption=\"unknown\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks[@preemption=\"unknown\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : elements) {
            element.removeAttribute("preemption");
        }
    }

    private void updateGroup(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:Group\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:Group\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//items[@xsi:type=\"am:Group\"]");
        List runnableItemElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element runnableItemElement : runnableItemElements) {
            List deviationRunnableItemsList = HelperUtil.getXpathResult((Element)runnableItemElement, (String)"./items", Element.class, (Namespace[])new Namespace[0]);
            for (Element deviationRunnableItemElement : deviationRunnableItemsList) {
                List childRunnableItems = HelperUtil.getXpathResult((Element)deviationRunnableItemElement, (String)"./runnableItem", Element.class, (Namespace[])new Namespace[0]);
                if (childRunnableItems != null && !childRunnableItems.isEmpty()) {
                    Element childRunnableItem = (Element)childRunnableItems.get(0);
                    deviationRunnableItemElement.removeContent((Content)childRunnableItem);
                    childRunnableItem.setName("items");
                    runnableItemElement.removeContent((Content)deviationRunnableItemElement);
                    runnableItemElement.addContent((Content)childRunnableItem);
                    continue;
                }
                runnableItemElement.removeContent((Content)deviationRunnableItemElement);
            }
        }
    }

    private void updateProbabilityGroup(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:ProbabilityGroup\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:ProbabilityGroup\"]");
        List runnableItemElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element runnableItemElement : runnableItemElements) {
            Attribute typeAttribute = runnableItemElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            typeAttribute.setValue("am:RunnableProbabilitySwitch");
            List itemsElements = runnableItemElement.getChildren("items");
            for (Element itemsElement : itemsElements) {
                itemsElement.setName("entries");
                Element childRunnableItemElement = itemsElement.getChild("runnableItem");
                if (childRunnableItemElement == null) continue;
                childRunnableItemElement.setName("items");
            }
        }
    }
}

