/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters072.utils.HwElementsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters072.utils.HwElementsCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.1", "output_model_version=0.7.2"}, service={IConverter.class})
public class PropertyConstraintsConverter
extends AbstractConverter {
    private static final String AMLT_PREFIX = "amlt:/#";
    private static final String XSI = "xsi";
    private static final String NAME = "name";
    private static final String SYSTEM = "system";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyConstraintsConverter.class);
    private HwElementsCacheBuilder cache;
    private Map<File, Document> fileDocumentMapping;
    private File targetFile;
    private Map.Entry<File, Element> firstOccuranceOfHwModelInModelScope;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.1 to 0.7.2 : Executing PropertyConstraints converter for model file : {}", (Object)targetFile.getName());
        this.cache = this.getHwElementsCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("HwElementsCacheBuilder is not built and Object of it is not available in Converters");
        }
        this.fileDocumentMapping = fileDocumentMapping;
        this.targetFile = targetFile;
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.removeCoreTypesAndMemoryTypes(rootElement);
        this.updateCoreRefs(rootElement);
        this.updateMemoryRefs(rootElement);
    }

    private void removeCoreTypesAndMemoryTypes(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./propertyConstraintsModel");
        List propertyConstraintsModelElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        if (!propertyConstraintsModelElements.isEmpty()) {
            Element propertyConstraintsModel = (Element)propertyConstraintsModelElements.get(0);
            List coreTypeDefinitions = propertyConstraintsModel.getChildren("coreTypeDefinitions");
            Iterator coreTypesIterator = coreTypeDefinitions.iterator();
            while (coreTypesIterator.hasNext()) {
                Map.Entry<File, Element> entry;
                Element coreTypeDefinition = (Element)coreTypesIterator.next();
                String coreTypeName = coreTypeDefinition.getAttributeValue(NAME);
                coreTypesIterator.remove();
                propertyConstraintsModel.removeContent((Content)coreTypeDefinition);
                if (coreTypeName == null || this.isHWElementPresentInCache(HwElementsCacheEnum.CORE_TYPE_NAMES, coreTypeName) || (entry = this.getFirstOccuranceOfHwModelFromModelFiles()) == null) continue;
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                coreTypeDefinition.setName("coreTypes");
                hwModelElement.addContent((Content)coreTypeDefinition);
                List coreTypeNames = (List)this.cache.getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.CORE_TYPE_NAMES.name());
                coreTypeNames.add(coreTypeName);
            }
            List memoryTypeDefinitions = propertyConstraintsModel.getChildren("memoryTypeDefinitions");
            Iterator memoryTypesIterator = memoryTypeDefinitions.iterator();
            while (memoryTypesIterator.hasNext()) {
                Map.Entry<File, Element> entry;
                Element memoryTypeDefinition = (Element)memoryTypesIterator.next();
                String memoryTypeName = memoryTypeDefinition.getAttributeValue(NAME);
                memoryTypesIterator.remove();
                propertyConstraintsModel.removeContent((Content)memoryTypeDefinition);
                if (memoryTypeName == null || this.isHWElementPresentInCache(HwElementsCacheEnum.MEMORY_TYPE_NAMES, memoryTypeName) || (entry = this.getFirstOccuranceOfHwModelFromModelFiles()) == null) continue;
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                memoryTypeDefinition.setName("memoryTypes");
                hwModelElement.addContent((Content)memoryTypeDefinition);
                List memoryTypeNames = (List)this.cache.getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.MEMORY_TYPE_NAMES.name());
                memoryTypeNames.add(memoryTypeName);
            }
        }
    }

    private void updateMemoryRefs(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./propertyConstraintsModel//firstConstraint[@xsi:type=\"am:HwMemoryProperty\"]/memory");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//secondConstraint[@xsi:type=\"am:HwMemoryProperty\"]/memory");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//hwConstraint[@xsi:type=\"am:HwMemoryProperty\"]/memory");
        List memoryElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element memoryElement : memoryElements) {
            Map.Entry<File, Element> entry;
            String memoryName = memoryElement.getAttributeValue(NAME);
            Element parent = memoryElement.getParentElement();
            parent.removeContent((Content)memoryElement);
            if (memoryName == null) continue;
            if (!this.isHWElementPresentInCache(HwElementsCacheEnum.MEMORY_NAMES, memoryName) && (entry = this.getFirstOccuranceOfHwModelFromModelFiles()) != null) {
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                Element system = hwModelElement.getChild(SYSTEM);
                if (system == null) {
                    system = new Element(SYSTEM);
                    system.setAttribute(NAME, "migration_gen_system");
                    hwModelElement.addContent((Content)system);
                }
                Element genMemoryElement = new Element("memories");
                genMemoryElement.setAttribute(NAME, memoryName);
                system.addContent((Content)genMemoryElement);
                List memoryNames = (List)this.cache.getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.MEMORY_NAMES.name());
                memoryNames.add(memoryName);
            }
            if (this.isElementDefinedInFile(memoryName, HwElementsCacheEnum.MEMORY_NAMES, this.targetFile)) {
                parent.setAttribute(new Attribute("memory", String.valueOf(this.encodeName(memoryName)) + "?type=Memory"));
                continue;
            }
            Element refMemoryElement = new Element("memory");
            refMemoryElement.setAttribute("href", AMLT_PREFIX + this.encodeName(memoryName) + "?type=Memory");
            parent.addContent((Content)refMemoryElement);
        }
    }

    private void updateCoreRefs(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./propertyConstraintsModel//firstConstraint[@xsi:type=\"am:HwCoreProperty\"]/core");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//secondConstraint[@xsi:type=\"am:HwCoreProperty\"]/core");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel//hwConstraint[@xsi:type=\"am:HwCoreProperty\"]/core");
        List coreElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element coreElement : coreElements) {
            Map.Entry<File, Element> entry;
            String coreName = coreElement.getAttributeValue(NAME);
            Element parent = coreElement.getParentElement();
            parent.removeContent((Content)coreElement);
            if (coreName == null) continue;
            if (!this.isHWElementPresentInCache(HwElementsCacheEnum.CORE_NAMES, coreName) && (entry = this.getFirstOccuranceOfHwModelFromModelFiles()) != null) {
                Element ecus;
                List ecuElements;
                File fileAssociatedToHwElement = entry.getKey();
                Element hwModelElement = entry.getValue();
                Element system = hwModelElement.getChild(SYSTEM);
                if (system == null) {
                    system = new Element(SYSTEM);
                    system.setAttribute(NAME, "migration_gen_system");
                    hwModelElement.addContent((Content)system);
                }
                if (!(ecuElements = HelperUtil.getXpathResult((Element)system, (String)".//ecus[@name=\"migration_gen_ecu\"]", Element.class, (Namespace[])new Namespace[0])).isEmpty()) {
                    ecus = (Element)ecuElements.get(0);
                    List microControllersList = ecus.getChildren("microcontrollers");
                    for (Element microControllers : microControllersList) {
                        String microControllerName = microControllers.getAttributeValue(NAME);
                        if (microControllerName == null || !microControllerName.equals("migration_gen_microcontroller")) continue;
                        coreElement.setName("cores");
                        microControllers.addContent((Content)coreElement);
                        break;
                    }
                } else {
                    ecus = new Element("ecus");
                    ecus.setAttribute(NAME, "migration_gen_ecu");
                    system.addContent((Content)ecus);
                    Element microControllers = new Element("microcontrollers");
                    microControllers.setAttribute(NAME, "migration_gen_microcontroller");
                    ecus.addContent((Content)microControllers);
                    coreElement.setName("cores");
                    microControllers.addContent((Content)coreElement);
                }
                List coreNames = (List)this.cache.getCacheMap().get(fileAssociatedToHwElement).get(HwElementsCacheEnum.CORE_NAMES.name());
                coreNames.add(coreName);
            }
            if (this.isElementDefinedInFile(coreName, HwElementsCacheEnum.CORE_NAMES, this.targetFile)) {
                parent.setAttribute(new Attribute("core", String.valueOf(this.encodeName(coreName)) + "?type=Core"));
                continue;
            }
            Element refCoreElement = new Element("core");
            refCoreElement.setAttribute("href", AMLT_PREFIX + this.encodeName(coreName) + "?type=Core");
            parent.addContent((Content)refCoreElement);
        }
    }

    private Map.Entry<File, Element> getFirstOccuranceOfHwModelFromModelFiles() {
        Element rootElement;
        if (this.firstOccuranceOfHwModelInModelScope != null) {
            return this.firstOccuranceOfHwModelInModelScope;
        }
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Set<File> fileSet = this.fileDocumentMapping.keySet();
        TreeSet<File> sortedInputFileSet = new TreeSet<File>(fileSet);
        for (File file : sortedInputFileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(HwElementsCacheEnum.HwModel.name());
            if (!(object instanceof Element)) continue;
            this.firstOccuranceOfHwModelInModelScope = new AbstractMap.SimpleEntry<File, Element>(file, (Element)object);
            return this.firstOccuranceOfHwModelInModelScope;
        }
        File firstInputModelFile = sortedInputFileSet.first();
        Document document = this.fileDocumentMapping.get(firstInputModelFile);
        if (document != null && (rootElement = document.getRootElement()).getName().equals("Amalthea")) {
            Element hwModel = new Element("hwModel");
            rootElement.addContent((Content)hwModel);
            Map<String, Object> map = cacheMap.get(firstInputModelFile);
            map.put(HwElementsCacheEnum.HwModel.name(), hwModel);
            this.firstOccuranceOfHwModelInModelScope = new AbstractMap.SimpleEntry<File, Element>(firstInputModelFile, hwModel);
            return this.firstOccuranceOfHwModelInModelScope;
        }
        return null;
    }

    private boolean isHWElementPresentInCache(HwElementsCacheEnum type, String hwElementName) {
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Set<File> fileSet = this.fileDocumentMapping.keySet();
        for (File file : fileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(type.name());
            if (!(object instanceof List) || !((List)object).contains(hwElementName)) continue;
            return true;
        }
        return false;
    }

    private HwElementsCacheBuilder getHwElementsCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof HwElementsCacheBuilder)) continue;
                return (HwElementsCacheBuilder)c;
            }
        }
        return null;
    }

    private String encodeName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            result = name;
        }
        return result;
    }

    private boolean isElementDefinedInFile(String elementName, HwElementsCacheEnum elementsType, File inputFile) {
        Object object;
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Map<String, Object> map = cacheMap.get(inputFile);
        return map != null && (object = map.get(elementsType.name())) instanceof List && ((List)object).contains(elementName);
    }
}

