/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ModelVersion {
    _070("0.7.0"),
    _071("0.7.1"),
    _072("0.7.2"),
    _080("0.8.0"),
    _081("0.8.1"),
    _082("0.8.2"),
    _083("0.8.3"),
    _090("0.9.0"),
    _091("0.9.1"),
    _092("0.9.2"),
    _093("0.9.3"),
    _094("0.9.4"),
    _095("0.9.5"),
    _096("0.9.6"),
    _097("0.9.7"),
    _098("0.9.8"),
    _099("0.9.9"),
    _100("1.0.0"),
    _110("1.1.0"),
    _120("1.2.0"),
    _200("2.0.0");

    private final String value;

    private ModelVersion(String v) {
        this.value = v;
    }

    public String getVersion() {
        return this.value;
    }

    public static ModelVersion getModelVersion(String version) {
        return Arrays.stream(ModelVersion.values()).filter(v -> v.value.equals(version)).findFirst().orElse(null);
    }

    public static ModelVersion[] getVersionsBefore(ModelVersion version, boolean include) {
        ArrayList<ModelVersion> versions = new ArrayList<ModelVersion>();
        ModelVersion[] allVersions = ModelVersion.values();
        int i = 0;
        while (i < (include ? version.ordinal() + 1 : version.ordinal())) {
            versions.add(allVersions[i]);
            ++i;
        }
        return versions.toArray(new ModelVersion[0]);
    }

    public static List<String> getAllSupportedVersions() {
        ArrayList<String> allSupportedVersions = new ArrayList<String>();
        ModelVersion[] allVersions = ModelVersion.values();
        int i = 0;
        while (i < allVersions.length) {
            allSupportedVersions.add(allVersions[i].value);
            ++i;
        }
        return allSupportedVersions;
    }

    public static boolean isValidVersion(String version) {
        if (version != null) {
            return ModelVersion.getAllSupportedVersions().contains(version);
        }
        return false;
    }

    public static String getLatestVersion() {
        ModelVersion[] values = ModelVersion.values();
        return values[values.length - 1].value;
    }
}

