/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheEnum;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.7.0"})
public class SectionRunnableLabelCacheBuilder
implements ICache {
    @Reference
    SessionLogger logger;
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        if (this.logger != null) {
            this.logger.info("Build up SectionRunnableLabelCache for 0.7.0", new Object[0]);
        }
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            File targetFile = entry.getKey();
            Document document1 = entry.getValue();
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            Map<String, Object> fileCache = this.map.get(targetFile);
            if (fileCache == null) {
                fileCache = new HashMap<String, Object>();
                this.map.put(targetFile, fileCache);
            }
            HashMap<String, List<String>> labelToSectionsMap = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.LABEL_SECTIONS.name(), labelToSectionsMap);
            HashMap<String, List<String>> runnableToSectionsMap = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.RUNNABLE_SECTIONS.name(), runnableToSectionsMap);
            ArrayList<String> sectionNames = new ArrayList<String>();
            fileCache.put(SectionRunnableLabelCacheEnum.SECTION_NAMES.name(), sectionNames);
            HashMap<String, List<String>> labelUUIDToSectionsMap = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.LABEL_UUID_SECTIONS.name(), labelUUIDToSectionsMap);
            HashMap<String, List<String>> runnableUUIDToSectionsMap = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.RUNNABLE_UUID_SECTIONS.name(), runnableUUIDToSectionsMap);
            List sectionElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/sections", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_070, (String)"am")});
            for (Element sectionElement : sectionElements) {
                Attribute runEntitiesAttribute;
                String sectionName = sectionElement.getAttributeValue("name");
                sectionNames.add(sectionName);
                Attribute labelsAttribute = sectionElement.getAttribute("labels");
                if (labelsAttribute != null) {
                    this.extractMemoryElementSectionInfo(labelToSectionsMap, sectionName, labelsAttribute, labelUUIDToSectionsMap);
                }
                if ((runEntitiesAttribute = sectionElement.getAttribute("runEntities")) != null) {
                    this.extractMemoryElementSectionInfo(runnableToSectionsMap, sectionName, runEntitiesAttribute, runnableUUIDToSectionsMap);
                }
                List labelElements = sectionElement.getChildren("labels");
                for (Element element : labelElements) {
                    this.extractMemoryElementSectionInfo(labelToSectionsMap, sectionName, element, labelUUIDToSectionsMap);
                }
                List runnableElements = sectionElement.getChildren("runEntities");
                for (Element element : runnableElements) {
                    this.extractMemoryElementSectionInfo(runnableToSectionsMap, sectionName, element, runnableUUIDToSectionsMap);
                }
            }
        }
    }

    private void extractMemoryElementSectionInfo(Map<String, List<String>> memoryElementToSectionsMap, String sectionName, Attribute memoryElementAttribute, Map<String, List<String>> memMElementUUIDtoSectionsMap) {
        String memoryElementAttributeValue = memoryElementAttribute.getValue();
        StringTokenizer stk = new StringTokenizer(memoryElementAttributeValue);
        while (stk.hasMoreTokens()) {
            String memoryElementReferenceString = stk.nextToken();
            int lastIndexOf = memoryElementReferenceString.lastIndexOf(63);
            if (lastIndexOf != -1) {
                String memoryElementName = memoryElementReferenceString.substring(0, lastIndexOf);
                this.addEntry(memoryElementToSectionsMap, memoryElementName, sectionName);
                continue;
            }
            memMElementUUIDtoSectionsMap.computeIfAbsent(memoryElementReferenceString, k -> new ArrayList()).add(sectionName);
        }
    }

    private void extractMemoryElementSectionInfo(Map<String, List<String>> memoryElementToSectionsMap, String sectionName, Element memoryElement, Map<String, List<String>> memElementUUIDtoSectionsMap) {
        String memoryElementAttributeValue = memoryElement.getAttributeValue("href");
        if (memoryElementAttributeValue != null) {
            int indexOfHash = memoryElementAttributeValue.lastIndexOf(35);
            int indexOfQuestionmark = memoryElementAttributeValue.lastIndexOf(63);
            if (indexOfHash != -1 && indexOfQuestionmark != -1) {
                String memroyElementName = memoryElementAttributeValue.substring(indexOfHash + 1, indexOfQuestionmark);
                this.addEntry(memoryElementToSectionsMap, memroyElementName, sectionName);
            } else if (indexOfHash != -1) {
                String memoryElementID = memoryElementAttributeValue.substring(indexOfHash + 1);
                memElementUUIDtoSectionsMap.computeIfAbsent(memoryElementID, k -> new ArrayList()).add(sectionName);
            }
        }
    }

    private void addEntry(Map<String, List<String>> memoryElementToSectionsMap, String memoryElementName, String sectionName) {
        memoryElementToSectionsMap.computeIfAbsent(memoryElementName, k -> new ArrayList()).add(sectionName);
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

