/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.handler;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Named;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.DBConnection;
import org.eclipse.app4mc.atdb._import.btf.ImportTransformation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.FrameworkUtil;

public class CalculateATDBMetrics {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, IWorkbenchWindow runnableContext) {
        List selectionList = selection.toList();
        final IFile atdbSource = selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("atdb")).findFirst().orElseThrow(() -> new IllegalArgumentException("Selection does not contain an *.atdb file!"));
        if (atdbSource.getLocation() == null || atdbSource.getLocation().toString().length() == 0) {
            return;
        }
        final String atdbFile = atdbSource.getLocation().toString();
        if (runnableContext == null) {
            return;
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
                try {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (ATDBConnection con = new ATDBConnection(atdbFile, DBConnection.AccessMode.ReadWriteInMemory);){
                            if (con.tableExists("traceEvent")) {
                                ImportTransformation.calculateMetrics(progressMonitor, con);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    progressMonitor.done();
                }
                atdbSource.refreshLocal(1, progressMonitor);
            }
        };
        try {
            runnableContext.run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e1) {
            Platform.getLog(CalculateATDBMetrics.class).log((IStatus)new Status(4, FrameworkUtil.getBundle(CalculateATDBMetrics.class).getSymbolicName(), e1.getLocalizedMessage(), (Throwable)e1));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

