/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.Component;
import org.eclipse.app4mc.amalthea.model.ComponentInstance;
import org.eclipse.app4mc.amalthea.model.ComponentPort;
import org.eclipse.app4mc.amalthea.model.Composite;
import org.eclipse.app4mc.amalthea.model.DataDependency;
import org.eclipse.app4mc.amalthea.model.DirectionType;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.IExecutable;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ISystem;
import org.eclipse.app4mc.amalthea.model.InterfaceKind;
import org.eclipse.app4mc.amalthea.model.LocalModeLabel;
import org.eclipse.app4mc.amalthea.model.LocalModeLabelRef;
import org.eclipse.app4mc.amalthea.model.LocalModeValue;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeLiteralConst;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.NumericMode;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.QualifiedPort;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

public class CustomPropertyDescriptorService {
    private CustomPropertyDescriptorService() {
        throw new IllegalStateException("Utility class");
    }

    public static Collection<String> getNeedEntryValuesForKey(Object object) {
        UniqueEList choiceOfValues = new UniqueEList();
        EClass type = AmaltheaPackage.eINSTANCE.getHwFeatureCategory();
        Collection objects = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)((EObject)object), (EClassifier)type);
        choiceOfValues.add(null);
        objects.stream().map(obj -> ((HwFeatureCategory)obj).getName()).filter(Objects::nonNull).sorted().forEachOrdered(arg_0 -> ((UniqueEList)choiceOfValues).add(arg_0));
        return choiceOfValues;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<RunnableParameter> getCallArgumentValuesForParameter(Object object) {
        Object object2 = object;
        if (object2 instanceof CallArgument) {
            EList parameters;
            void callArg;
            CallArgument callArgument = (CallArgument)object2;
            CallArgument cfr_ignored_0 = (CallArgument)object2;
            RunnableCall call = callArg.getContainingCall();
            if (call != null && call.getRunnable() != null && !(parameters = call.getRunnable().getParameters()).isEmpty()) {
                UniqueEList choiceOfValues = new UniqueEList();
                choiceOfValues.add(null);
                choiceOfValues.addAll((Collection)parameters);
                return choiceOfValues;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<RunnableParameter> getDataDependencyValuesForParameters(Object object) {
        Object object2 = object;
        if (object2 instanceof DataDependency) {
            void dataDep;
            DataDependency dataDependency = (DataDependency)object2;
            DataDependency cfr_ignored_0 = (DataDependency)object2;
            Runnable runnable = dataDep.getContainingRunnable();
            if (runnable != null) {
                BasicEList choiceOfValues = new BasicEList();
                runnable.getParameters().stream().filter(e -> e.getDirection() == DirectionType.IN || e.getDirection() == DirectionType.INOUT).forEachOrdered(((List)choiceOfValues)::add);
                return choiceOfValues;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<CallArgument> getDataDependencyValuesForCallArguments(Object object) {
        Object object2 = object;
        if (object2 instanceof DataDependency) {
            void dependency;
            DataDependency dataDependency = (DataDependency)object2;
            DataDependency cfr_ignored_0 = (DataDependency)object2;
            ActivityGraph graph = null;
            Runnable runnable = dependency.getContainingRunnable();
            if (runnable != null && runnable.getActivityGraph() != null) {
                graph = runnable.getActivityGraph();
            } else {
                Process process = (Process)AmaltheaServices.getContainerOfType((EObject)dependency, Process.class);
                if (process != null && process.getActivityGraph() != null) {
                    graph = process.getActivityGraph();
                }
            }
            if (graph != null) {
                List<DirectionType> dirList = List.of(DirectionType.OUT, DirectionType.INOUT);
                return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)graph, null, RunnableCall.class).stream().map(RunnableCall::getArguments).flatMap(Collection::stream).filter(arg -> arg.getParameter() != null).filter(arg -> dirList.contains(arg.getParameter().getDirection())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<String> collectModeValueStrings(Mode mode) {
        if (mode instanceof NumericMode) {
            return null;
        }
        Mode mode2 = mode;
        if (mode2 instanceof EnumMode) {
            void enumMode;
            EnumMode enumMode2 = (EnumMode)mode2;
            EnumMode cfr_ignored_0 = (EnumMode)mode2;
            return enumMode.getLiterals().stream().map(INamed::getName).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> getValuesForModeValue(Object object) {
        Object object2 = object;
        if (object2 instanceof ModeValue) {
            void modeValue;
            ModeValue modeValue2 = (ModeValue)object2;
            ModeValue cfr_ignored_0 = (ModeValue)object2;
            ModeLabel label = modeValue.getLabel();
            if (label != null) {
                return CustomPropertyDescriptorService.collectModeValueStrings(label.getMode());
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> getInitialValuesForModeLabel(Object object) {
        Object object2 = object;
        if (object2 instanceof ModeLabel) {
            void modeLabel;
            ModeLabel modeLabel2 = (ModeLabel)object2;
            ModeLabel cfr_ignored_0 = (ModeLabel)object2;
            return CustomPropertyDescriptorService.collectModeValueStrings(modeLabel.getMode());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> getValuesForModeLabelAccess(Object object) {
        Object object2 = object;
        if (object2 instanceof ModeLabelAccess) {
            void modeLabelAccess;
            ModeLabelAccess modeLabelAccess2 = (ModeLabelAccess)object2;
            ModeLabelAccess cfr_ignored_0 = (ModeLabelAccess)object2;
            ModeLabel label = modeLabelAccess.getData();
            if (label != null) {
                return CustomPropertyDescriptorService.collectModeValueStrings(label.getMode());
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> getDefaultValuesForLocalModeLabel(Object object) {
        Object object2 = object;
        if (object2 instanceof LocalModeLabel) {
            void localModeLabel;
            LocalModeLabel localModeLabel2 = (LocalModeLabel)object2;
            LocalModeLabel cfr_ignored_0 = (LocalModeLabel)object2;
            return CustomPropertyDescriptorService.collectModeValueStrings(localModeLabel.getMode());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<ModeLiteral> getValuesForModeLiteralConst(Object object) {
        Object object2 = object;
        if (object2 instanceof ModeLiteralConst) {
            Mode mode;
            Mode mode2;
            void modeLiteralConst;
            ModeLiteralConst modeLiteralConst2 = (ModeLiteralConst)object2;
            ModeLiteralConst cfr_ignored_0 = (ModeLiteralConst)object2;
            LocalModeValue container = (LocalModeValue)AmaltheaServices.getContainerOfType((EObject)modeLiteralConst, LocalModeValue.class);
            if (container != null && container.getLabel() != null && (mode2 = (mode = container.getLabel().getMode())) instanceof EnumMode) {
                void enumMode;
                EnumMode enumMode2 = (EnumMode)mode2;
                EnumMode cfr_ignored_1 = (EnumMode)mode2;
                return enumMode.getLiterals().stream().filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Collection<LocalModeLabel> getLocalLabelsOfExecutable(IExecutable executable) {
        if (executable != null) {
            BasicEList choices = new BasicEList();
            choices.addAll(executable.getLocalLabels());
            return choices;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<LocalModeLabel> getLabelsForLocalModeValue(Object object) {
        Object object2 = object;
        if (object2 instanceof LocalModeValue) {
            void localModeValue;
            LocalModeValue localModeValue2 = (LocalModeValue)object2;
            LocalModeValue cfr_ignored_0 = (LocalModeValue)object2;
            EObject eObject = localModeValue.eContainer();
            if (eObject instanceof RunnableCall) {
                void runnableCall;
                RunnableCall runnableCall2 = (RunnableCall)eObject;
                RunnableCall cfr_ignored_1 = (RunnableCall)eObject;
                return CustomPropertyDescriptorService.getLocalLabelsOfExecutable((IExecutable)runnableCall.getRunnable());
            }
            IExecutable executable = (IExecutable)AmaltheaServices.getContainerOfType((EObject)localModeValue, IExecutable.class);
            return CustomPropertyDescriptorService.getLocalLabelsOfExecutable(executable);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<LocalModeLabel> getValuesForLocalModeLabelRef(Object object) {
        Object object2 = object;
        if (object2 instanceof LocalModeLabelRef) {
            void localModeLabelRef;
            LocalModeLabelRef localModeLabelRef2 = (LocalModeLabelRef)object2;
            LocalModeLabelRef cfr_ignored_0 = (LocalModeLabelRef)object2;
            IExecutable executable = (IExecutable)AmaltheaServices.getContainerOfType((EObject)localModeLabelRef, IExecutable.class);
            return CustomPropertyDescriptorService.getLocalLabelsOfExecutable(executable);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<HwPathElement> filterValuesForPathElements(Object object, Collection<?> choices) {
        Object object2 = object;
        if (object2 instanceof HwAccessPath) {
            void accessPath;
            HwAccessPath hwAccessPath = (HwAccessPath)object2;
            HwAccessPath cfr_ignored_0 = (HwAccessPath)object2;
            HwAccessElement accessElement = accessPath.getContainingAccessElement();
            if (accessElement != null) {
                ProcessingUnit source = accessElement.getSource();
                return choices.stream().filter(HwPathElement.class::isInstance).map(HwPathElement.class::cast).filter(e -> e != source).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Component getComponent(QualifiedPort qualPort) {
        if (qualPort.getInstance() == null) {
            return (Component)AmaltheaServices.getContainerOfType((EObject)qualPort, Composite.class);
        }
        return qualPort.getInstance().getType();
    }

    public static Collection<ComponentInstance> getValuesForComponentInstance(Object object) {
        ISystem container;
        if (object instanceof QualifiedPort && (container = (ISystem)AmaltheaServices.getContainerOfType((EObject)((EObject)object), ISystem.class)) != null) {
            BasicEList choices = new BasicEList();
            choices.add(null);
            choices.addAll(container.getComponentInstances());
            return choices;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<ComponentPort> getValuesForComponentPort(Object object) {
        Object object2 = object;
        if (object2 instanceof QualifiedPort) {
            void qPort;
            QualifiedPort qualifiedPort = (QualifiedPort)object2;
            QualifiedPort cfr_ignored_0 = (QualifiedPort)object2;
            Component component = CustomPropertyDescriptorService.getComponent((QualifiedPort)qPort);
            if (component != null) {
                BasicEList choices = new BasicEList();
                choices.add(null);
                choices.addAll(CustomPropertyDescriptorService.filterPortList((List<ComponentPort>)component.getPorts(), (QualifiedPort)qPort));
                return choices;
            }
        }
        return Collections.emptyList();
    }

    private static List<ComponentPort> filterPortList(List<ComponentPort> ports, QualifiedPort qualPort) {
        boolean isInnerPort = qualPort.getInstance() != null;
        List<InterfaceKind> provideList = List.of(InterfaceKind.PROVIDES, InterfaceKind.PROVIDES_REQUIRES, InterfaceKind._UNDEFINED_);
        List<InterfaceKind> requireList = List.of(InterfaceKind.REQUIRES, InterfaceKind.PROVIDES_REQUIRES, InterfaceKind._UNDEFINED_);
        EStructuralFeature feature = qualPort.eContainingFeature();
        AmaltheaPackage amPackage = AmaltheaPackage.eINSTANCE;
        if (amPackage.getConnector_SourcePort().equals(feature)) {
            if (isInnerPort) {
                return ports.stream().filter(e -> provideList.contains(e.getKind())).collect(Collectors.toList());
            }
            return ports.stream().filter(e -> requireList.contains(e.getKind())).collect(Collectors.toList());
        }
        if (amPackage.getConnector_TargetPort().equals(feature)) {
            if (isInnerPort) {
                return ports.stream().filter(e -> requireList.contains(e.getKind())).collect(Collectors.toList());
            }
            return ports.stream().filter(e -> provideList.contains(e.getKind())).collect(Collectors.toList());
        }
        if (amPackage.getISystem_GroundedPorts().equals(feature)) {
            if (isInnerPort) {
                return ports;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

