/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters083.utils.PeriodicStimulusCacheBuilder;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.2", "output_model_version=0.8.3"}, service={IConverter.class})
public class StimuliConverter
extends AbstractConverter {
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String TYPE = "type";
    private static final String HREF = "href";
    private static final String ENTITY = "entity";
    private static final String EVENTS = "events";
    private static final String OFFSET = "offset";
    private static final String STIMULI = "stimuli";
    private static final String STIMULUS_DEVIATION = "stimulusDeviation";
    private static final String TASKS = "tasks";
    private static final String AM_PERIODIC_SYNTHETIC_STIMULUS = "am:PeriodicSyntheticStimulus";
    private static final String AM_RELATIVE_PERIODIC_STIMULUS = "am:RelativePeriodicStimulus";
    private static final String AM_VARIABLE_RATE_STIMULUS = "am:VariableRateStimulus";
    private static final String TYPE_PERIODIC_STIMULUS = "?type=PeriodicStimulus";
    private static final String TYPE_PERIODIC_SYNTHETIC_STIMULUS = "?type=PeriodicSyntheticStimulus";
    private static final String TYPE_RELATIVE_PERIODIC_STIMULUS = "?type=RelativePeriodicStimulus";
    private static final String TYPE_SPORADIC_STIMULUS = "?type=SporadicStimulus";
    private static final String TYPE_SYNTHETIC_STIMULUS = "?type=SyntheticStimulus";
    private static final String TYPE_VARIABLE_RATE_STIMULUS = "?type=VariableRateStimulus";
    @Reference
    SessionLogger logger;
    private PeriodicStimulusCacheBuilder cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from 0.8.2 to 0.8.3 : Executing Stimulus model converter for model file : {0}", new Object[]{targetFile.getName()});
        this.cache = this.getPeriodicStimulusCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("PeriodicStimulusCacheBuilder is not built and Object of it is not available in Converters");
        }
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateVariableRateStimulus(rootElement);
        this.migrateSyntheticStimulus(rootElement);
        this.migrateSporadicStimulus(rootElement);
        this.migrateArrivalCurveStimulus(rootElement);
        this.migrateSingleStimulus(rootElement);
        this.migrateRemainingStimulusTypes(rootElement);
        this.migratePeriodicStimulus(rootElement);
        this.migrateStimulusReferences(rootElement);
    }

    private PeriodicStimulusCacheBuilder getPeriodicStimulusCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof PeriodicStimulusCacheBuilder)) continue;
                return (PeriodicStimulusCacheBuilder)c;
            }
        }
        return null;
    }

    private void migrateStimulusReferences(Element rootElement) {
        StringBuilder xpathBufferForReferences = new StringBuilder();
        xpathBufferForReferences.append("./swModel/isrs");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./swModel/tasks");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./eventModel/events");
        List stimulusReferenceContainers = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForReferences.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element stimulusReferenceContainer : stimulusReferenceContainers) {
            this.migrateReferencesOfPeriodicStimulus(stimulusReferenceContainer);
            this.migrateReferencesOfSporadicStimulus(stimulusReferenceContainer);
            this.migrateReferencesOfSyntheticStimulus(stimulusReferenceContainer);
        }
    }

    private void migratePeriodicStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:PeriodicStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element stimulusElement : stimulusElements) {
            Element clockElement = stimulusElement.getChild("clock");
            Attribute clockAttribute = stimulusElement.getAttribute("clock");
            if (clockElement == null && clockAttribute == null) {
                Element stimulusDeviationElement = stimulusElement.getChild(STIMULUS_DEVIATION);
                if (stimulusDeviationElement == null) continue;
                stimulusDeviationElement.setName("jitter");
                continue;
            }
            Attribute typeAttribute = stimulusElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            typeAttribute.setValue(AM_VARIABLE_RATE_STIMULUS);
            Element recurrenceElement = stimulusElement.getChild("recurrence");
            Element offsetElement = stimulusElement.getChild(OFFSET);
            Element scenarioElement = new Element("scenario");
            if (recurrenceElement != null) {
                recurrenceElement.detach();
                scenarioElement.addContent((Content)recurrenceElement);
            }
            if (clockElement != null) {
                clockElement.detach();
                scenarioElement.addContent((Content)clockElement);
            } else if (clockAttribute != null) {
                clockAttribute.detach();
                scenarioElement.setAttribute(clockAttribute);
            }
            stimulusElement.addContent((Content)scenarioElement);
            if (offsetElement != null) {
                Element customPropertiesElement = new Element("customProperties");
                customPropertiesElement.setAttribute("key", OFFSET);
                offsetElement.detach();
                offsetElement.setName("value");
                offsetElement.setAttribute(TYPE, "am:TimeObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                customPropertiesElement.addContent((Content)offsetElement);
                scenarioElement.addContent((Content)customPropertiesElement);
            }
            stimulusElement.removeChild(OFFSET);
            stimulusElement.removeChild(STIMULUS_DEVIATION);
        }
    }

    private boolean canPeriodicStimulusTypeBeChangedForHref(String href) {
        int start = href.indexOf(35);
        int end = href.lastIndexOf(63);
        if (start != -1 && end != -1) {
            String elementName = href.substring(start + 1, end);
            return this.isPeriodicStimulusPresentInCache(elementName);
        }
        return false;
    }

    private boolean isPeriodicStimulusPresentInCache(String elementName) {
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        if (cacheMap != null) {
            Set<File> keySet = cacheMap.keySet();
            for (File file : keySet) {
                List periodicStimulusWithClock;
                Object object;
                Map<String, Object> map = cacheMap.get(file);
                if (map == null || (object = map.get("PeriodicStimulus_Containing_Clock")) == null || !(periodicStimulusWithClock = (List)object).contains(elementName)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkAndUpdatePeriodicStimulusReference(String reference) {
        String elementName;
        boolean result;
        int index = reference.lastIndexOf(63);
        if (index != -1 && (result = this.isPeriodicStimulusPresentInCache(elementName = reference.substring(0, index)))) {
            return reference.replace(TYPE_PERIODIC_STIMULUS, TYPE_VARIABLE_RATE_STIMULUS);
        }
        return reference;
    }

    private void migrateRemainingStimulusTypes(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:CustomStimulus\" or @xsi:type=\"am:InterProcessStimulus\" or @xsi:type=\"am:EventStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild(STIMULUS_DEVIATION);
        }
    }

    private void migrateSingleStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SingleStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild(STIMULUS_DEVIATION);
            Element activationElement = stimulusElement.getChild("activation");
            if (activationElement == null) continue;
            activationElement.setName("occurrence");
        }
    }

    private void migrateArrivalCurveStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:ArrivalCurveStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild(STIMULUS_DEVIATION);
            List entriesElements = stimulusElement.getChildren("entries");
            for (Element entriesElement : entriesElements) {
                Attribute attribute = entriesElement.getAttribute("numberOfEvents");
                if (attribute == null) continue;
                attribute.setName("numberOfOccurrences");
            }
        }
    }

    private void migrateSporadicStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SporadicStimulus\"]");
        List sporadicStimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element sporadicStimulusElement : sporadicStimulusElements) {
            Attribute typeAttribute = sporadicStimulusElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            typeAttribute.setValue(AM_RELATIVE_PERIODIC_STIMULUS);
            sporadicStimulusElement.removeAttribute("description");
            Element stimulusDeviationElement = sporadicStimulusElement.getChild(STIMULUS_DEVIATION);
            if (stimulusDeviationElement == null) continue;
            stimulusDeviationElement.setName("nextOccurrence");
        }
    }

    private void migrateVariableRateStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild(STIMULUS_DEVIATION);
        }
    }

    private void migrateSyntheticStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SyntheticStimulus\"]");
        List syntheticStimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
        for (Element syntheticStimulusElement : syntheticStimulusElements) {
            Element triggerTimesElement;
            Attribute typeAttribute = syntheticStimulusElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            typeAttribute.setValue(AM_PERIODIC_SYNTHETIC_STIMULUS);
            syntheticStimulusElement.removeChild(STIMULUS_DEVIATION);
            Element periodElement = syntheticStimulusElement.getChild("period");
            if (periodElement != null) {
                periodElement.setName("recurrence");
            }
            if ((triggerTimesElement = syntheticStimulusElement.getChild("triggerTimes")) == null) continue;
            List timeStampsElements = HelperUtil.getXpathResult((Element)triggerTimesElement, (String)".//timestamps", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_083, (String)AM)});
            for (Element timeStampsElement : timeStampsElements) {
                timeStampsElement.setName("occurrenceTimes");
                timeStampsElement.detach();
                syntheticStimulusElement.addContent((Content)timeStampsElement);
            }
            syntheticStimulusElement.removeContent((Content)triggerTimesElement);
        }
    }

    private void migrateReferencesOfSporadicStimulus(Element stimulusReferenceContainer) {
        String containerTagName = stimulusReferenceContainer.getName();
        if ("isrs".equals(containerTagName) || TASKS.equals(containerTagName)) {
            List stimuliElements = stimulusReferenceContainer.getChildren(STIMULI);
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute(STIMULI);
            for (Element stimuliElement : stimuliElements) {
                Attribute hrefAttribute;
                if (stimuliElement == null) continue;
                Attribute typeAttribute = stimuliElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (typeAttribute != null && "am:SporadicStimulus".equals(typeAttribute.getValue())) {
                    typeAttribute.setValue(AM_RELATIVE_PERIODIC_STIMULUS);
                }
                if ((hrefAttribute = stimuliElement.getAttribute(HREF)) == null) continue;
                String value = hrefAttribute.getValue();
                value = value.replace(TYPE_SPORADIC_STIMULUS, TYPE_RELATIVE_PERIODIC_STIMULUS);
                hrefAttribute.setValue(value);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace(TYPE_SPORADIC_STIMULUS, TYPE_RELATIVE_PERIODIC_STIMULUS);
                stimuliAttribute.setValue(value);
            }
        } else if (EVENTS.equals(containerTagName)) {
            Element stimuliElement = stimulusReferenceContainer.getChild(ENTITY);
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute(ENTITY);
            if (stimuliElement != null) {
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (typeAttribute != null && "am:SporadicStimulus".equals(typeAttribute.getValue())) {
                    typeAttribute.setValue(AM_RELATIVE_PERIODIC_STIMULUS);
                }
                if ((hrefAttribute = stimuliElement.getAttribute(HREF)) != null) {
                    String value = hrefAttribute.getValue();
                    value = value.replace(TYPE_SPORADIC_STIMULUS, TYPE_RELATIVE_PERIODIC_STIMULUS);
                    hrefAttribute.setValue(value);
                }
            } else if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace(TYPE_SPORADIC_STIMULUS, TYPE_RELATIVE_PERIODIC_STIMULUS);
                stimuliAttribute.setValue(value);
            }
        }
    }

    private void migrateReferencesOfSyntheticStimulus(Element syntheticStimulusReferenceContainer) {
        String containerTagName = syntheticStimulusReferenceContainer.getName();
        if ("isrs".equals(containerTagName) || TASKS.equals(containerTagName)) {
            List stimuliElements = syntheticStimulusReferenceContainer.getChildren(STIMULI);
            Attribute stimuliAttribute = syntheticStimulusReferenceContainer.getAttribute(STIMULI);
            for (Element stimuliElement : stimuliElements) {
                Attribute hrefAttribute;
                if (stimuliElement == null) continue;
                Attribute typeAttribute = stimuliElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (typeAttribute != null && "am:SyntheticStimulus".equals(typeAttribute.getValue())) {
                    typeAttribute.setValue(AM_PERIODIC_SYNTHETIC_STIMULUS);
                }
                if ((hrefAttribute = stimuliElement.getAttribute(HREF)) == null) continue;
                String value = hrefAttribute.getValue();
                value = value.replace(TYPE_SYNTHETIC_STIMULUS, TYPE_PERIODIC_SYNTHETIC_STIMULUS);
                hrefAttribute.setValue(value);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace(TYPE_SYNTHETIC_STIMULUS, TYPE_PERIODIC_SYNTHETIC_STIMULUS);
                stimuliAttribute.setValue(value);
            }
        } else if (EVENTS.equals(containerTagName)) {
            Element stimuliElement = syntheticStimulusReferenceContainer.getChild(ENTITY);
            Attribute stimuliAttribute = syntheticStimulusReferenceContainer.getAttribute(ENTITY);
            if (stimuliElement != null) {
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (typeAttribute != null && "am:SyntheticStimulus".equals(typeAttribute.getValue())) {
                    typeAttribute.setValue(AM_PERIODIC_SYNTHETIC_STIMULUS);
                }
                if ((hrefAttribute = stimuliElement.getAttribute(HREF)) != null) {
                    String value = hrefAttribute.getValue();
                    value = value.replace(TYPE_SYNTHETIC_STIMULUS, TYPE_PERIODIC_SYNTHETIC_STIMULUS);
                    hrefAttribute.setValue(value);
                }
            } else if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace(TYPE_SYNTHETIC_STIMULUS, TYPE_PERIODIC_SYNTHETIC_STIMULUS);
                stimuliAttribute.setValue(value);
            }
        }
    }

    private void migrateReferencesOfPeriodicStimulus(Element stimulusReferenceContainer) {
        String containerTagName = stimulusReferenceContainer.getName();
        if ("isrs".equals(containerTagName) || TASKS.equals(containerTagName)) {
            List stimuliElements = stimulusReferenceContainer.getChildren(STIMULI);
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute(STIMULI);
            for (Element stimuliElement : stimuliElements) {
                String hrefValue;
                Attribute hrefAttribute;
                Attribute typeAttribute;
                if (stimuliElement == null || (typeAttribute = stimuliElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI))) == null || !"am:PeriodicStimulus".equals(typeAttribute.getValue()) || (hrefAttribute = stimuliElement.getAttribute(HREF)) == null || !this.canPeriodicStimulusTypeBeChangedForHref(hrefValue = hrefAttribute.getValue())) continue;
                typeAttribute.setValue(AM_VARIABLE_RATE_STIMULUS);
                hrefValue = hrefValue.replace(TYPE_PERIODIC_STIMULUS, TYPE_VARIABLE_RATE_STIMULUS);
                hrefAttribute.setValue(hrefValue);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                String[] split = value.split("\\s+");
                StringBuilder updatedRefsBuffer = new StringBuilder();
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String reference = stringArray[n2];
                    if (reference.contains(TYPE_PERIODIC_STIMULUS)) {
                        updatedRefsBuffer.append(String.valueOf(this.checkAndUpdatePeriodicStimulusReference(reference)) + " ");
                    } else {
                        updatedRefsBuffer.append(String.valueOf(reference) + " ");
                    }
                    ++n2;
                }
                value = updatedRefsBuffer.toString().trim();
                stimuliAttribute.setValue(value);
            }
        } else if (EVENTS.equals(containerTagName)) {
            Element stimuliElement = stimulusReferenceContainer.getChild(ENTITY);
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute(ENTITY);
            if (stimuliElement != null) {
                String hrefValue;
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                if (typeAttribute != null && "am:PeriodicStimulus".equals(typeAttribute.getValue()) && (hrefAttribute = stimuliElement.getAttribute(HREF)) != null && this.canPeriodicStimulusTypeBeChangedForHref(hrefValue = hrefAttribute.getValue())) {
                    typeAttribute.setValue(AM_VARIABLE_RATE_STIMULUS);
                    hrefValue = hrefValue.replace(TYPE_PERIODIC_STIMULUS, TYPE_VARIABLE_RATE_STIMULUS);
                    hrefAttribute.setValue(hrefValue);
                }
            } else if (stimuliAttribute != null) {
                String reference = stimuliAttribute.getValue();
                if (reference.contains(TYPE_PERIODIC_STIMULUS)) {
                    reference = this.checkAndUpdatePeriodicStimulusReference(reference);
                }
                stimuliAttribute.setValue(reference);
            }
        }
    }
}

