/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.buildship.core.internal.configuration.BaseRunConfiguration;
import org.eclipse.buildship.core.internal.configuration.TestRunConfiguration;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.launch.BaseLaunchRequestJob;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class RunGradleTestLaunchRequestJob
extends BaseLaunchRequestJob<TestLauncher> {
    private final ImmutableList<TestOperationDescriptor> testDescriptors;
    private final TestRunConfiguration runConfiguration;

    public RunGradleTestLaunchRequestJob(List<TestOperationDescriptor> testDescriptors, TestRunConfiguration runConfig) {
        super("Launching Gradle tests");
        this.testDescriptors = ImmutableList.copyOf(testDescriptors);
        this.runConfiguration = (TestRunConfiguration)Preconditions.checkNotNull((Object)runConfig);
    }

    @Override
    protected String getJobTaskName() {
        return "Launch Gradle tests";
    }

    @Override
    protected BaseRunConfiguration getRunConfig() {
        return this.runConfiguration;
    }

    @Override
    protected ProcessDescription createProcessDescription() {
        String processName = this.createProcessName(this.runConfiguration.getProjectConfiguration().getProjectDir());
        return new TestLaunchProcessDescription(processName);
    }

    private String createProcessName(File workingDir) {
        return String.format("%s [Gradle Project] %s in %s (%s)", this.collectTestTaskNames((List<TestOperationDescriptor>)this.testDescriptors), Joiner.on((char)' ').join(RunGradleTestLaunchRequestJob.collectSimpleDisplayNames(this.testDescriptors)), workingDir.getAbsolutePath(), DateFormat.getDateTimeInstance(2, 2).format(new Date()));
    }

    private String collectTestTaskNames(List<TestOperationDescriptor> testDescriptors) {
        ImmutableList.Builder testTaskNames = ImmutableList.builder();
        for (TestOperationDescriptor testDescriptor : testDescriptors) {
            Optional<TaskOperationDescriptor> taskDescriptor = this.findParentTestTask((OperationDescriptor)testDescriptor);
            testTaskNames.add((Object)(taskDescriptor.isPresent() ? ((TaskOperationDescriptor)taskDescriptor.get()).getTaskPath() : "Test"));
        }
        return Joiner.on((char)' ').join((Iterable)ImmutableSet.copyOf((Collection)testTaskNames.build()));
    }

    private Optional<TaskOperationDescriptor> findParentTestTask(OperationDescriptor testDescriptor) {
        OperationDescriptor parent = testDescriptor.getParent();
        if (parent instanceof TaskOperationDescriptor) {
            return Optional.of((Object)((TaskOperationDescriptor)parent));
        }
        if (parent != null) {
            return this.findParentTestTask(parent);
        }
        return Optional.absent();
    }

    @Override
    protected TestLauncher createLaunch(InternalGradleBuild gradleBuild, GradleProgressAttributes progressAttributes, ProcessDescription processDescription) {
        TestLauncher launcher = gradleBuild.newTestLauncher(this.runConfiguration, progressAttributes);
        launcher.withTests(this.testDescriptors);
        return launcher;
    }

    @Override
    protected void executeLaunch(TestLauncher launcher) {
        launcher.run();
    }

    @Override
    protected void writeExtraConfigInfo(GradleProgressAttributes progressAttributes) {
        progressAttributes.writeConfig(String.format("%s: %s", CoreMessages.RunConfiguration_Label_Tests, Joiner.on((char)' ').join(RunGradleTestLaunchRequestJob.collectQualifiedDisplayNames(this.testDescriptors))));
    }

    private static List<String> collectQualifiedDisplayNames(List<TestOperationDescriptor> testDescriptors) {
        return FluentIterable.from(testDescriptors).transform((Function)new Function<TestOperationDescriptor, String>(){

            public String apply(TestOperationDescriptor descriptor) {
                if (descriptor instanceof JvmTestOperationDescriptor) {
                    JvmTestOperationDescriptor jvmTestDescriptor = (JvmTestOperationDescriptor)descriptor;
                    String className = jvmTestDescriptor.getClassName();
                    String methodName = jvmTestDescriptor.getMethodName();
                    return methodName != null ? className + "#" + methodName : className;
                }
                return descriptor.getDisplayName();
            }
        }).toList();
    }

    private static List<String> collectSimpleDisplayNames(List<TestOperationDescriptor> testDescriptors) {
        return FluentIterable.from(testDescriptors).transform((Function)new Function<TestOperationDescriptor, String>(){

            public String apply(TestOperationDescriptor descriptor) {
                if (descriptor instanceof JvmTestOperationDescriptor) {
                    JvmTestOperationDescriptor jvmTestDescriptor = (JvmTestOperationDescriptor)descriptor;
                    String className = jvmTestDescriptor.getClassName();
                    String methodName = jvmTestDescriptor.getMethodName();
                    int index = className.lastIndexOf(46);
                    if (index >= 0 && className.length() > index + 1) {
                        className = className.substring(index + 1);
                    }
                    return methodName != null ? className + "#" + methodName : className;
                }
                return descriptor.getDisplayName();
            }
        }).toList();
    }

    private final class TestLaunchProcessDescription
    extends BaseLaunchRequestJob.BaseProcessDescription {
        public TestLaunchProcessDescription(String processName) {
            super(processName, RunGradleTestLaunchRequestJob.this, RunGradleTestLaunchRequestJob.this.runConfiguration);
        }

        @Override
        public boolean isRerunnable() {
            return true;
        }

        @Override
        public void rerun() {
            RunGradleTestLaunchRequestJob job = new RunGradleTestLaunchRequestJob((List<TestOperationDescriptor>)RunGradleTestLaunchRequestJob.this.testDescriptors, RunGradleTestLaunchRequestJob.this.runConfiguration);
            job.schedule();
        }
    }
}

