/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.config;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DNode;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.sirius.analysis.ExtensibleElementExt;
import org.polarsys.capella.cybersecurity.test.config.CybersecurityConfigProject;
import org.polarsys.capella.cybersecurity.test.diagram.ThreatDiagram;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class SecurityNeedsConfigTest
extends CybersecurityConfigProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        Project project = SessionHelper.getCapellaProject((Session)session);
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        ThreatDiagram td = ThreatDiagram.createDiagram(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        DNode fpa = td.createFunctionalPrimaryAsset();
        DNode ipa = td.createInformationPrimaryAsset();
        this.test(fpa, project);
        this.test(ipa, project);
    }

    private void test(DNode asset, Project project) {
        CybersecurityConfiguration cyberConfig = CybersecurityQueries.getCybersecurityConfiguration((Project)project);
        SecurityNeedsConfigTest.assertNotNull((Object)cyberConfig);
        EnumerationPropertyType confidentialityType = CybersecurityQueries.getConfidentialityPropertyType((Project)project);
        CybersecurityServices service = new CybersecurityServices();
        PrimaryAsset paElement = (PrimaryAsset)asset.getTarget();
        SecurityNeeds sn = (SecurityNeeds)ExtensibleElementExt.getExtension((ExtensibleElement)paElement, SecurityNeeds.class);
        SecurityNeedsConfigTest.assertNull((Object)sn);
        sn = this.createSecurityNeeds(project, paElement);
        SecurityNeedsConfigTest.assertTrue((CybersecurityQueries.getConfidentialityIndex((SecurityNeeds)sn) == 0 ? 1 : 0) != 0);
        this.updateConfidentialityValue(sn, (EnumerationPropertyLiteral)confidentialityType.getOwnedLiterals().get(1), project);
        SecurityNeedsConfigTest.assertEquals((Object)sn.getConfidentialityValue(), (Object)confidentialityType.getOwnedLiterals().get(1));
        this.removeLiteralType(confidentialityType, project, 0);
        SecurityNeedsConfigTest.assertEquals((Object)sn.getConfidentialityValue(), (Object)confidentialityType.getOwnedLiterals().get(0));
        this.removeLiteralType(confidentialityType, project, 0);
        SecurityNeedsConfigTest.assertTrue((CybersecurityQueries.getConfidentialityIndex((SecurityNeeds)sn) == 0 ? 1 : 0) != 0);
    }
}

