/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.query.IQuery;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CybersecurityQueries {
    public static SecurityNeeds getSecurityNeeds(ExtensibleElement e) {
        for (ElementExtension ee : e.getOwnedExtensions()) {
            if (!(ee instanceof SecurityNeeds)) continue;
            return (SecurityNeeds)ee;
        }
        return null;
    }

    public static Stream<PrimaryAsset> getThreatenedPrimaryAssets(Threat threat) {
        return EObjectExt.getReferencers((EObject)threat, (EReference)CybersecurityPackage.Literals.THREAT_APPLICATION__THREAT).stream().map(s -> ((ThreatApplication)s).getAsset());
    }

    public static Stream<AbstractFunctionalBlock> getThreatenedComponents(Threat threat) {
        return CybersecurityQueries.getThreatenedPrimaryAssets(threat).flatMap(pa -> pa.getOwnedMembers().stream()).flatMap(pam -> {
            if (pam.getMember() instanceof AbstractFunction) {
                return ((AbstractFunction)pam.getMember()).getAllocationBlocks().stream();
            }
            return Stream.empty();
        });
    }

    public static Stream<Component> getInvolvedComponents(Threat threat) {
        return EObjectExt.getReferencers((EObject)threat, (EReference)CybersecurityPackage.Literals.THREAT_INVOLVEMENT__THREAT).stream().map(s -> ((ThreatInvolvement)s).getComponent());
    }

    public static Stream<Component> getInvolvedThreatSources(Threat threat) {
        return CybersecurityQueries.getInvolvedComponents(threat).filter(c -> CybersecurityQueries.isThreatSource(c));
    }

    public static Stream<Component> getInvolvedActors(Threat threat) {
        return CybersecurityQueries.getInvolvedComponents(threat).filter(c -> !CybersecurityQueries.isThreatSource(c));
    }

    public static Stream<Component> getInvolvedActors(PrimaryAsset asset) {
        return asset.getOwnedThreatApplications().stream().map(ThreatApplication::getThreat).filter(Objects::nonNull).flatMap(CybersecurityQueries::getInvolvedActors);
    }

    public static Stream<Component> getInvolvedThreatSources(PrimaryAsset asset) {
        return asset.getOwnedThreatApplications().stream().map(ThreatApplication::getThreat).filter(Objects::nonNull).flatMap(CybersecurityQueries::getInvolvedThreatSources);
    }

    public static boolean isThreatSource(Component c) {
        for (ElementExtension e : c.getOwnedExtensions()) {
            if (!(e instanceof TrustBoundaryStorage)) continue;
            return ((TrustBoundaryStorage)e).isThreatSource();
        }
        return false;
    }

    public static boolean isTrusted(Component c) {
        if (c != null) {
            for (ElementExtension e : c.getOwnedExtensions()) {
                if (!(e instanceof TrustBoundaryStorage)) continue;
                return ((TrustBoundaryStorage)e).isTrusted();
            }
        }
        return true;
    }

    public static boolean isTrustBoundary(FunctionalExchange fe) {
        AbstractFunction sf = (AbstractFunction)fe.getSourceFunctionOutputPort().eContainer();
        AbstractFunction tf = (AbstractFunction)fe.getTargetFunctionInputPort().eContainer();
        return CybersecurityQueries.isTrusted(sf) ^ CybersecurityQueries.isTrusted(tf);
    }

    public static boolean isTrustBoundary(ComponentExchange ce) {
        Component source = ComponentExchangeExt.getSourceComponent((ComponentExchange)ce);
        Component target = ComponentExchangeExt.getTargetComponent((ComponentExchange)ce);
        return CybersecurityQueries.isTrusted(source) ^ CybersecurityQueries.isTrusted(target);
    }

    public static Stream<Threat> getThreatsOf(PrimaryAsset pe) {
        return pe.getOwnedThreatApplications().stream().map(s -> s.getThreat()).distinct();
    }

    public static boolean isTrusted(AbstractFunction f) {
        for (AbstractFunctionalBlock b : f.getAllocationBlocks()) {
            TrustBoundaryStorage tbs = CybersecurityQueries.getTrustBoundaryStorage((ExtensibleElement)b);
            if (tbs == null) continue;
            return tbs.isTrusted();
        }
        return true;
    }

    public static boolean isTrusted(ExtensibleElement e) {
        TrustBoundaryStorage tbs = CybersecurityQueries.getTrustBoundaryStorage(e);
        if (tbs != null) {
            return tbs.isTrusted();
        }
        return true;
    }

    public static TrustBoundaryStorage getTrustBoundaryStorage(ExtensibleElement element) {
        if (element instanceof Part) {
            element = ((Part)element).getType();
        }
        if (element != null) {
            for (ElementExtension ext : element.getOwnedExtensions()) {
                if (!(ext instanceof TrustBoundaryStorage)) continue;
                return (TrustBoundaryStorage)ext;
            }
        }
        return null;
    }

    public static Stream<Threat> getInvolvingThreats(Component c) {
        return c.getOwnedExtensions().stream().filter(ThreatInvolvement.class::isInstance).map(x -> ((ThreatInvolvement)x).getThreat());
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(FunctionalPrimaryAsset fpa) {
        return fpa.getFunctions().stream().flatMap(af -> af.getAllocationBlocks().stream());
    }

    public static Stream<ExchangeItem> getExchangeItems(AbstractFunction function) {
        for (ExtensibleElement e : function.getOwnedExtensions()) {
            if (!(e instanceof FunctionStorage)) continue;
            return ((FunctionStorage)e).getExchangedItems().stream();
        }
        return Stream.empty();
    }

    public static Stream<FunctionalPrimaryAsset> getFunctionalPrimaryAssets(AbstractFunction af) {
        return EObjectExt.getReferencers((EObject)af, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(s -> (FunctionalPrimaryAsset)((PrimaryAssetMember)s).getAsset());
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(ExchangeItem ei) {
        return EObjectExt.getReferencers((EObject)ei, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(s -> (InformationPrimaryAsset)((PrimaryAssetMember)s).getAsset());
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(AbstractFunction af) {
        return CybersecurityQueries.getExchangeItems(af).flatMap(ei -> CybersecurityQueries.getInformationPrimaryAssets(ei)).distinct();
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(FunctionalExchange fe) {
        return fe.getExchangedItems().stream().flatMap(ei -> CybersecurityQueries.getInformationPrimaryAssets(ei));
    }

    public static Stream<AbstractFunctionalBlock> getTrustBoundaryBlocks(FunctionalExchange fe) {
        ArrayList result = new ArrayList();
        AbstractFunction sf = (AbstractFunction)fe.getSourceFunctionOutputPort().eContainer();
        AbstractFunction tf = (AbstractFunction)fe.getTargetFunctionInputPort().eContainer();
        if (CybersecurityQueries.isTrusted(sf)) {
            result.addAll(sf.getAllocationBlocks());
        }
        if (CybersecurityQueries.isTrusted(tf)) {
            result.addAll(tf.getAllocationBlocks());
        }
        return result.stream();
    }

    public static Stream<FunctionalPrimaryAsset> getFunctionalPrimaryAssets(Component c) {
        return c.getAllocatedFunctions().stream().flatMap(af -> CybersecurityQueries.getFunctionalPrimaryAssets(af)).distinct();
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(Component c) {
        return c.getAllocatedFunctions().stream().flatMap(af -> CybersecurityQueries.getExchangeItems(af)).flatMap(ei -> CybersecurityQueries.getInformationPrimaryAssets(ei)).distinct();
    }

    public static Stream<Threat> getThreateningThreats(Component c) {
        return Stream.concat(CybersecurityQueries.getFunctionalPrimaryAssets(c).flatMap(fpa -> CybersecurityQueries.getThreatsOf(fpa)), CybersecurityQueries.getInformationPrimaryAssets(c).flatMap(ipa -> CybersecurityQueries.getThreatsOf(ipa))).distinct();
    }

    public static int getMaxSecurityNeedsValue(SecurityNeeds sn) {
        return sn == null ? 0 : IntStream.of(sn.getConfidentiality(), sn.getIntegrity(), sn.getTraceability(), sn.getAvailability()).max().getAsInt();
    }

    public static int getConfidentiality(SecurityNeeds sn) {
        return sn == null ? 0 : sn.getConfidentiality();
    }

    public static int getIntegrity(SecurityNeeds sn) {
        return sn == null ? 0 : sn.getIntegrity();
    }

    public static int getAvailability(SecurityNeeds sn) {
        return sn == null ? 0 : sn.getAvailability();
    }

    public static int getTraceability(SecurityNeeds sn) {
        return sn == null ? 0 : sn.getTraceability();
    }

    public static Stream<FunctionalExchange> getAllocatingFunctionalExchanges(ExchangeItem ei) {
        return EObjectExt.getReferencers((EObject)ei, (EReference)FaPackage.Literals.FUNCTIONAL_EXCHANGE__EXCHANGED_ITEMS).stream().map(s -> (FunctionalExchange)s);
    }

    public static Stream<AbstractFunction> getAllocatingFunctions(ExchangeItem ei) {
        return EObjectExt.getReferencers((EObject)ei, (EReference)CybersecurityPackage.Literals.FUNCTION_STORAGE__EXCHANGED_ITEMS).stream().map(s -> (AbstractFunction)s.eContainer());
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(InformationPrimaryAsset pa) {
        return pa.getExchangeItems().stream().flatMap(ei -> CybersecurityQueries.getSupportingComponents(ei)).distinct();
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(ExchangeItem ei) {
        return Stream.concat(CybersecurityQueries.getAllocatingFunctions(ei).flatMap(af -> af.getAllocationBlocks().stream()), CybersecurityQueries.getAllocatingFunctionalExchanges(ei).flatMap(fe -> Stream.of((AbstractFunction)fe.getSourceFunctionOutputPort().eContainer(), (AbstractFunction)fe.getTargetFunctionInputPort().eContainer())).flatMap(af -> af.getAllocationBlocks().stream())).distinct();
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(FunctionalExchange fe) {
        return fe.getExchangedItems().stream().flatMap(ei -> CybersecurityQueries.getSupportingComponents(ei)).distinct();
    }

    public static Stream<ExchangeItem> getExchangeItems(ComponentExchange ce) {
        return ce.getAllocatedFunctionalExchanges().stream().flatMap(fe -> fe.getExchangedItems().stream()).distinct();
    }

    public static SecurityNeeds reduceSecurityNeeds(SecurityNeeds result, SecurityNeeds a) {
        result.setAvailability(Math.max(result.getAvailability(), a.getAvailability()));
        result.setConfidentiality(Math.max(result.getConfidentiality(), a.getConfidentiality()));
        result.setIntegrity(Math.max(result.getIntegrity(), a.getIntegrity()));
        result.setTraceability(Math.max(result.getTraceability(), a.getTraceability()));
        return result;
    }

    public static class AbstractFunction__ExchangeItems
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getExchangeItems((AbstractFunction)object).collect(Collectors.toList());
        }
    }

    public static class AbstractFunction__FunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getFunctionalPrimaryAssets((AbstractFunction)object).collect(Collectors.toList());
        }
    }

    public static class AbstractFunction__InformationPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((AbstractFunction)object).collect(Collectors.toList());
        }
    }

    public static class ComponentExchange__ExchangeItems
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getExchangeItems((ComponentExchange)object).collect(Collectors.toList());
        }
    }

    public static class ComponentExchange__InformationPrimaryAsset
    implements IQuery {
        public List<Object> compute(Object object) {
            return ((ComponentExchange)object).getAllocatedFunctionalExchanges().stream().flatMap(fe -> CybersecurityQueries.getInformationPrimaryAssets(fe)).collect(Collectors.toList());
        }
    }

    public static class ComponentExchange__TrustBoundary
    implements IQuery {
        public List<Object> compute(Object object) {
            return Collections.singletonList(CybersecurityQueries.isTrustBoundary((ComponentExchange)object));
        }
    }

    public static class Component__InvolvingThreats
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvingThreats((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__MaxCIAT
    implements IQuery {
        public List<Object> compute(Object object) {
            Stream<SecurityNeeds> fsn = CybersecurityQueries.getFunctionalPrimaryAssets((Component)object).flatMap(fpa -> fpa.getFunctions().stream()).flatMap(af -> af.getOwnedExtensions().stream()).filter(SecurityNeeds.class::isInstance).map(SecurityNeeds.class::cast);
            Stream<SecurityNeeds> isn = CybersecurityQueries.getInformationPrimaryAssets((Component)object).flatMap(ipa -> ipa.getExchangeItems().stream()).flatMap(ei -> ei.getOwnedExtensions().stream()).filter(SecurityNeeds.class::isInstance).map(SecurityNeeds.class::cast);
            SecurityNeeds max = Stream.concat(fsn, isn).reduce(CybersecurityFactory.eINSTANCE.createSecurityNeeds(), CybersecurityQueries::reduceSecurityNeeds);
            return Arrays.asList("Confidentiality: " + max.getConfidentiality(), "Integrity: " + max.getIntegrity(), "Availability: " + max.getAvailability(), "Traceability: " + max.getTraceability());
        }
    }

    public static class Component__SupportedFunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getFunctionalPrimaryAssets((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__SupportedInformationPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__ThreateningThreatSources
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreateningThreats((Component)object).flatMap(t -> CybersecurityQueries.getInvolvedThreatSources(t)).collect(Collectors.toList());
        }
    }

    public static class Component__ThreateningThreats
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreateningThreats((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__TrustBoundaries
    implements IQuery {
        public List<Object> compute(Object object) {
            Component c = (Component)object;
            Stream<ComponentExchange> tbCEs = ComponentExt.getAllRelatedComponentExchange((Component)c).stream().filter(ce -> CybersecurityQueries.isTrustBoundary(ce));
            Stream<FunctionalExchange> tbFEs = ComponentExt.getRelatedFunctionalExchanges((Component)c).stream().filter(fe -> CybersecurityQueries.isTrustBoundary(fe));
            Stream<FunctionalExchange> ownTBFEs = c.getAllocatedFunctions().stream().flatMap(af -> Stream.concat(af.getIncoming().stream(), af.getOutgoing().stream())).distinct().filter(FunctionalExchange.class::isInstance).map(FunctionalExchange.class::cast).filter(fe -> CybersecurityQueries.isTrustBoundary(fe));
            return Stream.concat(tbCEs, Stream.concat(tbFEs, ownTBFEs)).collect(Collectors.toList());
        }
    }

    public static class ExchangeItem__PrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((ExchangeItem)object).collect(Collectors.toList());
        }
    }

    public static class ExchangeItem__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((ExchangeItem)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalExchange__InformationPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((FunctionalExchange)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalExchange__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((FunctionalExchange)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalExchange__TrustBoundaries
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getTrustBoundaryBlocks((FunctionalExchange)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalPrimaryAsset__FunctionalExchanges
    implements IQuery {
        public List<Object> compute(Object object) {
            return ((FunctionalPrimaryAsset)object).getFunctions().stream().flatMap(af -> Stream.concat(af.getIncoming().stream(), af.getOutgoing().stream())).distinct().collect(Collectors.toList());
        }
    }

    public static class FunctionalPrimaryAsset__Functions
    implements IQuery {
        public List<Object> compute(Object object) {
            return new ArrayList<AbstractFunction>((Collection<AbstractFunction>)((FunctionalPrimaryAsset)object).getFunctions());
        }
    }

    public static class FunctionalPrimaryAsset__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((FunctionalPrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class InformationPrimaryAsset__ExchangeItems
    implements IQuery {
        public List<Object> compute(Object object) {
            return new ArrayList<ExchangeItem>((Collection<ExchangeItem>)((InformationPrimaryAsset)object).getExchangeItems());
        }
    }

    public static class InformationPrimaryAsset__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((InformationPrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class PrimaryAsset__Threats
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreatsOf((PrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class ThreatSource__ThreatenedComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvingThreats((Component)object).flatMap(t -> CybersecurityQueries.getThreatenedComponents(t)).distinct().collect(Collectors.toList());
        }
    }

    public static class Threat__InvolvedActors
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvedActors((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__InvolvedThreatSources
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvedThreatSources((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__ThreatenedComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreatenedComponents((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__ThreatenedPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreatenedPrimaryAssets((Threat)object).collect(Collectors.toList());
        }
    }
}

