/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.business.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.business.queries.BlockArchitecturePredicateQuery;

public abstract class CybersecurityRealizedElements
extends BlockArchitecturePredicateQuery {
    public CybersecurityRealizedElements(EReference theFeature, Predicate<EObject> adder, EClass extensionClass) {
        super(theFeature, adder, extensionClass);
    }

    public abstract EClass getExtensionClass();

    @Override
    public List<EObject> getCurrentElements(EObject element, boolean onlyGenerated) {
        List<EObject> currentElements = super.getCurrentElements(element, onlyGenerated);
        return this.getTargetElements(currentElements);
    }

    @Override
    public List<EObject> getAvailableElements(EObject element) {
        List<EObject> currentElements = this.getCurrentElements(element, false);
        List<EObject> availableElements = this.getAllAvailableElements(element);
        availableElements.removeAll(currentElements);
        return availableElements;
    }

    protected List<EObject> getTargetElements(List<EObject> list) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject obj : list) {
            if (!(obj instanceof TransfoLink)) continue;
            TransfoLink link = (TransfoLink)obj;
            result.add((EObject)link.getTarget());
        }
        return result;
    }

    private List<EObject> getAllAvailableElements(EObject element) {
        BlockArchitecture arch;
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (element != null && (arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)element)) != null) {
            for (BlockArchitecture block : arch.getAllocatedArchitectures()) {
                result.addAll(EObjectExt.getAll((EObject)block, (EClass)this.getExtensionClass()));
            }
        }
        return result;
    }
}

