/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.docgen.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.docgen.utils.HTMLHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CybersecurityHelper {
    public static boolean hasCybersecurityPropertyView(EObject element) {
        return element instanceof FunctionalChain || element instanceof ExchangeItem || element instanceof AbstractFunction || element instanceof Component;
    }

    public static String getThreatSourceAndRationale(EObject element) {
        StringBuilder builder = new StringBuilder();
        if (CybersecurityHelper.hasThreatSourceInfo(element)) {
            Optional<Integer> threatSourceProfile = ((CapellaElement)element).getOwnedExtensions().stream().filter(ext -> ext instanceof TrustBoundaryStorage).findAny().map(trb -> ((TrustBoundaryStorage)trb).getThreatSourceProfile());
            Boolean isThreatSource = ((CapellaElement)element).getOwnedExtensions().stream().filter(ext -> ext instanceof TrustBoundaryStorage).findAny().map(trb -> ((TrustBoundaryStorage)trb).isThreatSource()).orElse(false);
            Boolean isTrusted = ((CapellaElement)element).getOwnedExtensions().stream().filter(ext -> ext instanceof TrustBoundaryStorage).findAny().map(trb -> ((TrustBoundaryStorage)trb).isTrusted()).orElse(null);
            Optional<String> rationale = ((CapellaElement)element).getOwnedExtensions().stream().filter(ext -> ext instanceof TrustBoundaryStorage).findAny().map(trb -> ((TrustBoundaryStorage)trb).getRationale());
            ArrayList<String> listTrustBoundaryInfo = new ArrayList<String>();
            if (isTrusted == null || isTrusted.booleanValue()) {
                listTrustBoundaryInfo.add(HTMLHelper.getBold("Trusted"));
            } else {
                listTrustBoundaryInfo.add(HTMLHelper.getBold("Not Trusted"));
            }
            if (isThreatSource.booleanValue()) {
                listTrustBoundaryInfo.add(HTMLHelper.getBold("Threat Source"));
            }
            if (threatSourceProfile.isPresent()) {
                listTrustBoundaryInfo.add(HTMLHelper.getListElement("Threat Source Profile", threatSourceProfile.get().toString()));
            }
            if (listTrustBoundaryInfo.size() > 0) {
                builder.append(HTMLHelper.getSubtitle("Trust Boundary"));
                builder.append(HTMLHelper.getUlList(listTrustBoundaryInfo.toArray(new String[listTrustBoundaryInfo.size()])));
            }
            if (rationale.isPresent()) {
                builder.append(HTMLHelper.getSubtitle("Rationale"));
                builder.append(HTMLHelper.getParagraph(rationale.get().toString()));
            }
        }
        return builder.toString();
    }

    public static String getInvolvingThreats(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Component) {
            List threats = CybersecurityQueries.getInvolvingThreats((Component)((Component)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(threats, htmlFolderName, "Involving Threats");
        }
        return data;
    }

    public static String getExchangeItemPrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof ExchangeItem) {
            List assets = CybersecurityQueries.getInformationPrimaryAssets((ExchangeItem)((ExchangeItem)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, "Information Primary Assets");
        }
        return data;
    }

    public static String getFunctionalPrimaryAssetsTitle(EObject element) {
        if (BlockArchitectureExt.getRootBlockArchitecture((EObject)element) instanceof OperationalAnalysis) {
            return "Operational Analysis Primary Assets";
        }
        return "Functional Primary Assets";
    }

    public static String getFunctionFunctionalPrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof AbstractFunction) {
            List assets = CybersecurityQueries.getFunctionalPrimaryAssets((AbstractFunction)((AbstractFunction)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, CybersecurityHelper.getFunctionalPrimaryAssetsTitle(element));
        }
        return data;
    }

    public static String getFunctionInformationPrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof AbstractFunction) {
            List assets = CybersecurityQueries.getInformationPrimaryAssets((AbstractFunction)((AbstractFunction)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, "Information Primary Assets");
        }
        return data;
    }

    public static String getFunctionalChainPrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof FunctionalChain) {
            List assets = CybersecurityQueries.getFunctionalPrimaryAssets((FunctionalChain)((FunctionalChain)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, CybersecurityHelper.getFunctionalPrimaryAssetsTitle(element));
        }
        return data;
    }

    public static String getCiatSection(EObject element) {
        StringBuilder builder = new StringBuilder();
        if (CybersecurityHelper.hasCiat(element)) {
            Optional<SecurityNeeds> osn = ((ExtensibleElement)element).getOwnedExtensions().stream().filter(SecurityNeeds.class::isInstance).map(SecurityNeeds.class::cast).findAny();
            if (osn.isPresent()) {
                SecurityNeeds sn = osn.get();
                builder.append(HTMLHelper.getSubtitle("CIAT Security Need Level"));
                String confidentiality = CybersecurityHelper.getSecurityNeedValue(sn.getConfidentialityValue());
                String integrity = CybersecurityHelper.getSecurityNeedValue(sn.getIntegrityValue());
                String traceability = CybersecurityHelper.getSecurityNeedValue(sn.getTraceabilityValue());
                String availability = CybersecurityHelper.getSecurityNeedValue(sn.getAvailabilityValue());
                builder.append(HTMLHelper.getUlList(HTMLHelper.getListElement("Confidentiality", confidentiality), HTMLHelper.getListElement("Integrity", integrity), HTMLHelper.getListElement("Availability", availability), HTMLHelper.getListElement("Traceability", traceability)));
            }
        }
        return builder.toString();
    }

    public static String getContent(CapellaElement capellaElement, String htmlFolderName) {
        List<Class> allowedContent = Arrays.asList(Threat.class, FunctionalPrimaryAsset.class, InformationPrimaryAsset.class, EnterprisePrimaryAsset.class, CybersecurityPkg.class);
        List contentList = capellaElement.eContents().stream().filter(eobj -> allowedContent.stream().anyMatch(clazz -> clazz.isInstance(eobj))).map(eobj -> (CapellaElement)eobj).collect(Collectors.toList());
        return CybersecurityHelper.getHtmlDataToAppend(contentList, htmlFolderName, "Content");
    }

    public static String getThreatKind(EObject element) {
        StringBuilder builder = new StringBuilder();
        if (element instanceof Threat) {
            Threat threat = (Threat)element;
            String kind = threat.getKind().getLabel();
            builder.append(HTMLHelper.getSubtitle("Threat Kind"));
            builder.append(HTMLHelper.getParagraph(kind));
        }
        return builder.toString();
    }

    public static String getLevel(EObject element) {
        StringBuilder builder = new StringBuilder();
        if (element instanceof Threat) {
            Threat threat = (Threat)element;
            builder.append(HTMLHelper.getSubtitle("Level"));
            String level = String.valueOf(threat.getLevel());
            builder.append(HTMLHelper.getParagraph(level != null ? level : " "));
        }
        return builder.toString();
    }

    public static String getRationale(EObject element) {
        Threat threat;
        String rationale;
        StringBuilder builder = new StringBuilder();
        if (element instanceof Threat && (rationale = (threat = (Threat)element).getRationale()) != null) {
            builder.append(HTMLHelper.getSubtitle("Rationale"));
            builder.append(HTMLHelper.getParagraph(rationale));
        }
        return builder.toString();
    }

    public static String getRealizingPrimaryAsset(CapellaElement element, String htmlFolderName) {
        StringBuilder builder = new StringBuilder();
        if (CybersecurityHelper.hasRealizingPrimaryAsset((EObject)element)) {
            builder.append(CybersecurityHelper.getRelationsElements(element, "Realizing Primary Assets", htmlFolderName, true, PrimaryAsset.class));
        }
        return builder.toString();
    }

    public static String getRealizedPrimaryAsset(CapellaElement element, String htmlFolderName) {
        StringBuilder builder = new StringBuilder();
        if (CybersecurityHelper.hasRealizedPrimaryAsset((EObject)element)) {
            builder.append(CybersecurityHelper.getRelationsElements(element, "Realized Primary Assets", htmlFolderName, false, PrimaryAsset.class));
        }
        return builder.toString();
    }

    public static String getReferencedCapellaElement(CapellaElement element, String htmlFolderName) {
        StringBuilder builder = new StringBuilder();
        if (CybersecurityHelper.hasReferencesCapellaElement((EObject)element)) {
            builder.append(CybersecurityHelper.getRelationsElements(element, CybersecurityHelper.getReferencedCapellaElementTitle((EObject)element), htmlFolderName, false, FunctionalChain.class, ExchangeItem.class, AbstractFunction.class));
        }
        return builder.toString();
    }

    private static String getRelationsElements(CapellaElement capellaElement, String title, String htmlFolderName, boolean isIncoming, Class ... classes) {
        StringBuilder builder = new StringBuilder();
        List<Class> listOfClasses = Arrays.asList(classes);
        List<EObject> elements = CybersecurityHelper.getRelations(capellaElement, listOfClasses, isIncoming);
        if (elements.size() > 0) {
            builder.append(HTMLHelper.getSubtitle(title));
            builder.append(HTMLHelper.getUlList((String[])elements.stream().map(el -> HTMLHelper.getLinkElementList((CapellaElement)el, htmlFolderName)).toArray(String[]::new)));
        }
        return builder.toString();
    }

    private static boolean hasThreatSourceInfo(EObject element) {
        return element instanceof Component;
    }

    public static String getThreatenedBy(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof PrimaryAsset) {
            List threats = CybersecurityQueries.getThreatsOf((PrimaryAsset)((PrimaryAsset)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(threats, htmlFolderName, "Threatened By");
        }
        return data;
    }

    public static String getThreatenedPrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Threat) {
            List assets = CybersecurityQueries.getThreatenedPrimaryAssets((Threat)((Threat)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, "Threatened Primary Assets");
        }
        return data;
    }

    public static String getInvolvedActors(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Threat) {
            List actors = CybersecurityQueries.getInvolvedActors((Threat)((Threat)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(actors, htmlFolderName, "Involved Actors");
        }
        return data;
    }

    public static String getInvolvedThreatSources(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Threat) {
            List actors = CybersecurityQueries.getInvolvedThreatSources((Threat)((Threat)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(actors, htmlFolderName, "Involved Threat Sources");
        }
        return data;
    }

    public static String getPrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof EnterprisePrimaryAsset) {
            List assets = ((EnterprisePrimaryAsset)element).getPrimaryAssets().stream().collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, "Primary Assets");
        }
        return data;
    }

    public static String getReferencingEnterprisePrimaryAssets(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof PrimaryAsset) {
            List assets = CybersecurityQueries.getEnterprisePrimaryAssets((PrimaryAsset)((PrimaryAsset)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(assets, htmlFolderName, "Enterprise Primary Assets");
        }
        return data;
    }

    public static String getThreatsContent(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Threat) {
            AbstractCapability threat = (AbstractCapability)element;
            ArrayList elements = new ArrayList();
            elements.addAll(threat.getOwnedFunctionalChains());
            elements.addAll(threat.getOwnedScenarios());
            data = CybersecurityHelper.getHtmlDataToAppend(elements, htmlFolderName, "Content");
        }
        return data;
    }

    public static String getThreatSourceUse(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Component) {
            List used = CybersecurityQueries.getUsedActors((Component)((Component)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(used, htmlFolderName, "Uses");
        }
        return data;
    }

    public static String getThreatSourceUsedBy(EObject element, String htmlFolderName) {
        String data = "";
        if (element instanceof Component) {
            List used = CybersecurityQueries.getUsedByThreatSource((Component)((Component)element)).collect(Collectors.toList());
            data = CybersecurityHelper.getHtmlDataToAppend(used, htmlFolderName, "Used By");
        }
        return data;
    }

    public static String getHtmlDataToAppend(Collection<? extends CapellaElement> elements, String htmlFolderName, String category) {
        StringBuilder builder = new StringBuilder();
        if (!elements.isEmpty()) {
            builder.append(HTMLHelper.getSubtitle(category));
            builder.append(HTMLHelper.getUlList((String[])elements.stream().map(elem -> HTMLHelper.getLinkElementList(elem, htmlFolderName)).toArray(String[]::new)));
        }
        return builder.toString();
    }

    private static boolean hasCiat(EObject element) {
        return element instanceof AbstractFunction || element instanceof ExchangeItem || element instanceof PrimaryAsset || element instanceof Threat;
    }

    private static boolean hasRealizedPrimaryAsset(EObject element) {
        return element instanceof PrimaryAsset;
    }

    private static boolean hasReferencesCapellaElement(EObject element) {
        return element instanceof FunctionalPrimaryAsset || element instanceof InformationPrimaryAsset;
    }

    private static boolean hasRealizingPrimaryAsset(EObject element) {
        return element instanceof PrimaryAsset;
    }

    private static String getSecurityNeedValue(EnumerationPropertyLiteral literal) {
        if (literal != null) {
            return literal.getLabel();
        }
        return "0";
    }

    private static List<EObject> getRelations(CapellaElement capellaElement, List<Class> listOfClasses, boolean isIncoming) {
        EList traces = isIncoming ? capellaElement.getIncomingTraces() : capellaElement.getOutgoingTraces();
        List<EObject> elements = traces.stream().map(trace -> isIncoming ? trace.getSourceElement() : trace.getTargetElement()).filter(element -> listOfClasses.stream().anyMatch(clazz -> clazz.isInstance(element))).collect(Collectors.toList());
        if (listOfClasses.stream().anyMatch(clazz -> clazz.equals(ExchangeItem.class)) && !isIncoming) {
            elements.addAll(CybersecurityHelper.getOutgoingExchangeItem(capellaElement));
        }
        if (listOfClasses.stream().anyMatch(clazz -> clazz.equals(AbstractFunction.class)) && !isIncoming) {
            elements.addAll(CybersecurityHelper.getOutgoingFunctions(capellaElement));
        }
        if (listOfClasses.stream().anyMatch(clazz -> clazz.equals(AbstractFunction.class)) && !isIncoming) {
            elements.addAll(CybersecurityHelper.getOutgoingFunctionalChains(capellaElement));
        }
        return elements;
    }

    private static List<EObject> getOutgoingExchangeItem(CapellaElement capellaElement) {
        List<Object> exchangeItems = new ArrayList<EObject>();
        if (capellaElement instanceof InformationPrimaryAsset) {
            exchangeItems = ((InformationPrimaryAsset)capellaElement).getExchangeItems().stream().map(exchangeItem -> exchangeItem).collect(Collectors.toList());
        }
        return exchangeItems;
    }

    private static List<EObject> getOutgoingFunctions(CapellaElement capellaElement) {
        List<Object> functions = new ArrayList<EObject>();
        if (capellaElement instanceof FunctionalPrimaryAsset) {
            functions = ((FunctionalPrimaryAsset)capellaElement).getFunctions().stream().map(function -> function).collect(Collectors.toList());
        }
        return functions;
    }

    private static List<EObject> getOutgoingFunctionalChains(CapellaElement capellaElement) {
        List<Object> functionalChains = new ArrayList<EObject>();
        if (capellaElement instanceof FunctionalPrimaryAsset) {
            functionalChains = ((FunctionalPrimaryAsset)capellaElement).getFunctionalChains().stream().map(functionalChain -> functionalChain).collect(Collectors.toList());
        }
        return functionalChains;
    }

    private static String getReferencedCapellaElementTitle(EObject element) {
        if (element instanceof FunctionalPrimaryAsset) {
            BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
            if (ba instanceof OperationalAnalysis) {
                return "Operational Activities / Operational Processes";
            }
            return "Functions / Functional Chains";
        }
        if (element instanceof InformationPrimaryAsset) {
            return "Exchange Items";
        }
        throw new InternalError("This function cannot be applied on " + element.eClass().getName());
    }
}

