/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.command.PreDeleteHandler;
import org.polarsys.capella.core.model.handler.command.PreDeleteStructureCommand;
import org.polarsys.capella.core.model.handler.command.PreRemoveCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

class ModelOnlyFilteringDeleteCommand
extends CapellaDeleteCommand {
    private Set<Object> allElementsToDelete;
    private ExecutionManager executionManager2;

    public ModelOnlyFilteringDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction, boolean confirmDelete, boolean longOperationEvents) {
        super(executionManager, selection, ensureTransaction, confirmDelete, longOperationEvents);
        this.executionManager2 = executionManager;
    }

    public Set<?> getAllElementsToDelete() {
        if (this.allElementsToDelete == null) {
            HashSet<EObject> result = new HashSet<EObject>();
            PreDeleteHandler handler = new PreDeleteHandler();
            ModelOnlyPreDeleteStructureCommand preDeletion = new ModelOnlyPreDeleteStructureCommand((EditingDomain)this.executionManager2.getEditingDomain(), this.getExpandedSelection(), handler);
            if (preDeletion.canExecute()) {
                preDeletion.execute();
            }
            block6: for (Notification notification : handler.notifications) {
                Object notifier = notification.getNotifier();
                if (!(notifier instanceof EObject)) continue;
                Object oldValue = notification.getOldValue();
                int notificationType = notification.getEventType();
                switch (notificationType) {
                    case 1: {
                        if (notification.getNewValue() != null) continue block6;
                    }
                    case 4: {
                        if (!(oldValue instanceof EObject)) break;
                        boolean handleNotification = false;
                        try {
                            EReference feature = (EReference)EReference.class.cast(notification.getFeature());
                            handleNotification = feature.isContainment();
                        }
                        catch (ClassCastException exception) {
                            handleNotification = true;
                        }
                        if (!handleNotification) break;
                        EObject deletedObject = (EObject)oldValue;
                        result.add(deletedObject);
                        if (!CapellaResourceHelper.isSemanticElement((Object)deletedObject)) break;
                        TreeIterator allChildrenOfDeletedObject = deletedObject.eAllContents();
                        while (allChildrenOfDeletedObject.hasNext()) {
                            EObject child = (EObject)allChildrenOfDeletedObject.next();
                            result.add(child);
                        }
                        continue block6;
                    }
                }
            }
            handler.dispose();
            this.allElementsToDelete = Collections.unmodifiableSet(result);
        }
        return this.allElementsToDelete;
    }

    private class ModelOnlyPreDeleteStructureCommand
    extends PreDeleteStructureCommand {
        private PreDeleteHandler handler;

        public ModelOnlyPreDeleteStructureCommand(EditingDomain editingDomain, Collection<?> elements, PreDeleteHandler handler) {
            super(editingDomain, elements, handler);
            this.handler = handler;
        }

        protected void doPrepare() {
            this.append((Command)new PreRemoveCommand(this.getElementsToDelete(), this.handler));
        }

        protected Command doDeleteStructure(EObject sourceObject) {
            return new ModelOnlyPreDeleteStructureCommand(this.getEditingDomain(), Collections.singletonList(sourceObject), this.handler);
        }
    }
}

