/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.listeners;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.helpers.listeners.CapellaModelDataListener;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringDataListener
extends CapellaModelDataListener {
    private Map<FilteringCriterion, Collection<?>> implicitImpactCache = FilteringToolsPlugin.getImplicitImpactCache();

    public void notifyChanged(Notification msg) {
        if (msg == null) {
            return;
        }
        super.notifyChanged(msg);
        switch (msg.getEventType()) {
            case 4: 
            case 6: {
                this.handleRemoveCase(msg.getOldValue());
                break;
            }
            case 3: 
            case 5: {
                this.handleAddCase(msg.getNewValue());
                break;
            }
            case 1: {
                this.handleSetCase(msg.getNewValue());
                break;
            }
        }
    }

    private void handleSetCase(Object newValue) {
        if (newValue instanceof AssociatedFilteringCriterionSet) {
            this.removeFeatureFromCache((AssociatedFilteringCriterionSet)newValue);
        }
    }

    private void handleAddCase(Object newValue) {
        if (newValue instanceof AssociatedFilteringCriterionSet) {
            this.removeFeatureFromCache((AssociatedFilteringCriterionSet)newValue);
        }
        if (newValue instanceof FilteringCriterion) {
            this.implicitImpactCache.remove(newValue);
        } else if (newValue instanceof CapellaElement) {
            FilteringUtils.getImplicitAssociatedCriteria((EObject)newValue);
        }
    }

    private void handleRemoveCase(Object oldValue) {
        if (oldValue instanceof AssociatedFilteringCriterionSet) {
            this.removeFeatureFromCache((AssociatedFilteringCriterionSet)oldValue);
        } else if (oldValue instanceof FilteringModel) {
            FilteringToolsPlugin.getImplicitImpactCache().clear();
        } else if (oldValue instanceof FilteringCriterion) {
            FilteringToolsPlugin.getImplicitImpactCache().remove(oldValue);
        } else if (oldValue instanceof List) {
            for (Object elem : (List)oldValue) {
                this.handleRemoveCase(elem);
            }
        }
    }

    private void removeFeatureFromCache(AssociatedFilteringCriterionSet value) {
        EList features = value.getFilteringCriteria();
        for (FilteringCriterion feature : features) {
            FilteringToolsPlugin.getImplicitImpactCache().remove(feature);
        }
    }
}

