/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.misc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.ExclusionFilteringResultSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringFactory;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.IntersectionFilteringResultSet;
import org.polarsys.capella.filtering.UnionFilteringResultSet;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class FilteringUtilsTest
extends BasicTestCase {
    ComposedFilteringResult CR_1_AND_2;
    ComposedFilteringResult CR_1_OR_2;
    ComposedFilteringResult CR_1_OR_2_NOT_R3;
    FilteringResult R1;
    FilteringResult R2;
    FilteringResult R3;
    FilteringCriterion criteria1;
    FilteringCriterion criteria2;
    FilteringCriterion criteria3;
    FilteringCriterion criteria4;
    LogicalComponent RootLC;
    LogicalComponent LC1;
    LogicalComponent LC2;
    LogicalComponent LC3;
    LogicalComponent LC4;
    LogicalComponent LC5;
    LogicalComponent LC6;
    LogicalComponent LC7;
    LogicalComponent LC8;
    Set<LogicalComponent> ALL_LCs;

    public void setUp() throws Exception {
        super.setUp();
        this.criteria1 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria1.setName("criteria1");
        this.criteria2 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria2.setName("criteria2");
        this.criteria3 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria3.setName("criteria3");
        this.criteria4 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria4.setName("criteria4");
        this.LC1 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC1", this.criteria1);
        this.LC2 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC2", this.criteria1, this.criteria2);
        this.LC3 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC3", this.criteria3);
        this.LC4 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC4", this.criteria4);
        this.LC5 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC5", this.criteria1);
        this.LC6 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC6", this.criteria2);
        this.LC7 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC7", this.criteria3);
        this.LC8 = FilteringUtilsTest.createLogicalComponentWithAssociatedCriteria("LC8", this.criteria1, this.criteria3, this.criteria4);
        this.ALL_LCs = new HashSet<LogicalComponent>(Arrays.asList(this.LC1, this.LC2, this.LC3, this.LC4, this.LC5, this.LC6, this.LC7, this.LC8));
        this.RootLC = LaFactory.eINSTANCE.createLogicalComponent("RootLC");
        this.RootLC.getOwnedLogicalComponents().addAll(this.ALL_LCs);
        this.R1 = FilteringUtilsTest.createResultWithCriteria("R1", Arrays.asList(this.criteria1, this.criteria2));
        this.R2 = FilteringUtilsTest.createResultWithCriteria("R2", Arrays.asList(this.criteria2, this.criteria3));
        this.R3 = FilteringUtilsTest.createResultWithCriteria("R3", Arrays.asList(this.criteria3, this.criteria4));
        this.CR_1_AND_2 = this.createResultAsANDCompositionOf(this.R1, this.R2);
        this.CR_1_OR_2 = this.createResultAsORCompositionOf(this.R1, this.R2);
        this.CR_1_OR_2_NOT_R3 = this.createResultAsORCompositionThenNotOf(this.R1, this.R2, this.R3);
    }

    public void test() throws Exception {
        this.R1_GIVES_LC_1_2_5_6_8();
        this.R2_GIVES_LC_2_3_6_7_8();
        this.R3_GIVES_LC_3_4_7_8();
        this.R1_AND_R2_GIVES_LC_2_6_8();
        this.R1_OR_R2_GIVES_ALL_BUT_LC_4();
        this.R1_OR_R2_NOT_R3_GIVES_LC1_LC2_LC5_LC6();
    }

    private void R1_GIVES_LC_1_2_5_6_8() {
        Set actualDerivation = FilteringUtils.computeDerivation((FilteringResult)this.R1, (ModelElement)this.RootLC);
        HashSet<LogicalComponent> expectedDerivation = new HashSet<LogicalComponent>(Arrays.asList(this.LC1, this.LC2, this.LC5, this.LC6, this.LC8));
        FilteringUtilsTest.assertEquals(expectedDerivation, (Object)actualDerivation);
    }

    private void R2_GIVES_LC_2_3_6_7_8() {
        Set actualDerivation = FilteringUtils.computeDerivation((FilteringResult)this.R2, (ModelElement)this.RootLC);
        HashSet<LogicalComponent> expectedDerivation = new HashSet<LogicalComponent>(Arrays.asList(this.LC2, this.LC3, this.LC6, this.LC7, this.LC8));
        FilteringUtilsTest.assertEquals(expectedDerivation, (Object)actualDerivation);
    }

    private void R3_GIVES_LC_3_4_7_8() {
        Set actualDerivation = FilteringUtils.computeDerivation((FilteringResult)this.R3, (ModelElement)this.RootLC);
        HashSet<LogicalComponent> expectedDerivation = new HashSet<LogicalComponent>(Arrays.asList(this.LC3, this.LC4, this.LC7, this.LC8));
        FilteringUtilsTest.assertEquals(expectedDerivation, (Object)actualDerivation);
    }

    private void R1_AND_R2_GIVES_LC_2_6_8() {
        Set actualDerivation = FilteringUtils.computeDerivation((AbstractFilteringResult)this.CR_1_AND_2, (EObject)this.RootLC);
        HashSet<LogicalComponent> expectedDerivation = new HashSet<LogicalComponent>(Arrays.asList(this.LC2, this.LC6, this.LC8));
        FilteringUtilsTest.assertEquals(expectedDerivation, (Object)actualDerivation);
    }

    private void R1_OR_R2_GIVES_ALL_BUT_LC_4() {
        Set actualDerivation = FilteringUtils.computeDerivation((AbstractFilteringResult)this.CR_1_OR_2, (EObject)this.RootLC);
        HashSet<LogicalComponent> expectedDerivation = new HashSet<LogicalComponent>(this.ALL_LCs);
        expectedDerivation.remove(this.LC4);
        FilteringUtilsTest.assertEquals(expectedDerivation, (Object)actualDerivation);
    }

    private void R1_OR_R2_NOT_R3_GIVES_LC1_LC2_LC5_LC6() {
        Set actualDerivation = FilteringUtils.computeDerivation((AbstractFilteringResult)this.CR_1_OR_2_NOT_R3, (EObject)this.RootLC);
        HashSet<LogicalComponent> expectedDerivation = new HashSet<LogicalComponent>(Arrays.asList(this.LC1, this.LC2, this.LC5, this.LC6));
        FilteringUtilsTest.assertEquals(expectedDerivation, (Object)actualDerivation);
    }

    private static LogicalComponent createLogicalComponentWithAssociatedCriteria(String componentName, FilteringCriterion ... criterion) {
        LogicalComponent element = LaFactory.eINSTANCE.createLogicalComponent(componentName);
        FilteringUtils.addAssociatedCriteria((EObject)element, Arrays.asList(criterion));
        return element;
    }

    private static FilteringResult createResultWithCriteria(String name, List<FilteringCriterion> criterionList) {
        FilteringResult result = FilteringFactory.eINSTANCE.createFilteringResult();
        result.setName(name);
        result.getFilteringCriteria().addAll(criterionList);
        return result;
    }

    private ComposedFilteringResult createResultAsORCompositionOf(FilteringResult orResult2, FilteringResult orResult1) {
        ComposedFilteringResult composedResult = FilteringFactory.eINSTANCE.createComposedFilteringResult();
        UnionFilteringResultSet unionSet = FilteringFactory.eINSTANCE.createUnionFilteringResultSet();
        unionSet.getFilteringResults().addAll(Arrays.asList(orResult1, orResult2));
        composedResult.setUnionFilteringResultSet(unionSet);
        return composedResult;
    }

    private ComposedFilteringResult createResultAsANDCompositionOf(FilteringResult orResult2, FilteringResult orResult1) {
        ComposedFilteringResult composedResult = FilteringFactory.eINSTANCE.createComposedFilteringResult();
        IntersectionFilteringResultSet intersectionSet = FilteringFactory.eINSTANCE.createIntersectionFilteringResultSet();
        intersectionSet.getFilteringResults().addAll(Arrays.asList(orResult1, orResult2));
        composedResult.setIntersectionFilteringResultSet(intersectionSet);
        return composedResult;
    }

    private ComposedFilteringResult createResultAsORCompositionThenNotOf(FilteringResult orResult1, FilteringResult orResult2, FilteringResult notResult) {
        ComposedFilteringResult composedResult = FilteringFactory.eINSTANCE.createComposedFilteringResult();
        UnionFilteringResultSet unionSet = FilteringFactory.eINSTANCE.createUnionFilteringResultSet();
        unionSet.getFilteringResults().addAll(Arrays.asList(orResult1, orResult2));
        composedResult.setUnionFilteringResultSet(unionSet);
        ExclusionFilteringResultSet exclusionSet = FilteringFactory.eINSTANCE.createExclusionFilteringResultSet();
        exclusionSet.getFilteringResults().add((Object)notResult);
        composedResult.setExclusionFilteringResultSet(exclusionSet);
        return composedResult;
    }
}

