/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.decorators;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.sirius.ui.Activator;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.sirius.ui.decorators.CriteriaChangeListener;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class OptionalDecorator
implements IDecorator {
    DecorationEditPolicy.DecoratorTarget decoratorTarget;
    IDecoration labelDecoration;
    IDecoration imageDecoration;
    private CriteriaChangeListener changeListener;
    protected EObject notifier;

    public OptionalDecorator(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = (DecorationEditPolicy.DecoratorTarget)decoratorTarget;
        this.changeListener = new CriteriaChangeListener(this);
    }

    public void activate() {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.decoratorTarget.getAdapter(IGraphicalEditPart.class);
        EObject element = editPart.resolveSemanticElement();
        if (element instanceof DDiagramElement) {
            TransactionalEditingDomain editingDomain = TransactionHelper.getExecutionManager((EObject)element).getEditingDomain();
            for (CapellaElement melodyElement : FilteringSiriusUtils.getCapellaElements((DDiagramElement)element)) {
                this.notifier = melodyElement;
                DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain).addNotificationListener(this.notifier, (NotificationListener)this.changeListener);
                AssociatedFilteringCriterionSet associatedFeatureSet = FilteringUtils.getAssociatedFilteringCriterionSet((EObject)melodyElement);
                if (associatedFeatureSet == null) continue;
                DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain).addNotificationListener((EObject)associatedFeatureSet, (NotificationListener)this.changeListener);
            }
        }
    }

    public void deactivate() {
        if (this.notifier != null) {
            TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)this.notifier);
            if (editingDomain != null) {
                DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain).removeNotificationListener(this.notifier, (NotificationListener)this.changeListener);
            }
            this.notifier = null;
        }
        this.removeDecoration();
    }

    public void refresh() {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.decoratorTarget.getAdapter(IGraphicalEditPart.class);
        EObject element = editPart.resolveSemanticElement();
        if (element instanceof DDiagramElement && FilteringSiriusUtils.containsCapellaElements((DDiagramElement)element)) {
            this.removeDecoration();
            if (FilteringSiriusUtils.containsExplicitAssociatedCriteria((DDiagramElement)element)) {
                boolean isVolatile;
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(FilteringToolsPlugin.getDefault().getPluginId());
                boolean showLabelDecoration = prefs.getBoolean("FEATURES_DIAGRAM", false);
                boolean showImageDecoration = prefs.getBoolean("OPTIONAL_DIAGRAM", true);
                boolean saveDecoration = prefs.getBoolean("SAVE_DECORATORS_DIAGRAM", true);
                boolean bl = isVolatile = !saveDecoration;
                if (showLabelDecoration) {
                    Label label = new Label();
                    String text = FilteringSiriusUtils.getEnterSeparatedExplicitFeatures((DDiagramElement)element, true);
                    label.setText(text);
                    Font font = Display.getCurrent().getSystemFont();
                    label.setFont(font);
                    label.setForegroundColor(Display.getCurrent().getSystemColor(6));
                    Dimension labelPreferredSize = label.getPreferredSize();
                    int numberOfLines = text.split("\n").length;
                    int adjustement = numberOfLines * 2;
                    label.setSize(labelPreferredSize.width, labelPreferredSize.height + adjustement);
                    this.labelDecoration = element instanceof AbstractDNode || element instanceof NodeFigure ? this.decoratorTarget.addShapeDecoration((IFigure)label, IDecoratorTarget.Direction.EAST, 5, isVolatile) : this.decoratorTarget.addConnectionDecoration((IFigure)label, 67, isVolatile);
                }
                if (showImageDecoration) {
                    this.imageDecoration = element instanceof AbstractDNode || element instanceof NodeFigure ? this.decoratorTarget.addShapeDecoration(Activator.getDecoratorImage(), IDecoratorTarget.Direction.NORTH_EAST, -1, isVolatile) : this.decoratorTarget.addConnectionDecoration(Activator.getDecoratorImage(), 50, isVolatile);
                }
            }
        }
    }

    private void removeDecoration() {
        if (this.imageDecoration != null) {
            this.decoratorTarget.removeDecoration(this.imageDecoration);
            this.imageDecoration = null;
        }
        if (this.labelDecoration != null) {
            this.decoratorTarget.removeDecoration(this.labelDecoration);
            this.labelDecoration = null;
        }
    }
}

