/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractExportDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractRegExpViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.tools.Messages;
import org.polarsys.capella.filtering.tools.dialogs.FilteringLabelProvider;
import org.polarsys.capella.filtering.tools.dialogs.FilteringSorter;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringOverviewDialog
extends AbstractExportDialog {
    private CCombo combo;
    private EObject root = null;

    public FilteringOverviewDialog(Shell parentShell, String dialogTitle, String dialogMessage, EObject root, Collection<? extends EObject> elements) {
        super(parentShell, dialogTitle, dialogMessage, dialogTitle);
        this.root = root;
        this.setData(new TreeData(elements, null));
    }

    protected void doCreateDialogArea(Composite parent) {
        Composite containingComposite = new Composite(parent, 0);
        containingComposite.setLayout((Layout)new GridLayout(1, true));
        containingComposite.setLayoutData((Object)new GridData(1808));
        this.createStatusArea(containingComposite);
        super.doCreateDialogArea(containingComposite);
    }

    protected void createStatusArea(Composite parent) {
        boolean initialSelection = false;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        Label lbl = new Label(comp, 0);
        lbl.setText(Messages.filtering_dialog_combo_lbl);
        this.combo = new CCombo(comp, 2056);
        GridData gd = new GridData(4, 4, true, true);
        this.combo.setLayoutData((Object)gd);
        this.combo.add(Messages.filtering_dialog_combo_allStatus);
        this.combo.setData(String.valueOf(0), this.getData());
        List<FilteringModel> filteringModels = FilteringUtils.getFilteringModels(this.root, true);
        if (FilteringUtils.hasFilteringFeatures(filteringModels)) {
            int i = 0;
            int i0 = 0;
            for (FilteringCriterion criterion : FilteringUtils.getOwnedFilteringCriteria(filteringModels)) {
                this.combo.add(FilteringUtils.formatFilteringItemName((NamedElement)criterion));
                this.combo.setData(String.valueOf(++i), (Object)criterion);
            }
            this.combo.select(i0);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List allTaggedElements = ((TreeData)FilteringOverviewDialog.this.getData()).getValidElements();
                    ArrayList<EObject> returnData = new ArrayList<EObject>();
                    int comboFilterIndex = FilteringOverviewDialog.this.combo.getSelectionIndex();
                    FilteringCriterion selectedFeatureFilter = null;
                    if (comboFilterIndex != 0) {
                        selectedFeatureFilter = (FilteringCriterion)FilteringOverviewDialog.this.combo.getData(String.valueOf(comboFilterIndex));
                    }
                    for (EObject eobj : allTaggedElements) {
                        if (eobj instanceof AssociatedFilteringCriterionSet) continue;
                        if (selectedFeatureFilter == null) {
                            returnData.add(eobj);
                            continue;
                        }
                        for (FilteringCriterion feature : FilteringUtils.getExplicitAssociatedCriteria(eobj)) {
                            if (!feature.equals(selectedFeatureFilter)) continue;
                            returnData.add(eobj);
                        }
                    }
                    FilteringOverviewDialog.this.getViewer().setInput((Object)new TreeData(returnData, null));
                }
            });
        }
    }

    protected AbstractRegExpViewer createViewer(Composite parent) {
        TreeAndListViewer treeViewer = new TreeAndListViewer(parent, false, 2);
        TreeViewer viewer = treeViewer.getClientViewer();
        TreeViewerColumn columnViewer = new TreeViewerColumn(viewer, 16388);
        TreeColumn column = columnViewer.getColumn();
        column.setText(Messages.filtering_dialog_header_col0);
        column.setWidth(300);
        columnViewer = new TreeViewerColumn(viewer, 16388);
        column = columnViewer.getColumn();
        column.setText(Messages.filtering_dialog_header_col1);
        column.setWidth(150);
        viewer.getTree().setLinesVisible(true);
        viewer.getTree().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new DataContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FilteringLabelProvider(viewer, 9));
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setSorter((ViewerSorter)new FilteringSorter());
        return treeViewer;
    }

    protected List<String[]> getExportableData() {
        List result = super.getExportableData(EcoreUtil2.getProject((EObject)this.root).getName());
        List allTaggedElements = ((TreeData)this.getData()).getValidElements();
        for (EObject current : allTaggedElements) {
            CapellaElement me = (CapellaElement)current;
            ArrayList<String> row = new ArrayList<String>();
            row.add(current.eClass().getName());
            row.add(me.getFullLabel());
            row.add(me.getLabel());
            for (NamedElement namedElement : FilteringUtils.getExplicitAssociatedCriteria((EObject)me)) {
                row.add(namedElement.getName());
            }
            result.add(row.toArray(new String[row.size()]));
        }
        return result;
    }
}

