/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.extract;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;

public class FilteringExtractor {
    private static final String PATTERNS_FILE_EXTENSION = "patterns";
    private static final String MELODYCONNECTOR_FILE_EXTENSION = "melodyconnector";
    private static final NullProgressMonitor __MONITOR = new NullProgressMonitor();
    private static final IEclipsePreferences PREFS = InstanceScope.INSTANCE.getNode(FilteringToolsPlugin.getDefault().getPluginId());
    private static String _domainId;
    private static String _newId;
    private IProject _clonedProject;

    public FilteringExtractor(IProject clonedProject, String domainId) {
        this._clonedProject = clonedProject;
        _domainId = domainId;
        _newId = EcoreUtil.generateUUID();
    }

    public void cloneProjectNature(IProject currentProject) throws CoreException {
        String[] natures = currentProject.getDescription().getNatureIds();
        IProjectDescription description = this._clonedProject.getDescription();
        description.setNatureIds(natures);
        this._clonedProject.setDescription(description, null);
    }

    public Map<String, String> cloneModels(IProject currentProject) throws CoreException {
        HashMap<String, String> oldReferenceToNewReference = new HashMap<String, String>();
        IResource[] iResourceArray = currentProject.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath newPath;
            IResource resource = iResourceArray[n2];
            String ext = resource.getFileExtension();
            if ("capella".equals(ext) || "aird".equals(ext) || PATTERNS_FILE_EXTENSION.equals(ext) || "afm".equals(ext)) {
                newPath = this._clonedProject.getFullPath();
                newPath = newPath.addTrailingSeparator();
                newPath = newPath.append(this._clonedProject.getName());
                newPath = newPath.addFileExtension(ext);
                resource.copy(newPath, true, (IProgressMonitor)__MONITOR);
                if ("capella".equals(ext) || "afm".equals(ext)) {
                    oldReferenceToNewReference.put(resource.getName(), newPath.lastSegment());
                }
            } else if ((resource instanceof IFolder || resource instanceof IFile) && !this._clonedProject.exists(resource.getProjectRelativePath()) && !MELODYCONNECTOR_FILE_EXTENSION.equals(ext)) {
                newPath = this._clonedProject.getFullPath();
                newPath = newPath.addTrailingSeparator();
                newPath = newPath.append(resource.getProjectRelativePath());
                resource.copy(newPath, true, (IProgressMonitor)__MONITOR);
            }
            ++n2;
        }
        return oldReferenceToNewReference;
    }

    public void updateReferences(Map<String, String> oldReferenceToNewReference) throws CoreException, IOException {
        this.updateReferences((IContainer)this._clonedProject, oldReferenceToNewReference);
    }

    protected void updateReferences(IContainer container, Map<String, String> oldReferenceToNewReference) throws CoreException, IOException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (CapellaResourceHelper.isAirdResource((IResource)resource, (boolean)false) || CapellaResourceHelper.isCapellaResource((IResource)resource, (boolean)false)) {
                    this.replace(file, oldReferenceToNewReference);
                }
            } else if (resource instanceof IContainer) {
                this.updateReferences((IContainer)resource, oldReferenceToNewReference);
            }
            ++n2;
        }
    }

    protected void replace(IFile iFile, Map<String, String> oldReferenceToNewReference) throws IOException {
        File file = iFile.getRawLocation().toFile();
        Map<String, String> encodedOldReferenceToNewReference = FilteringExtractor.manageSpecialChars(oldReferenceToNewReference);
        FilteringExtractor.replace(file, encodedOldReferenceToNewReference);
    }

    public static void replace(File file, Map<String, String> oldReferenceToNewReference) throws IOException {
        File outputFile = File.createTempFile(file.getName(), "temp", file.getParentFile());
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader breader = new BufferedReader(reader);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (BufferedWriter bwriter = new BufferedWriter(writer);){
                String line;
                while ((line = breader.readLine()) != null) {
                    for (Map.Entry<String, String> entry : oldReferenceToNewReference.entrySet()) {
                        line = line.replace(entry.getKey(), entry.getValue());
                    }
                    if (PREFS.getBoolean("APPLICATION_PROJECT_WITH_DIFFERENT_ID", false)) {
                        line = line.replace(_domainId, _newId);
                    }
                    bwriter.write(line);
                    bwriter.newLine();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        FilteringExtractor.replaceFiles(file, outputFile);
    }

    public static boolean replaceFiles(File originalFile, File newFile) {
        if (!originalFile.isFile()) {
            return false;
        }
        boolean ok = originalFile.delete();
        if (!ok) {
            return false;
        }
        ok = newFile.renameTo(originalFile);
        if (!ok) {
            return false;
        }
        return originalFile.exists();
    }

    public static Map<String, String> manageSpecialChars(Map<String, String> oldReferenceToNewReference) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : oldReferenceToNewReference.entrySet()) {
            result.put(FilteringExtractor.manageSpecialChars(entry.getKey()), FilteringExtractor.manageSpecialChars(entry.getValue()));
        }
        return result;
    }

    public static String manageSpecialChars(String string) {
        String managed = new String(string.getBytes(StandardCharsets.UTF_8));
        managed = URI.encodeSegment((String)managed, (boolean)true);
        return managed;
    }
}

